/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.component.editor;

import com.jidesoft.swing.DefaultSplitButtonModel;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.URLUtil;
import ro.sync.ecss.component.editor.db;
import ro.sync.ecss.component.editor.gb;
import ro.sync.ecss.dom.eb;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.CursorType;
import ro.sync.ecss.extensions.api.editor.AbstractInplaceEditor;
import ro.sync.ecss.extensions.api.editor.AuthorInplaceContext;
import ro.sync.ecss.extensions.api.editor.EditingEvent;
import ro.sync.ecss.extensions.api.editor.InplaceRenderer;
import ro.sync.ecss.extensions.api.editor.RendererLayoutInfo;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.commons.editor.InplaceEditorUtil;
import ro.sync.exml.view.graphics.Font;
import ro.sync.exml.view.graphics.Point;
import ro.sync.i18n.d;
import ro.sync.i18n.r;
import ro.sync.ui.bf;
import ro.sync.ui.e.i;
import ro.sync.ui.ge;
import ro.sync.ui.h.b;
import ro.sync.ui.hd;
import ro.sync.ui.jb;
import ro.sync.ui.pe;
import ro.sync.ui.theme.l;
import ro.sync.ui.theme.o;
import ro.sync.ui.zd;
import ro.sync.util.SimpleFileFilter;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class InputURLEditor
extends AbstractInplaceEditor
implements InplaceRenderer,
gb {
    private static final Logger kiy = LoggerFactory.getLogger((String)InputURLEditor.class.getName());
    protected static final d messages = r.m();
    private boolean iiy;
    private _b jiy = new _b(null, null, false, null);
    private DocumentListener hiy;
    private boolean ciy;
    private final Color giy;
    private final java.awt.Font diy;
    private ItemListener fiy;
    private AuthorAccess eiy;

    public InputURLEditor() {
        this.jiy.setOpaque(false);
        this.jiy.qxc(null);
        this.hiy = new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent documentEvent) {
                InputURLEditor.this.fireEditingOccured();
            }

            @Override
            public void removeUpdate(DocumentEvent documentEvent) {
                InputURLEditor.this.fireEditingOccured();
            }

            @Override
            public void changedUpdate(DocumentEvent documentEvent) {
                InputURLEditor.this.fireEditingOccured();
            }
        };
        this.fiy = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                InputURLEditor.this.fireEditingOccured();
                if (itemEvent.getStateChange() == 1) {
                    i i2 = InputURLEditor.this.jiy.gzc();
                    java.awt.Point point = i2.getLocation();
                    InputURLEditor.this.fireCommitValue(new EditingEvent((String)InputURLEditor.this.getValue()));
                    if (!point.equals(i2.getLocation())) {
                        i2.hidePopup();
                    }
                }
            }
        };
        this.giy = this.jiy.gzc().getForeground();
        this.diy = this.jiy.gzc().getFont();
    }

    private void usp(final AuthorInplaceContext authorInplaceContext, boolean bl) {
        Object object;
        Serializable serializable;
        Serializable serializable2;
        Object object2;
        this.jiy.gzc().removeAllItems();
        this.jiy.uxc("");
        this.osp(authorInplaceContext, bl);
        this.jiy.jzc(new zd(){

            @Override
            public URL yab() {
                URL uRL = authorInplaceContext.getAuthorAccess().getEditorAccess().getEditorLocation();
                AuthorElement authorElement = authorInplaceContext.getElem();
                if (eb.p(authorElement, false)) {
                    uRL = authorElement.getXMLBaseURL();
                }
                return uRL;
            }
        });
        String string = (String)authorInplaceContext.getArguments().get("fileFilter");
        if (string != null) {
            string = string.replaceAll("\\s+", "");
            object2 = string.split(",");
            serializable2 = new LinkedHashSet();
            for (int i2 = 0; i2 < ((Object)object2).length; ++i2) {
                if (((String)object2[i2]).equals("")) continue;
                serializable2.add(object2[i2]);
            }
            if (serializable2.size() > 0) {
                this.jiy.qzc(new SimpleFileFilter(serializable2.toArray(new String[0]), null));
            } else {
                this.jiy.qzc(null);
            }
        } else {
            this.jiy.qzc(null);
        }
        object2 = (Font)authorInplaceContext.getArguments().get("font");
        if (object2 != null) {
            serializable2 = new java.awt.Font(((Font)object2).getName(), ((Font)object2).getStyle(), ((Font)object2).getSize());
            this.jiy.gzc().setFont((java.awt.Font)serializable2);
        } else {
            this.jiy.gzc().setFont(this.diy);
        }
        if (bl) {
            this.jiy.wxc();
        }
        this.jiy.gzc().setPreferredSize(null);
        this.jiy.gzc().setMinimumSize(null);
        serializable2 = new Dimension(300, this.jiy.gzc().getPreferredSize().height);
        this.jiy.gzc().setPreferredSize((Dimension)serializable2);
        this.jiy.gzc().setMinimumSize((Dimension)serializable2);
        ro.sync.exml.view.graphics.Dimension dimension = InplaceEditorUtil.getPreferredSize(this.jiy, authorInplaceContext);
        this.jiy.setSize(dimension.width, dimension.height);
        this.jiy.doLayout();
        i i3 = this.jiy.gzc();
        ((Container)i3).doLayout();
        InplaceEditorUtil.setCaretAtEnd((JTextComponent)i3.getEditor().getEditorComponent(), authorInplaceContext);
        if (bl) {
            serializable = (JTextComponent)this.jiy.gzc().getEditor().getEditorComponent();
            object = new FocusAdapter(){

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (!(InputURLEditor.this.jiy.fad().isPopupMenuVisible() || InputURLEditor.this.iiy || focusEvent.getOppositeComponent() != null && SwingUtilities.isDescendingFrom(focusEvent.getOppositeComponent(), InputURLEditor.this.jiy))) {
                        if (kiy.isDebugEnabled()) {
                            kiy.debug("Focus lost, stop editing. Opp comp: " + focusEvent.getOppositeComponent());
                        }
                        InputURLEditor.this.fireCommitValue(new EditingEvent((String)InputURLEditor.this.getValue()));
                    }
                }
            };
            ((Component)serializable).addFocusListener((FocusListener)object);
            ((JTextComponent)serializable).getDocument().addDocumentListener(this.hiy);
            this.jiy.gzc().addItemListener(this.fiy);
            ((Component)serializable).addKeyListener(new KeyAdapter((JTextComponent)serializable, (FocusAdapter)object){
                final /* synthetic */ JTextComponent d;
                final /* synthetic */ FocusAdapter c;
                {
                    this.d = jTextComponent;
                    this.c = focusAdapter;
                }

                @Override
                public void keyPressed(KeyEvent keyEvent) {
                    if (!InputURLEditor.this.jiy.gzc().isPopupVisible()) {
                        if (keyEvent.getKeyCode() == 27) {
                            keyEvent.consume();
                            this.d.removeFocusListener(this.c);
                            InputURLEditor.this.fireEditingCanceled();
                        } else if (keyEvent.getKeyCode() == 10) {
                            keyEvent.consume();
                            this.d.removeFocusListener(this.c);
                            InputURLEditor.this.fireEditingOccured();
                            InputURLEditor.this.fireNextEditLocationRequested();
                        }
                    }
                }
            });
        }
        if (!bl) {
            serializable = new MouseEvent(i3, 505, System.currentTimeMillis(), 0, 0, 0, 1, false);
            i3.dispatchEvent((AWTEvent)serializable);
            object = this.jiy.fad();
            DefaultSplitButtonModel defaultSplitButtonModel = (DefaultSplitButtonModel)object.getModel();
            defaultSplitButtonModel.setButtonRollover(false);
            defaultSplitButtonModel.setButtonSelected(false);
            Point point = authorInplaceContext.getRelativeMouseLocation();
            if (point != null) {
                int n2 = point.x;
                int n3 = point.y;
                Component component = this.jiy.getComponentAt(n2, n3);
                if (component instanceof JComboBox) {
                    if ((component = i3.getComponentAt(n2 - component.getX(), n3 - component.getY())) != null) {
                        serializable = new MouseEvent(component, 504, System.currentTimeMillis(), 0, point.x - component.getX(), point.y - component.getY(), 1, false);
                        component.dispatchEvent((AWTEvent)serializable);
                    }
                } else if (component instanceof b) {
                    defaultSplitButtonModel.setButtonRollover(true);
                    defaultSplitButtonModel.setButtonSelected(true);
                }
            }
        }
    }

    private void osp(AuthorInplaceContext authorInplaceContext, boolean bl) {
        String string = (String)authorInplaceContext.getArguments().get("initial_value");
        ro.sync.exml.view.graphics.Color color = (ro.sync.exml.view.graphics.Color)authorInplaceContext.getArguments().get("color");
        Component component = this.jiy.gzc().getEditor().getEditorComponent();
        if (color != null) {
            component.setForeground(new Color(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()));
        } else {
            this.jiy.gzc().getEditor().getEditorComponent().setForeground(this.giy);
        }
        if (!bl && string == null) {
            component.setForeground(l.e(o.getInstance().getInactiveTextColor()));
            string = (String)authorInplaceContext.getArguments().get("default_value");
        }
        if (string == null) {
            string = bl ? "" : " ";
        }
        this.jiy.uxc(URLUtil.uncorrect((String)string));
    }

    @Override
    public Object getEditorComponent(AuthorInplaceContext authorInplaceContext, ro.sync.exml.view.graphics.Rectangle rectangle, Point point) {
        this.usp(authorInplaceContext, true);
        this.eiy = authorInplaceContext.getAuthorAccess();
        this.ciy = point != null;
        return this.jiy;
    }

    @Override
    public ro.sync.exml.view.graphics.Rectangle getScrollRectangle() {
        ro.sync.exml.view.graphics.Rectangle rectangle = null;
        i i2 = this.jiy.gzc();
        if (i2.isEditable()) {
            JTextComponent jTextComponent = (JTextComponent)i2.getEditor().getEditorComponent();
            try {
                java.awt.Point point;
                Rectangle rectangle2 = jTextComponent.modelToView(jTextComponent.getCaretPosition());
                if (rectangle2 != null && (point = bf.lb(jTextComponent, new java.awt.Point(rectangle2.x, rectangle2.y), i2)) != null) {
                    rectangle = new ro.sync.exml.view.graphics.Rectangle(point.x, point.y, rectangle2.width, rectangle2.height);
                }
            }
            catch (BadLocationException badLocationException) {
                kiy.error((Object)badLocationException, (Throwable)badLocationException);
            }
        }
        return rectangle;
    }

    @Override
    public void requestFocus() {
        if (!this.ciy) {
            this.jiy.gzc().requestFocus();
        }
    }

    @Override
    public Object getValue() {
        String string = null;
        try {
            URL uRL = this.jiy.oyc();
            string = this.psp(uRL);
        }
        catch (MalformedURLException malformedURLException) {
            string = this.jiy.nyc();
        }
        if (string == null) {
            string = "";
        }
        return string;
    }

    private String psp(URL uRL) {
        String string = null;
        if (uRL != null) {
            uRL = this.eiy.getUtilAccess().removeUserCredentials(uRL);
            URL uRL2 = this.eiy.getEditorAccess().getEditorLocation();
            zd zd2 = this.jiy.xzc();
            if (zd2 != null) {
                uRL2 = zd2.yab();
            }
            string = this.eiy.getUtilAccess().makeRelative(uRL2, uRL);
        }
        return string;
    }

    @Override
    public void stopEditing() {
        this.fireEditingStopped(new EditingEvent((String)this.getValue(), true));
    }

    @Override
    public void commitValue() {
        this.fireCommitValue(new EditingEvent((String)this.getValue()));
    }

    @Override
    public void cancelEditing() {
        this.fireEditingCanceled();
    }

    @Override
    public String getDescription() {
        return "An input URL panel form control.";
    }

    @Override
    public Object getRendererComponent(AuthorInplaceContext authorInplaceContext) {
        this.usp(authorInplaceContext, false);
        return this.jiy;
    }

    @Override
    public CursorType getCursorType(AuthorInplaceContext authorInplaceContext, int n2, int n3) {
        return null;
    }

    @Override
    public CursorType getCursorType(int n2, int n3) {
        return null;
    }

    @Override
    public String getTooltipText(AuthorInplaceContext authorInplaceContext, int n2, int n3) {
        JComboBox jComboBox;
        Object object;
        this.usp(authorInplaceContext, false);
        String string = messages.getString("Browse");
        Component component = this.jiy.getComponentAt(n2, n3);
        if (component instanceof JComboBox && (object = (jComboBox = (JComboBox)component).getSelectedItem()) != null) {
            string = object.toString();
        }
        return string;
    }

    @Override
    public RendererLayoutInfo getRenderingInfo(AuthorInplaceContext authorInplaceContext) {
        this.usp(authorInplaceContext, false);
        i i2 = this.jiy.gzc();
        int n2 = db.b(i2, i2.getPreferredSize().width, i2.getPreferredSize().height);
        RendererLayoutInfo rendererLayoutInfo = new RendererLayoutInfo(n2 += i2.getY(), new ro.sync.exml.view.graphics.Dimension(this.jiy.getSize().width, this.jiy.getSize().height));
        return rendererLayoutInfo;
    }

    @Override
    public void dump(AuthorInplaceContext authorInplaceContext, StringBuilder stringBuilder) {
        this.usp(authorInplaceContext, false);
        stringBuilder.append(" value: " + this.jiy.nyc());
        stringBuilder.append(" color: " + this.jiy.gzc().getEditor().getEditorComponent().getForeground());
    }

    @Override
    public void refresh(AuthorInplaceContext authorInplaceContext) {
        this.osp(authorInplaceContext, true);
    }

    @Override
    public boolean insertContent(String string) {
        boolean bl = false;
        Component component = this.jiy.gzc().getEditor().getEditorComponent();
        if (component instanceof JTextComponent) {
            JTextComponent jTextComponent = (JTextComponent)component;
            try {
                jTextComponent.getDocument().insertString(jTextComponent.getCaretPosition(), string, null);
                bl = true;
            }
            catch (BadLocationException badLocationException) {
                kiy.error((Object)badLocationException, (Throwable)badLocationException);
            }
        }
        return bl;
    }

    private class _b
    extends ge {
        public _b(SimpleFileFilter simpleFileFilter, String[] stringArray, boolean bl, String string) {
            super(simpleFileFilter, stringArray, bl, string);
            this.wge.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    bf.s(new Runnable(){

                        @Override
                        public void run() {
                            if (!InputURLEditor.this.iiy) {
                                _b.this.gzc().requestFocus();
                            }
                        }
                    });
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    this.popupMenuWillBecomeInvisible(popupMenuEvent);
                }
            });
            JTextComponent jTextComponent = (JTextComponent)this.gzc().getEditor().getEditorComponent();
            this.setFocusTraversalPolicyProvider(true);
            ArrayList<Component> arrayList = new ArrayList<Component>();
            arrayList.add(jTextComponent);
            arrayList.add((Component)((Object)this.wge));
            this.setFocusTraversalPolicy(new jb(this, arrayList, arrayList.isEmpty() ? null : (Component)arrayList.get(0), false));
        }

        @Override
        public pe fad() {
            return this.wge;
        }

        @Override
        protected void ayc(List<Action> list) {
            super.ayc(list);
            ArrayList<Action> arrayList = new ArrayList<Action>(list);
            list.clear();
            for (Action action : arrayList) {
                list.add(new hd(action){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        try {
                            InputURLEditor.this.iiy = true;
                            super.actionPerformed(actionEvent);
                        }
                        finally {
                            InputURLEditor.this.iiy = false;
                            _b.this.gzc().requestFocus();
                        }
                    }
                });
            }
        }

        @Override
        protected String nad(URL uRL) {
            return InputURLEditor.this.psp(uRL);
        }
    }
}

