/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.contentcompletion.xml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.xml.BasicXmlUtil;
import ro.sync.contentcompletion.xml.CIAttribute;
import ro.sync.contentcompletion.xml.CIElement;
import ro.sync.contentcompletion.xml.Context;
import ro.sync.contentcompletion.xml.SchemaManagerFilterBase;
import ro.sync.contentcompletion.xml.WhatAttributesCanGoHereContext;
import ro.sync.contentcompletion.xml.WhatElementsCanGoHereContext;
import ro.sync.contentcompletion.xml.WhatPossibleValuesHasAttributeContext;
import ro.sync.contentcompletion.xml.r;
import ro.sync.contentcompletion.xml.styleguide.StyleGuideAnnotation;
import ro.sync.contentcompletion.xml.styleguide.StyleGuideLinkDescriptor;
import ro.sync.contentcompletion.xml.styleguide.b;
import ro.sync.exml.view.graphics.f;
import ro.sync.i18n.d;
import ro.sync.ui.application.kb;
import ro.sync.ui.theme.o;

@API(type=APIType.EXTENDABLE, src=SourceType.PUBLIC)
@SkipObfuscate
public abstract class StyleGuideSchemaManagerFilterBase
extends SchemaManagerFilterBase {
    protected static final d messages = ro.sync.i18n.r.m();
    private static final Logger logger = LoggerFactory.getLogger(StyleGuideSchemaManagerFilterBase.class);
    private String locationOfMappingFile;
    private static final Map<String, Map<String, StyleGuideAnnotation>> STYLE_GUIDE_ELEM_TO_HTML_CONTENT = new ConcurrentHashMap<String, Map<String, StyleGuideAnnotation>>();

    public StyleGuideSchemaManagerFilterBase() {
    }

    public StyleGuideSchemaManagerFilterBase(String string) {
        this.locationOfMappingFile = string;
    }

    @Override
    public List<CIElement> filterElements(List<CIElement> list, WhatElementsCanGoHereContext whatElementsCanGoHereContext) {
        if (list != null) {
            String string = this.getMappingFileLocation(whatElementsCanGoHereContext);
            for (CIElement cIElement : list) {
                StyleGuideAnnotation styleGuideAnnotation;
                if (cIElement == null || (styleGuideAnnotation = this.getHTMLDocumentation(cIElement.getName(), string)) == null) continue;
                try {
                    if (cIElement instanceof r && ((r)cIElement).b()) continue;
                    cIElement.setAnnotation(this.mergeExistingAnnotation(cIElement.getAnnotation(), styleGuideAnnotation));
                }
                catch (Exception exception) {
                    logger.error((Object)exception, (Throwable)exception);
                }
            }
        }
        return list;
    }

    protected String getMappingFileLocation(Context context) {
        return this.locationOfMappingFile;
    }

    private String mergeExistingAnnotation(String string, StyleGuideAnnotation styleGuideAnnotation) {
        List<StyleGuideLinkDescriptor> list;
        if (styleGuideAnnotation.getHtmlContent() != null) {
            string = styleGuideAnnotation.getHtmlContent();
        }
        if (!(list = styleGuideAnnotation.getLinkDescriptors()).isEmpty()) {
            int n2;
            StringBuilder stringBuilder = new StringBuilder();
            if (string != null) {
                n2 = string.indexOf("</body>");
                if (n2 == -1) {
                    stringBuilder.append("<html><body>");
                    string = BasicXmlUtil.escape((String)string);
                    string = string.replaceAll("\n", "<br />");
                    stringBuilder.append("<div>").append(string).append("</div>\n");
                } else {
                    stringBuilder.append(string.substring(0, n2));
                }
            } else {
                stringBuilder.append("<html><body>");
            }
            n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                StyleGuideLinkDescriptor styleGuideLinkDescriptor = list.get(i2);
                String string2 = f.b(o.getInstance().getLinkForegroundColor(false));
                String string3 = "<a href=\"" + styleGuideLinkDescriptor.getTarget() + "\"" + " color=\"" + string2 + "\">" + styleGuideLinkDescriptor.getLinkText() + "</a>";
                if (stringBuilder.toString().indexOf(string3) != -1) continue;
                stringBuilder.append("<div>");
                stringBuilder.append(string3);
                stringBuilder.append("</div>");
            }
            stringBuilder.append("</body></html>");
            string = stringBuilder.toString();
        }
        return string;
    }

    @Override
    public List<CIAttribute> filterAttributes(List<CIAttribute> list, WhatAttributesCanGoHereContext whatAttributesCanGoHereContext) {
        if (list != null) {
            for (CIAttribute cIAttribute : list) {
                StyleGuideAnnotation styleGuideAnnotation = this.getHTMLDocumentationForAttribute(cIAttribute.getName(), whatAttributesCanGoHereContext.getParentElement().getQName(), this.getMappingFileLocation(whatAttributesCanGoHereContext));
                if (styleGuideAnnotation == null) continue;
                String string = this.mergeExistingAnnotation(cIAttribute.getAnnotation(), styleGuideAnnotation);
                cIAttribute.setAnnotation(string);
            }
        }
        return list;
    }

    @Override
    public CIElement getElementDescription(CIElement cIElement, Context context) {
        StyleGuideAnnotation styleGuideAnnotation;
        if (cIElement != null && (styleGuideAnnotation = this.getHTMLDocumentation(cIElement.getName(), this.getMappingFileLocation(context))) != null) {
            try {
                if (!(cIElement instanceof r) || !((r)cIElement).b()) {
                    cIElement.setAnnotation(this.mergeExistingAnnotation(cIElement.getAnnotation(), styleGuideAnnotation));
                }
            }
            catch (Exception exception) {
                logger.error((Object)exception, (Throwable)exception);
            }
        }
        return cIElement;
    }

    @Override
    public CIAttribute getAttributeDescription(CIAttribute cIAttribute, WhatPossibleValuesHasAttributeContext whatPossibleValuesHasAttributeContext) {
        StyleGuideAnnotation styleGuideAnnotation;
        if (cIAttribute != null && (styleGuideAnnotation = this.getHTMLDocumentationForAttribute(cIAttribute.getName(), whatPossibleValuesHasAttributeContext.getParentElement().getQName(), this.getMappingFileLocation(whatPossibleValuesHasAttributeContext))) != null) {
            cIAttribute.setAnnotation(this.mergeExistingAnnotation(cIAttribute.getAnnotation(), styleGuideAnnotation));
        }
        return cIAttribute;
    }

    StyleGuideAnnotation getHTMLDocumentation(String string, String string2) {
        string = BasicXmlUtil.getLocalName((String)string);
        return this.getDocumentation(string2).get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, StyleGuideAnnotation> getDocumentation(String string) {
        Map<String, Map<String, StyleGuideAnnotation>> map = STYLE_GUIDE_ELEM_TO_HTML_CONTENT;
        synchronized (map) {
            Map<String, StyleGuideAnnotation> map2 = STYLE_GUIDE_ELEM_TO_HTML_CONTENT.get(string);
            if (map2 == null) {
                this.parseStyleGuideConfigurationMap(string);
                map2 = STYLE_GUIDE_ELEM_TO_HTML_CONTENT.get(string);
            }
            return map2;
        }
    }

    StyleGuideAnnotation getHTMLDocumentationForAttribute(String string, String string2, String string3) {
        string2 = BasicXmlUtil.getLocalName((String)string2);
        string = BasicXmlUtil.getLocalName((String)string);
        Map<String, StyleGuideAnnotation> map = this.getDocumentation(string3);
        StyleGuideAnnotation styleGuideAnnotation = map.get(string2 + "/@" + string);
        if (styleGuideAnnotation == null) {
            styleGuideAnnotation = map.get("@" + string);
        }
        return styleGuideAnnotation;
    }

    @Override
    public void invalidate() {
        STYLE_GUIDE_ELEM_TO_HTML_CONTENT.clear();
    }

    synchronized void parseStyleGuideConfigurationMap(final String string) {
        final HashMap hashMap = new HashMap();
        STYLE_GUIDE_ELEM_TO_HTML_CONTENT.put(string, hashMap);
        kb kb2 = new kb("Download style guide mapping files"){

            @Override
            protected void xig() {
                try {
                    String string2 = null;
                    if (StyleGuideSchemaManagerFilterBase.this.shouldRedirectThroughOxygenWebSite()) {
                        string2 = "https://www.oxygenxml.com/redirect-url.php?url=";
                    }
                    new b().c(string, string2, hashMap);
                }
                catch (Exception exception) {
                    logger.error((Object)exception, (Throwable)exception);
                }
            }
        };
        kb2.setPriority(1);
        kb2.start();
        try {
            kb2.join(1500L);
        }
        catch (InterruptedException interruptedException) {
            logger.debug((Object)interruptedException, (Throwable)interruptedException);
        }
    }

    protected boolean shouldRedirectThroughOxygenWebSite() {
        return false;
    }
}

