/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.util.Collections;
import java.util.List;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.loader.AbstractSchemaExtractor;
import org.everit.json.schema.loader.ReferenceLookup;
import org.everit.json.schema.loader.SchemaLoader;

class ReferenceSchemaExtractor
extends AbstractSchemaExtractor {
    ReferenceSchemaExtractor(SchemaLoader defaultLoader) {
        super(defaultLoader);
    }

    @Override
    List<Schema.Builder<?>> extract() {
        if (this.containsKey("$ref")) {
            String ref = this.require("$ref").requireString();
            ref = ref.replaceAll("\"", "%22");
            try {
                return Collections.singletonList(new ReferenceLookup(this.schemaJson.ls).lookup(ref, this.schemaJson));
            }
            catch (SchemaException ex) {
                if (!ex.isDifferentLocation() && ex.getMessage() != null && ex.getMessage().endsWith("] not found")) {
                    ex.setSchemaLocation(this.schemaJson.ls.locationOfCurrentObj().concat("/$ref"));
                }
                throw ex;
            }
            catch (Exception ex) {
                throw new SchemaException(this.schemaJson.ls.locationOfCurrentObj().concat("/$ref"), ex.getMessage());
            }
        }
        if (this.containsKey("$dynamicRef")) {
            String ref = this.require("$dynamicRef").requireString();
            ref = ref.replaceAll("\"", "%22");
            try {
                return Collections.singletonList(new ReferenceLookup(this.schemaJson.ls).lookup(ref, this.schemaJson));
            }
            catch (SchemaException ex) {
                if (!ex.isDifferentLocation() && ex.getMessage() != null && ex.getMessage().endsWith("] not found")) {
                    ex.setSchemaLocation(this.schemaJson.ls.locationOfCurrentObj().concat("/$dynamicRef"));
                }
                throw ex;
            }
            catch (Exception ex) {
                throw new SchemaException(this.schemaJson.ls.locationOfCurrentObj().concat("/$dynamicRef"), ex.getMessage());
            }
        }
        return Collections.emptyList();
    }
}

