/*
 * Decompiled with CFR 0.152.
 */
package org.everit.json.schema.loader;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class OrgJsonUtil {
    public static Map<String, Object> toMap(JSONObject obj) {
        LinkedHashMap<String, Object> rval = new LinkedHashMap<String, Object>(obj.length());
        Iterator keyIt = obj.keys();
        while (keyIt.hasNext()) {
            String key = (String)keyIt.next();
            Object rawValue = obj.get(key);
            Object convertedValue = OrgJsonUtil.convertValue(rawValue);
            rval.put(key, convertedValue);
        }
        return rval;
    }

    static Object convertValue(Object rawValue) {
        Object convertedValue = rawValue instanceof JSONObject ? OrgJsonUtil.toMap((JSONObject)rawValue) : (rawValue instanceof JSONArray ? OrgJsonUtil.toList((JSONArray)rawValue) : rawValue);
        return convertedValue;
    }

    public static List<Object> toList(JSONArray arr) {
        ArrayList<Object> rval = new ArrayList<Object>(arr.length());
        for (int i = 0; i < arr.length(); ++i) {
            rval.add(OrgJsonUtil.convertValue(arr.get(i)));
        }
        return rval;
    }

    public static String[] getNames(JSONObject obj) {
        if (obj == null || obj.length() == 0) {
            return null;
        }
        String[] rval = new String[obj.length()];
        Iterator keyIt = obj.keys();
        int idx = 0;
        while (keyIt.hasNext()) {
            String key = (String)keyIt.next();
            rval[idx++] = key;
        }
        return rval;
    }

    private OrgJsonUtil() {
    }
}

