/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.syntaxhighlight.marker;

import java.util.ArrayList;
import java.util.List;
import ro.sync.syntaxhighlight.marker.LineInfoTokens;
import ro.sync.syntaxhighlight.marker.PrimaryLineInfoTokens;
import ro.sync.syntaxhighlight.marker.Token;
import ro.sync.syntaxhighlight.marker.TokenInfo;

public class SecondaryLineInfoTokens
extends PrimaryLineInfoTokens {
    private byte[] sids = new byte[0];
    private byte[] tmIDs = new byte[0];
    private static List<String> tokenMarkerNames = new ArrayList<String>(20);

    @Override
    public TokenInfo getTokenInfo(int position, TokenInfo toFill) {
        super.getTokenInfo(position, toFill);
        toFill.sId = this.sids[position];
        toFill.sTokenMarkerName = tokenMarkerNames.get(this.tmIDs[position]);
        return toFill;
    }

    @Override
    public void setLineTokens(TokenInfo[] lineTokens) {
        this.ids = new byte[lineTokens.length];
        this.offsets = new int[lineTokens.length];
        this.sids = new byte[lineTokens.length];
        this.tmIDs = new byte[lineTokens.length];
        for (int i = 0; i < lineTokens.length; ++i) {
            TokenInfo tokenInfo = lineTokens[i];
            this.ids[i] = tokenInfo.id;
            this.offsets[i] = tokenInfo.offsetInLine;
            this.sids[i] = tokenInfo.sId;
            this.tmIDs[i] = SecondaryLineInfoTokens.getTokenMarkerID(tokenInfo.sTokenMarkerName);
        }
    }

    private static synchronized byte getTokenMarkerID(String tokenMarkerName) {
        int pos = tokenMarkerNames.indexOf(tokenMarkerName);
        if (pos == -1) {
            tokenMarkerNames.add(tokenMarkerName);
            pos = tokenMarkerNames.size() - 1;
        }
        return (byte)pos;
    }

    @Override
    public LineInfoTokens clone() {
        SecondaryLineInfoTokens toReturn = (SecondaryLineInfoTokens)super.clone();
        toReturn.ids = (byte[])this.ids.clone();
        toReturn.offsets = (int[])this.offsets.clone();
        if (this.sids != null) {
            toReturn.sids = (byte[])this.sids.clone();
            toReturn.tmIDs = (byte[])this.tmIDs.clone();
        }
        return toReturn;
    }

    @Override
    public void initFromToken(int tokensCount, Token token) {
        this.ids = new byte[tokensCount];
        this.offsets = new int[tokensCount];
        this.sids = new byte[tokensCount];
        this.tmIDs = new byte[tokensCount];
        int pos = 0;
        while (token != null) {
            this.ids[pos] = token.id;
            this.offsets[pos] = token.offsetInLine;
            this.sids[pos] = token.sId;
            this.tmIDs[pos] = SecondaryLineInfoTokens.getTokenMarkerID(token.sTokenMarkerName);
            token = token.next;
            ++pos;
        }
    }
}

