/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tokenmarker.xsl;

import com.oxygenxml.tokenmarker.xsl.ImbricationLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImbricationLevelStackOverLong
implements Cloneable {
    private static final Logger logger = LoggerFactory.getLogger((String)ImbricationLevelStackOverLong.class.getName());
    protected long bits = 0L;
    private static final int MAX_BITS = 8;
    private static final int MAX_STACK_LENGTH = 7;
    private static final long BIT_MASK_STACK = -72057594037927936L;
    private static final long BIT_MASK_STACK_NEGATED = 0xFFFFFFFFFFFFFFL;
    private static final int OFFSET1 = 8;
    private static final int OFFSET2 = 16;
    private static final int OFFSET3 = 24;
    private static final int OFFSET4 = 32;
    private static final int OFFSET5 = 40;
    private static final int OFFSET6 = 48;
    private static final int OFFSET7 = 56;
    private static final long[] BIT_MASK_STACK_ENTRIES = new long[]{0xFF000000000000L, 0xFF0000000000L, 0xFF00000000L, 0xFF000000L, 0xFF0000L, 65280L, 255L};
    private static final long[] BIT_MASK_STACK_ENTRIES_NEGATED = new long[]{-71776119061217281L, -280375465082881L, -1095216660481L, -4278190081L, -16711681L, -65281L, -256L};
    private static final int HASH_CODE = 17;

    public ImbricationLevelStackOverLong(long bits) {
        this.bits = bits;
    }

    private ImbricationLevel pop() {
        byte stackLen = (byte)((this.bits & 0xFF00000000000000L) >>> 56);
        if (stackLen > 0) {
            byte s = (byte)((this.bits & BIT_MASK_STACK_ENTRIES[stackLen - 1]) >>> 8 * (7 - stackLen));
            stackLen = (byte)(stackLen - 1);
            this.bits &= 0xFFFFFFFFFFFFFFL;
            this.bits |= (long)stackLen << 56;
            return new ImbricationLevel(s);
        }
        return null;
    }

    public ImbricationLevel getImbricationLevel() {
        byte stackLen = (byte)((this.bits & 0xFF00000000000000L) >>> 56);
        if (stackLen > 0) {
            byte s = (byte)((this.bits & BIT_MASK_STACK_ENTRIES[stackLen - 1]) >>> 8 * (7 - stackLen));
            return new ImbricationLevel(s);
        }
        return null;
    }

    public void addNewImbricationLevel(boolean enabled) {
        this.push(new ImbricationLevel(enabled));
    }

    byte getStackLen() {
        return (byte)((this.bits & 0xFF00000000000000L) >>> 56);
    }

    public void increaseImbricationLevel() {
        byte stackLen;
        if (logger.isDebugEnabled()) {
            logger.debug("About 2 increase: {}", (Object)this);
        }
        if ((stackLen = (byte)((this.bits & 0xFF00000000000000L) >>> 56)) > 0) {
            byte s = (byte)((this.bits & BIT_MASK_STACK_ENTRIES[stackLen - 1]) >>> 8 * (7 - stackLen));
            s = new ImbricationLevel(s).increase().getByteValue();
            this.bits &= BIT_MASK_STACK_ENTRIES_NEGATED[stackLen - 1];
            this.bits |= (long)s << 8 * (7 - stackLen);
            if (logger.isDebugEnabled()) {
                logger.debug("After increase: {}", (Object)this);
            }
        } else {
            logger.error("No imbrication level to increase!{}", (Object)this);
        }
    }

    public void decreaseImbricationLevel() {
        byte stackLen;
        if (logger.isDebugEnabled()) {
            logger.debug("About 2 decrease: {}", (Object)this);
        }
        if ((stackLen = (byte)((this.bits & 0xFF00000000000000L) >>> 56)) > 0) {
            byte s = (byte)((this.bits & BIT_MASK_STACK_ENTRIES[stackLen - 1]) >>> 8 * (7 - stackLen));
            ImbricationLevel il = new ImbricationLevel(s).decrease();
            if (il.getLevel() == 0) {
                this.pop();
                if (logger.isDebugEnabled()) {
                    logger.debug("Removed imbrication from stack !");
                }
            } else {
                s = il.getByteValue();
                this.bits &= BIT_MASK_STACK_ENTRIES_NEGATED[stackLen - 1];
                this.bits |= (long)s << 8 * (7 - stackLen);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("After decrease: {}", (Object)this);
            }
        } else {
            logger.error("No imbrication level to decrease!");
        }
    }

    private void push(ImbricationLevel level) {
        byte stackLen;
        if (logger.isDebugEnabled()) {
            logger.debug("About 2 push: {}", (Object)this);
            logger.debug("About 2 push: {}", (Object)Long.toBinaryString(level.getByteValue()));
        }
        if ((stackLen = (byte)((this.bits & 0xFF00000000000000L) >>> 56)) < 7) {
            stackLen = (byte)(stackLen + 1);
            this.bits &= BIT_MASK_STACK_ENTRIES_NEGATED[stackLen - 1];
            this.bits |= (long)level.getByteValue() << 8 * (7 - stackLen);
            this.bits &= 0xFFFFFFFFFFFFFFL;
            this.bits |= (long)stackLen << 56;
            if (logger.isDebugEnabled()) {
                logger.debug("After push: {}", (Object)this);
            }
        } else {
            logger.error("Imbrication level stack overflow.");
        }
    }

    public boolean isActive() {
        return (this.bits & 0xFF00000000000000L) >>> 56 > 0L;
    }

    public boolean isEnabled() {
        ImbricationLevel imbricationLevel = this.getImbricationLevel();
        return imbricationLevel != null && imbricationLevel.isEnabled();
    }

    public String toString() {
        int stackLen = (int)((this.bits & 0xFF00000000000000L) >>> 56);
        StringBuilder sb = new StringBuilder("{ sl = ").append(stackLen).append(", stack = [ ");
        for (int i = 1; i <= stackLen; ++i) {
            byte s = (byte)((this.bits & BIT_MASK_STACK_ENTRIES[i - 1]) >>> 8 * (7 - i));
            sb.append(s).append(", ");
        }
        sb.append("]}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof ImbricationLevelStackOverLong) {
            ImbricationLevelStackOverLong lsw = (ImbricationLevelStackOverLong)obj;
            return this.bits == lsw.bits;
        }
        return false;
    }

    public Object clone() {
        return new ImbricationLevelStackOverLong(this.bits);
    }

    public int hashCode() {
        return 17;
    }
}

