/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tokenmarker.activation;

import com.oxygenxml.tokenmarker.activation.AbstractXMLActivationRule;
import com.oxygenxml.tokenmarker.activation.ActivationRange;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPathActivationRule
extends AbstractXMLActivationRule {
    protected static final byte S_XE_RECOGNIZED_OPEN_TAG = 1;
    protected static final byte S_XE_RECOGNIZED_ATTRIBUTE_NAME = 2;
    protected static final byte S_XE_RECOGNIZED_EQUALS_OPERATOR = 3;
    public static final byte S_NXE_RECOGNIZED_OPEN_TAG = 4;
    public static final byte S_NXE_RECOGNIZED_ATTRIBUTE_NAME_USE_WHEN = 5;
    public static final byte S_NXE_RECOGNIZED_EQUALS_OPERATOR_USE_WHEN = 6;
    private static final byte S_XE_ACTIVE_OPEN_PARANTHESIS_SQ = 7;
    private static final byte S_XE_ACTIVE_OPEN_PARANTHESIS_DQ = 8;
    protected static final byte S_XE_ACTIVE_SQ = 10;
    protected static final byte S_XE_ACTIVE_DQ = 11;
    protected static final byte S_NXE_ACTIVE_SQ = 12;
    protected static final byte S_NXE_ACTIVE_DQ = 13;
    private static final byte S_NXE_ACTIVE_OPEN_PARANTHESIS_SQ = 14;
    private static final byte S_NXE_ACTIVE_OPEN_PARANTHESIS_DQ = 15;
    public static final byte S_NXE_USE_WHEN_ACTIVE_SQ = 16;
    public static final byte S_NXE_USE_WHEN_ACTIVE_DQ = 17;
    protected static final Logger logger = LoggerFactory.getLogger((String)XPathActivationRule.class.getName());
    private String lastUpdatedOriginalTokenText;
    private byte lastUpdatedTokenId;
    private int[][] lastIntRanges;
    private String[] elementsWithXPathAttributes;
    private int[] elementsWithXPathAttributesLen;
    private final Map<String, List<String>> elementsToAttributesMap = new HashMap<String, List<String>>();
    String lastKnownTag = null;
    private static final ActivationRange[] ERA = new ActivationRange[0];

    public XPathActivationRule(Map<String, List<String>> elementsToAttributesMap) {
        this.elementsToAttributesMap.putAll(elementsToAttributesMap);
        this.elementsWithXPathAttributes = elementsToAttributesMap.keySet().toArray(new String[0]);
        this.elementsWithXPathAttributesLen = new int[this.elementsWithXPathAttributes.length];
        for (int i = 0; i < this.elementsWithXPathAttributesLen.length; ++i) {
            this.elementsWithXPathAttributesLen[i] = this.elementsWithXPathAttributes[i].length();
        }
    }

    @Override
    public boolean isStartTag(byte tokenID) {
        return super.isStartTag(tokenID) || tokenID == 17;
    }

    @Override
    public void update(byte tokenId, String originalTokenText, String trimmedTokenText) {
        this.lastUpdatedTokenId = tokenId;
        this.lastUpdatedOriginalTokenText = originalTokenText;
        this.lastIntRanges = null;
        String tokenText = trimmedTokenText;
        boolean isEmpty = tokenText.length() == 0;
        boolean pushback = false;
        do {
            if (logger.isDebugEnabled()) {
                logger.debug("Updating {} - '{}'\t in state {}{}", new Object[]{tokenId, trimmedTokenText, this.state, pushback ? " (pushed back)" : ""});
            }
            pushback = false;
            switch (this.state) {
                case 0: {
                    if (!this.isStartTag(tokenId) || tokenText.startsWith("</")) break;
                    int cIdx = tokenText.indexOf(58) + 1;
                    if (cIdx == 0 && tokenText.startsWith("<")) {
                        ++cIdx;
                    }
                    boolean found = false;
                    int len = this.elementsWithXPathAttributes.length;
                    for (int i = 0; i < len; ++i) {
                        this.lastKnownTag = null;
                        if (tokenText.length() - cIdx != this.elementsWithXPathAttributesLen[i] || !tokenText.regionMatches(cIdx, this.elementsWithXPathAttributes[i], 0, this.elementsWithXPathAttributesLen[i])) continue;
                        found = true;
                        this.lastKnownTag = this.elementsWithXPathAttributes[i];
                        break;
                    }
                    if (found) {
                        this.state = 1;
                        break;
                    }
                    this.state = (byte)4;
                    break;
                }
                case 4: {
                    if (tokenId == 7) {
                        if (!tokenText.endsWith("use-when")) break;
                        this.state = (byte)5;
                        break;
                    }
                    if (tokenId == 4) {
                        int[][] r = XPathActivationRule.getParenthesisRange(originalTokenText, false);
                        this.lastIntRanges = r;
                        if (r == null) break;
                        if (this.lastParenthesisDoesNotClose(r, originalTokenText)) {
                            this.state = (byte)14;
                            break;
                        }
                        this.state = (byte)12;
                        break;
                    }
                    if (tokenId == 3) {
                        int[][] r = XPathActivationRule.getParenthesisRange(originalTokenText, false);
                        this.lastIntRanges = r;
                        if (r == null) break;
                        if (this.lastParenthesisDoesNotClose(r, originalTokenText)) {
                            this.state = (byte)15;
                            break;
                        }
                        this.state = (byte)13;
                        break;
                    }
                    if (tokenId == 9) break;
                    if (tokenId == 6) {
                        this.state = 0;
                        pushback = true;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                case 1: {
                    List<String> xpathAttributes = this.elementsToAttributesMap.get(this.lastKnownTag);
                    if (tokenId == 7 && xpathAttributes != null && xpathAttributes.contains(tokenText)) {
                        this.state = (byte)2;
                        break;
                    }
                    if (tokenId == 7 || tokenId == 9) break;
                    if (tokenId == 4) {
                        int[][] r = XPathActivationRule.getParenthesisRange(originalTokenText, false);
                        this.lastIntRanges = r;
                        if (r == null) break;
                        if (this.lastParenthesisDoesNotClose(r, originalTokenText)) {
                            this.state = (byte)7;
                            break;
                        }
                        this.state = (byte)10;
                        break;
                    }
                    if (tokenId == 3) {
                        int[][] r = XPathActivationRule.getParenthesisRange(originalTokenText, false);
                        this.lastIntRanges = r;
                        if (r == null) break;
                        if (this.lastParenthesisDoesNotClose(r, originalTokenText)) {
                            this.state = (byte)8;
                            break;
                        }
                        this.state = (byte)11;
                        break;
                    }
                    if (tokenId == 6) {
                        this.state = 0;
                        pushback = true;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                case 2: {
                    if (tokenId == 9 && "=".equals(tokenText)) {
                        this.state = (byte)3;
                        break;
                    }
                    if (tokenId == 7 && trimmedTokenText.length() == 0) break;
                    if (tokenId == 6) {
                        this.state = 0;
                        pushback = true;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                case 5: {
                    if (tokenId == 9 && "=".equals(tokenText)) {
                        this.state = (byte)6;
                        break;
                    }
                    if (tokenId == 7 && trimmedTokenText.length() == 0) break;
                    this.state = 0;
                    break;
                }
                case 6: {
                    if (tokenId == 4) {
                        this.lastIntRanges = this.getAllValueRanges(tokenId, this.lastUpdatedOriginalTokenText);
                        this.state = (byte)16;
                        break;
                    }
                    if (tokenId == 3) {
                        this.lastIntRanges = this.getAllValueRanges(tokenId, this.lastUpdatedOriginalTokenText);
                        this.state = (byte)17;
                        break;
                    }
                    if (tokenId == 7 && trimmedTokenText.length() == 0) break;
                    pushback = true;
                    this.state = 0;
                    break;
                }
                case 3: {
                    if (tokenId == 4) {
                        this.state = (byte)10;
                        break;
                    }
                    if (tokenId == 3) {
                        this.state = (byte)11;
                        break;
                    }
                    if (tokenId == 7 && trimmedTokenText.length() == 0) break;
                    pushback = true;
                    this.state = 0;
                    break;
                }
                case 12: 
                case 13: {
                    if (tokenId == 4 && this.state == 12 || tokenId == 3 && this.state == 13) {
                        char quote;
                        char c = quote = this.state == 12 ? (char)'\'' : '\"';
                        if (isEmpty || tokenText.charAt(0) != quote) {
                            int[][] r = XPathActivationRule.getParenthesisRange(originalTokenText, false);
                            this.lastIntRanges = r;
                            if (r != null) {
                                if (!this.lastParenthesisDoesNotClose(r, originalTokenText)) break;
                                this.state = (byte)(this.state == 12 ? 14 : 15);
                                break;
                            }
                            this.state = (byte)4;
                            break;
                        }
                        pushback = true;
                        this.state = (byte)4;
                        break;
                    }
                    if (tokenId == 7) {
                        pushback = true;
                        this.state = (byte)4;
                        break;
                    }
                    pushback = true;
                    this.state = 0;
                    break;
                }
                case 14: 
                case 15: {
                    if (tokenId == 4 && this.state == 14 || tokenId == 3 && this.state == 15) {
                        char quote;
                        char c = quote = this.state == 14 ? (char)'\'' : '\"';
                        if (isEmpty || tokenText.charAt(0) != quote) {
                            int[][] r = XPathActivationRule.getParenthesisRange(originalTokenText, true);
                            this.lastIntRanges = r;
                            if (r != null) {
                                if (this.lastParenthesisDoesNotClose(r, originalTokenText)) break;
                                this.state = (byte)(this.state == 14 ? 12 : 13);
                                break;
                            }
                            logger.error("This should not happen. There should be at least a range because it was an open parenthesis in the token before.");
                            break;
                        }
                        pushback = true;
                        this.state = (byte)4;
                        break;
                    }
                    if (tokenId == 7) {
                        pushback = true;
                        this.state = (byte)4;
                        break;
                    }
                    pushback = true;
                    this.state = 0;
                    break;
                }
                case 7: 
                case 8: {
                    if (tokenId == 4 && this.state == 7 || tokenId == 3 && this.state == 8) {
                        char quote;
                        char c = quote = this.state == 7 ? (char)'\'' : '\"';
                        if (isEmpty || tokenText.charAt(0) != quote) {
                            int[][] r = XPathActivationRule.getParenthesisRange(originalTokenText, true);
                            this.lastIntRanges = r;
                            if (r != null) {
                                if (this.lastParenthesisDoesNotClose(r, originalTokenText)) break;
                                this.state = (byte)(this.state == 7 ? 10 : 11);
                                break;
                            }
                            logger.error("This should not happen. There should be at least a range because it was an open parenthesis in the token before.");
                            break;
                        }
                        pushback = true;
                        this.state = 1;
                        break;
                    }
                    if (tokenId == 7) {
                        pushback = true;
                        this.state = 1;
                        break;
                    }
                    pushback = true;
                    this.state = 0;
                    break;
                }
                case 10: 
                case 11: {
                    char quote;
                    char c = quote = this.state == 10 ? (char)'\'' : '\"';
                    if (tokenId == 4 && this.state == 10 || tokenId == 3 && this.state == 11) {
                        if (isEmpty || tokenText.charAt(0) != quote) break;
                        pushback = true;
                        this.state = (byte)4;
                        break;
                    }
                    pushback = true;
                    this.state = 1;
                    break;
                }
                case 16: {
                    if (tokenId == 4) {
                        if (isEmpty || tokenText.charAt(0) != '\'') break;
                        this.state = (byte)4;
                        break;
                    }
                    pushback = true;
                    this.state = (byte)4;
                    break;
                }
                case 17: {
                    if (tokenId == 3) {
                        if (isEmpty || tokenText.charAt(0) != '\"') break;
                        this.state = (byte)4;
                        break;
                    }
                    pushback = true;
                    this.state = (byte)4;
                    break;
                }
                default: {
                    logger.error("Illegal state.");
                }
            }
            if (!logger.isDebugEnabled()) continue;
            logger.debug("\t\t\t\t\t==> {}", (Object)this.state);
        } while (pushback);
    }

    private int[][] getAllValueRanges(byte tokenId, String originalTokenText) {
        int start = 1;
        int end = -1;
        int l = originalTokenText.length();
        end = tokenId == 4 ? (originalTokenText.charAt(l - 1) == '\'' ? l - 1 : l) : (originalTokenText.charAt(l - 1) == '\"' ? l - 1 : l);
        return new int[][]{{start, end}};
    }

    private boolean lastParenthesisDoesNotClose(int[][] ranges, String originalTokenText) {
        boolean isNotClosed;
        boolean bl = isNotClosed = ranges[ranges.length - 1][1] < 0;
        if (logger.isDebugEnabled()) {
            logger.debug("The parenthesis are not closed for: '{}' = {}", (Object)originalTokenText, (Object)isNotClosed);
            logger.debug("Ranges are: '{}", (Object)XPathActivationRule.dumpRangesArray(ranges));
        }
        return isNotClosed;
    }

    private static String dumpRangesArray(int[][] ranges) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < ranges.length; ++i) {
            builder.append(Arrays.toString(ranges[i]));
            builder.append(",");
        }
        return builder.toString();
    }

    private static int[][] getParenthesisRange(String text, boolean alreadyOpenParenthesis) {
        int[][] ranges = null;
        int rangesCurrentIndex = 0;
        int len = text.length();
        if (logger.isDebugEnabled()) {
            logger.debug("Find all ranges in |{}|", (Object)text);
        }
        int s = 0;
        int rangeBegin = -1;
        int rangeEnd = -1;
        if (alreadyOpenParenthesis) {
            rangeBegin = 0;
        }
        while (true) {
            for (int i = s; i < len; ++i) {
                char ch = text.charAt(i);
                int nch = -1;
                if (i < len - 1) {
                    nch = text.charAt(i + 1);
                }
                if (ch == '{' && nch == 123) {
                    ++i;
                } else if (ch == '}' && nch == 125) {
                    ++i;
                } else if (rangeBegin == -1) {
                    if (ch == '{') {
                        rangeBegin = i + 1;
                    }
                } else if (ch == '}') {
                    rangeEnd = i;
                }
                if (rangeBegin != -1 && rangeEnd != -1) break;
            }
            s = rangeEnd == -1 ? len : rangeEnd + 1;
            if (rangeBegin == -1) break;
            if (ranges == null) {
                ranges = new int[1][];
                rangesCurrentIndex = 0;
            }
            if (rangesCurrentIndex == ranges.length) {
                int[][] nr = new int[rangesCurrentIndex + 1][];
                System.arraycopy(ranges, 0, nr, 0, ranges.length);
                ranges = nr;
            }
            ranges[rangesCurrentIndex] = new int[]{rangeBegin, rangeEnd};
            ++rangesCurrentIndex;
            rangeBegin = -1;
            rangeEnd = -1;
        }
        return ranges;
    }

    @Override
    public int getActivationState() {
        boolean isActive = this.state == 10 || this.state == 11 || this.state == 7 || this.state == 8 || this.state == 12 || this.state == 13 || this.state == 16 || this.state == 17 || this.state == 14 || this.state == 15;
        return isActive ? -1 : -2;
    }

    @Override
    public boolean useSavedLexicalState() {
        int lastIntRangesSize = this.lastIntRanges == null ? 0 : this.lastIntRanges.length;
        return this.state != 12 && this.state != 13 || lastIntRangesSize < 2;
    }

    @Override
    public ActivationRange[] getRanges() {
        ActivationRange[] ranges = null;
        if (this.lastUpdatedTokenId == 3 || this.lastUpdatedTokenId == 4) {
            int len = this.lastUpdatedOriginalTokenText.length();
            if (this.state == 12 || this.state == 13 || this.state == 10 || this.state == 11 || this.state == 7 || this.state == 8 || this.state == 14 || this.state == 15) {
                if (logger.isDebugEnabled()) {
                    logger.debug("LPR {}", (Object)Arrays.toString((Object[])this.lastIntRanges));
                }
                if (this.lastIntRanges != null) {
                    int rc = this.lastIntRanges.length;
                    ArrayList<ActivationRange> tmp = new ArrayList<ActivationRange>(rc);
                    for (int i = 0; i < rc; ++i) {
                        int beginIndex = this.lastIntRanges[i][0];
                        int endIndex = this.lastIntRanges[i][1];
                        if (endIndex == -1) {
                            char ch = this.state == 12 || this.state == 14 ? (char)'\'' : '\"';
                            endIndex = ch == this.lastUpdatedOriginalTokenText.charAt(len - 1) ? len - 1 : len;
                        }
                        if (endIndex < beginIndex) continue;
                        tmp.add(new ActivationRange(beginIndex, endIndex));
                    }
                    ranges = tmp.toArray(ERA);
                }
            }
            if (ranges == null && (this.state == 10 || this.state == 11 || this.state == 16 || this.state == 17)) {
                char ch = this.state == 10 || this.state == 16 ? (char)'\'' : '\"';
                int beginIndex = ch == this.lastUpdatedOriginalTokenText.charAt(0) ? 1 : 0;
                int endIndex = len > 1 ? (ch == this.lastUpdatedOriginalTokenText.charAt(len - 1) ? len - 1 : len) : beginIndex;
                if (endIndex >= beginIndex) {
                    ranges = new ActivationRange[]{new ActivationRange(beginIndex, endIndex)};
                }
            }
        }
        if (ranges != null && ranges.length == 0) {
            ranges = null;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Created ranges {}", (Object)Arrays.toString(ranges));
        }
        return ranges;
    }
}

