/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tokenmarker.activation;

import com.oxygenxml.tokenmarker.activation.AbstractXMLActivationRule;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AttributeBasedActivationRule
extends AbstractXMLActivationRule {
    private static final Logger logger = LoggerFactory.getLogger((String)AttributeBasedActivationRule.class.getName());
    private String[] attributeNames;
    private String[] attributeValues;
    private String openTag;
    private String startTag;
    private static final byte S_RECOGNIZED_OPEN_TAG = 1;
    private static final byte S_RECOGNIZED_ATTRIBUTE_NAME = 2;
    private static final byte S_RECOGNIZED_EQUALS_OPERATOR = 3;
    private static final byte S_RECOGNIZED_ATTRIBUTE_VALUE = 4;
    private static final byte S_ACTIVE_ON_NEXT_TOKEN = 5;
    private static final byte S_ACTIVE = 6;

    public AttributeBasedActivationRule(String elementName, String[] attributeNames, String[] attributeValues) {
        this.attributeValues = attributeValues;
        for (int i = 0; i < attributeNames.length; ++i) {
            attributeNames[i] = attributeNames[i].toLowerCase();
        }
        this.attributeNames = attributeNames;
        this.openTag = "<" + elementName;
        this.startTag = this.openTag + ">";
    }

    @Override
    public void update(byte tokenId, String originalTokenText, String trimmedTokenText) {
        String tokenText = trimmedTokenText;
        if (logger.isDebugEnabled()) {
            logger.debug("Updating {} - {} in state {}", new Object[]{tokenId, tokenText, this.state});
        }
        switch (this.state) {
            case 0: {
                if (this.isStartTag(tokenId) && this.openTag.equalsIgnoreCase(tokenText)) {
                    this.state = 1;
                    break;
                }
                if (!this.isStartTag(tokenId) || !this.startTag.equalsIgnoreCase(tokenText)) break;
                this.state = (byte)5;
                break;
            }
            case 1: {
                if (tokenId == 7 && Arrays.asList(this.attributeNames).contains(tokenText.toLowerCase())) {
                    this.state = (byte)2;
                    break;
                }
                if (tokenId == 6 && ">".equals(tokenText)) {
                    this.state = (byte)5;
                    break;
                }
                if (tokenId == 7 || tokenId == 9 || tokenId == 3 || tokenId == 4) break;
                this.state = 0;
                break;
            }
            case 2: {
                if (tokenId == 9 && "=".equals(tokenText)) {
                    this.state = (byte)3;
                    break;
                }
                this.state = 0;
                break;
            }
            case 3: {
                if (tokenId == 3 || tokenId == 4) {
                    boolean matched = false;
                    int len = this.attributeValues.length;
                    for (int i = 0; i < len; ++i) {
                        if (!tokenText.toLowerCase().contains(this.attributeValues[i])) continue;
                        matched = true;
                        break;
                    }
                    if (matched) {
                        this.state = (byte)4;
                        break;
                    }
                    this.state = 0;
                    break;
                }
                this.state = 0;
                break;
            }
            case 4: {
                if (tokenId == 6 && ">".equals(tokenText)) {
                    this.state = (byte)5;
                    break;
                }
                if (tokenId == 7 || tokenId == 9 || tokenId == 3 || tokenId == 4) break;
                this.state = 0;
                break;
            }
            case 5: {
                this.state = (byte)6;
            }
            case 6: {
                if (tokenId == 1 || tokenId == 0 || tokenId == 11 || tokenId == 5) break;
                this.state = 0;
                break;
            }
            default: {
                logger.error("Illegal state.");
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug("--> {}", (Object)this.state);
        }
    }

    @Override
    public int getActivationState() {
        return this.state == 6 ? -1 : -2;
    }
}

