/*
 * Decompiled with CFR 0.152.
 */
package com.oxygenxml.tokenmarker;

import com.oxygenxml.tokenmarker.LexicalState;
import java.util.Arrays;

public class LexicalStateUnlimittedStack
implements Cloneable,
LexicalState {
    private static final int STACK_SIZE = 10;
    private static final int STACK_EXTRA_SPACE = 6;
    private static final int HASH_CODE = 16;
    private int yystate = 0;
    private int nestingLevel;
    private int stackLen = 0;
    private byte[] theStack = new byte[10];

    @Override
    public int pop() {
        int s = 0;
        if (this.stackLen > 0) {
            s = this.theStack[--this.stackLen];
            this.theStack[this.stackLen] = 0;
        }
        return s;
    }

    @Override
    public int peek() {
        int s = -1;
        if (this.stackLen > 0) {
            s = this.theStack[this.stackLen - 1];
        }
        return s;
    }

    @Override
    public void push(int val) {
        this.ensureStackIsBigEnough();
        this.theStack[this.stackLen++] = (byte)val;
    }

    @Override
    public int contains(int state) {
        if (this.stackLen > 0) {
            for (int i = this.stackLen - 1; i >= 0; --i) {
                if (state != this.theStack[i]) continue;
                return this.stackLen - i;
            }
        }
        return -1;
    }

    private void ensureStackIsBigEnough() {
        if (this.stackLen >= this.theStack.length) {
            byte[] newBiggerStack = new byte[this.theStack.length + 6];
            System.arraycopy(this.theStack, 0, newBiggerStack, 0, this.theStack.length);
            this.theStack = newBiggerStack;
        }
    }

    @Override
    public int getYYState() {
        return this.yystate;
    }

    @Override
    public void setYYState(int yystate) {
        this.yystate = yystate;
    }

    @Override
    public int getNestingLevel() {
        return this.nestingLevel;
    }

    @Override
    public void setNestingLevel(int nestingLevel) {
        this.nestingLevel = nestingLevel;
    }

    public String toString() {
        return "{ yystate = " + this.getYYState() + "nestingLevel = " + this.nestingLevel + "sl = " + this.stackLen + ", bits = " + Arrays.toString(this.theStack) + "}";
    }

    public boolean equals(Object obj) {
        if (obj instanceof LexicalStateUnlimittedStack) {
            LexicalStateUnlimittedStack lsw = (LexicalStateUnlimittedStack)obj;
            return this.yystate == lsw.yystate && this.nestingLevel == lsw.nestingLevel && this.stackLen == lsw.stackLen && this.areStacksEquals(this.stackLen, this.theStack, lsw.theStack);
        }
        return false;
    }

    private boolean areStacksEquals(int stackLen1, byte[] stack1, byte[] stack2) {
        for (int i = 0; i < stackLen1; ++i) {
            if (stack1[i] == stack2[i]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return 16;
    }

    @Override
    public LexicalState clone() {
        LexicalStateUnlimittedStack lsw = null;
        try {
            lsw = (LexicalStateUnlimittedStack)super.clone();
        }
        catch (CloneNotSupportedException e) {
            lsw = new LexicalStateUnlimittedStack();
        }
        lsw.yystate = this.yystate;
        lsw.nestingLevel = this.nestingLevel;
        lsw.stackLen = this.stackLen;
        lsw.theStack = (byte[])this.theStack.clone();
        return lsw;
    }
}

