/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.xml;

import org.apache.xerces.parsers.SAXParser;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.apache.xerces.xni.grammars.XMLGrammarPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import ro.sync.textsearch.xml.CatalogResolverFactoryForTests;
import ro.sync.textsearch.xml.XMLParserFactory;
import ro.sync.textsearch.xml.XMLReaderBundle;

public class XMLParserFactoryForTests
implements XMLParserFactory {
    private static final Logger logger = LoggerFactory.getLogger((String)XMLParserFactoryForTests.class.getName());

    @Override
    public XMLReader newXMLReader() {
        XMLGrammarPoolImpl grammarPool = new XMLGrammarPoolImpl();
        SymbolTable symbolTable = new SymbolTable();
        SAXParser parser = new SAXParser(symbolTable, (XMLGrammarPool)grammarPool);
        try {
            parser.setFeature("http://xml.org/sax/features/namespaces", true);
            parser.setFeature("http://apache.org/xml/features/validation/schema", true);
        }
        catch (SAXNotRecognizedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (SAXNotSupportedException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        parser.setEntityResolver(CatalogResolverFactoryForTests.getInstance().getResolver());
        if (logger.isDebugEnabled()) {
            logger.debug("Created parser " + parser);
        }
        return parser;
    }

    @Override
    public XMLReaderBundle newXMLReaderWithGrammarCache(Object grammarCacheToken) {
        return new XMLReaderBundle(this.newXMLReader(), grammarCacheToken);
    }
}

