/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.webhelp;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;

public class AdvancedQueryChecker {
    private static String defaultFieldName = "__aqc__field__";

    public static boolean isAdvancedQuery(String userInput, Analyzer analyzer) throws ParseException {
        if (userInput == null || userInput.trim().isEmpty()) {
            return false;
        }
        QueryParser parser = new QueryParser(defaultFieldName, analyzer);
        Query query = parser.parse(userInput);
        return AdvancedQueryChecker.isAdvancedQuery(query);
    }

    private static boolean isAdvancedQuery(Query query) {
        boolean advanced = false;
        if (query instanceof TermQuery) {
            advanced = AdvancedQueryChecker.isAdvancedTermQuery((TermQuery)query);
        } else if (query instanceof BooleanQuery) {
            BooleanQuery booleanQuery = (BooleanQuery)query;
            for (BooleanClause clause : booleanQuery.clauses()) {
                Query subQuery = clause.getQuery();
                if (clause.getOccur() != BooleanClause.Occur.SHOULD) {
                    advanced = true;
                } else if (subQuery instanceof TermQuery) {
                    advanced = AdvancedQueryChecker.isAdvancedTermQuery((TermQuery)subQuery);
                } else if (!(subQuery instanceof TermQuery) || AdvancedQueryChecker.isAdvancedQuery(subQuery)) {
                    advanced = true;
                }
                if (!advanced) continue;
                break;
            }
        } else {
            advanced = true;
        }
        return advanced;
    }

    private static boolean isAdvancedTermQuery(TermQuery query) {
        boolean advanced = false;
        if (!defaultFieldName.equals(query.getTerm().field())) {
            advanced = true;
        }
        return advanced;
    }
}

