/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.html;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import ro.sync.textsearch.fields.StoredTextField;

public class LuceneDocumentBuilder {
    private List<Document> list;
    private String systemId;
    private String mdContent;

    private void flushDoc(StringBuilder content, List<Document> list) {
        String contentStr = content.toString().trim();
        if (!contentStr.isEmpty()) {
            list.add(this.createDocument(contentStr));
            content.setLength(0);
        }
    }

    public LuceneDocumentBuilder(String systemId, String mdContent) {
        this.systemId = systemId;
        this.mdContent = mdContent;
    }

    List<Document> buildDocsForFile() throws IOException {
        this.list = new ArrayList<Document>();
        try (BufferedReader reader = new BufferedReader(new StringReader(this.mdContent));){
            String line;
            TenLinesRecognizer recognizer = new TenLinesRecognizer();
            while ((line = reader.readLine()) != null) {
                recognizer.addLine(line);
            }
            recognizer.flush();
        }
        return this.list;
    }

    private Document createDocument(String content) {
        Document doc = new Document();
        doc.add((IndexableField)new StringField("__uri__", this.systemId, Field.Store.YES));
        doc.add((IndexableField)new StoredTextField("text", content));
        doc.add((IndexableField)new StringField("__document_type__", "semantic", Field.Store.YES));
        return doc;
    }

    private class TenLinesRecognizer {
        StringBuilder groupContent = new StringBuilder();
        Queue<String> lineBuffer = new ArrayDeque<String>();
        int lineNo = 0;

        private TenLinesRecognizer() {
        }

        public void addLine(String line) {
            this.lineBuffer.add(line);
            this.groupContent.append(line).append("\n");
            ++this.lineNo;
            if (this.lineNo % 10 == 0) {
                this.flush();
                ArrayDeque<String> overlapBuffer = new ArrayDeque<String>(this.lineBuffer);
                this.groupContent = new StringBuilder();
                while (!overlapBuffer.isEmpty()) {
                    this.groupContent.append("\n").append((String)overlapBuffer.poll());
                }
            }
            while (this.lineBuffer.size() > 3) {
                this.lineBuffer.poll();
            }
        }

        public void flush() {
            if (this.groupContent.length() > 0) {
                LuceneDocumentBuilder.this.flushDoc(this.groupContent, LuceneDocumentBuilder.this.list);
            }
        }
    }
}

