/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.completion.trie;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.StopwordAnalyzerBase;

public abstract class TokensUtil {
    public static boolean isStopWord(String token, Analyzer analyzer) {
        boolean isStopWord = false;
        if (analyzer instanceof StopwordAnalyzerBase) {
            CharArraySet stopwordSet = ((StopwordAnalyzerBase)analyzer).getStopwordSet();
            isStopWord = stopwordSet.contains((CharSequence)token);
        }
        return isStopWord;
    }

    public static boolean isEndTagMarkup(String token) {
        int END_TAG_MARKUP_MINIMUM_LENGTH = 4;
        return token.length() >= 4 && token.substring(0, 2).equals("</") && token.substring(token.length() - 1).equals(">");
    }

    public static boolean isStartTagMarkup(String token) {
        int START_TAG_MARKUP_MINIMUM_LENGTH = 3;
        return token.length() >= 3 && token.substring(0, 1).equals("<") && !token.substring(1, 2).equals("/") && !token.substring(token.length() - 2, token.length() - 1).equals("/") && token.substring(token.length() - 1).equals(">");
    }

    public static boolean endsWithDot(String token) {
        int END_WORD_MINIMUM_LENGTH = 2;
        return token.length() >= 2 && token.charAt(token.length() - 1) == '.' && !token.contains(" ");
    }
}

