/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch;

import java.util.ArrayList;
import java.util.List;

public class SearchOptions {
    private static final int DEFAULT_MAXIMUM_HITS_NUMBER = 200;
    public static final int DEFAULT_HIGHLIGHT_MAXIMUM_HITS_NUMBER = 10;
    public static final int DEFAULT_HIGHLIGHT_MAXIMUM_DOC_CHARS_TO_ANALYZE = 51200;
    private static final int DEFAULT_PAGE_SIZE = 10;
    private Builder builder;

    private SearchOptions(Builder builder) {
        this.builder = new Builder(builder);
    }

    public SearchScope getSearchScope() {
        return this.builder.searchScope;
    }

    public DefaultJoinOperator getDefaultJoinOperator() {
        return this.builder.defaultJoinOperator;
    }

    public boolean isExactSearch() {
        return this.builder.exactSearch;
    }

    public String getReviewAuthorName() {
        return this.builder.reviewAuthorName;
    }

    public ReviewType getReviewType() {
        return this.builder.reviewType;
    }

    public long getReviewsRecentThan() {
        return this.builder.reviewRecentThan;
    }

    public ReviewReturnStructureMode getReviewReturnMode() {
        return this.builder.reviewReturnMode;
    }

    public int getMaximumHitsNumber() {
        return this.builder.maximumHitsNumber;
    }

    public List<String> getElementTypeFilter() {
        return this.builder.elementTypeFilter;
    }

    public String getResourceURLFilter() {
        return this.builder.resourceURLFilter;
    }

    public String getHighlightStartTag() {
        return this.builder.highlightStartTag;
    }

    public String getHighlightEndTag() {
        return this.builder.highlightEndTag;
    }

    public boolean isHighlighting() {
        return this.builder.isHighlighting;
    }

    public int getHighlightMaximumHitsNumber() {
        return this.builder.highlightMaximumHitsNumber;
    }

    public int getHighlightMaximumDocCharsToAnalyze() {
        return this.builder.highlightMaximumDocCharsToAnalyze;
    }

    public int getCurrentPage() {
        return this.builder.currentPage;
    }

    public int getPageSize() {
        return this.builder.pageSize;
    }

    public boolean isApplyPagination() {
        return this.builder.applyPagination;
    }

    public boolean isApplyAdvancedScoring() {
        return this.builder.applyAdvancedScoring;
    }

    public List<String> getSelectedResources() {
        return this.builder.selectedResources;
    }

    public String getFacets() {
        return this.builder.facets;
    }

    public static class Builder {
        private SearchScope searchScope = SearchScope.IN_PATHS;
        private DefaultJoinOperator defaultJoinOperator = DefaultJoinOperator.AND;
        private boolean exactSearch;
        private ReviewType reviewType;
        private String reviewAuthorName;
        private long reviewRecentThan = -1L;
        private ReviewReturnStructureMode reviewReturnMode = ReviewReturnStructureMode.MAIN_RESOURCES_ONLY;
        private int maximumHitsNumber = 200;
        private List<String> elementTypeFilter;
        private String resourceURLFilter;
        private String highlightStartTag = "";
        private String highlightEndTag = "";
        private boolean isHighlighting = true;
        private int highlightMaximumHitsNumber = 200;
        private int highlightMaximumDocCharsToAnalyze = 51200;
        private int currentPage = 1;
        private int pageSize = 10;
        private boolean applyPagination = false;
        private boolean applyAdvancedScoring = false;
        private String facets = "";
        private List<String> selectedResources = new ArrayList<String>();

        public Builder() {
        }

        private Builder(Builder other) {
            this.defaultJoinOperator = other.defaultJoinOperator;
            this.elementTypeFilter = other.elementTypeFilter;
            this.exactSearch = other.exactSearch;
            this.maximumHitsNumber = other.maximumHitsNumber;
            this.resourceURLFilter = other.resourceURLFilter;
            this.reviewAuthorName = other.reviewAuthorName;
            this.reviewRecentThan = other.reviewRecentThan;
            this.reviewReturnMode = other.reviewReturnMode;
            this.reviewType = other.reviewType;
            this.searchScope = other.searchScope;
            this.isHighlighting = other.isHighlighting;
            this.highlightEndTag = other.highlightEndTag;
            this.highlightStartTag = other.highlightStartTag;
            this.highlightMaximumDocCharsToAnalyze = other.highlightMaximumDocCharsToAnalyze;
            this.highlightMaximumHitsNumber = other.highlightMaximumHitsNumber;
            this.currentPage = other.currentPage;
            this.pageSize = other.pageSize;
            this.applyPagination = other.applyPagination;
            this.applyAdvancedScoring = other.applyAdvancedScoring;
            this.selectedResources = other.selectedResources;
            this.facets = other.facets;
        }

        public Builder withDefaultJoinOperator(DefaultJoinOperator defaultJoinOperator) {
            this.defaultJoinOperator = defaultJoinOperator;
            return this;
        }

        public Builder withElementTypeFilter(List<String> elementTypeFilter) {
            this.elementTypeFilter = elementTypeFilter;
            return this;
        }

        public Builder withExactSearch(boolean exactSearch) {
            this.exactSearch = exactSearch;
            return this;
        }

        public Builder withHighlightEndTag(String highlightEndTag) {
            this.highlightEndTag = highlightEndTag;
            return this;
        }

        public Builder withHighlightStartTag(String highlightStartTag) {
            this.highlightStartTag = highlightStartTag;
            return this;
        }

        public Builder withHighlightMaximumDocCharsToAnanlyze(int highlightMaximumDocCharsToAnalyze) {
            this.highlightMaximumDocCharsToAnalyze = highlightMaximumDocCharsToAnalyze;
            return this;
        }

        public Builder withHighlightMaximumHitsNumber(int highlightMaximumHitsNumber) {
            this.highlightMaximumHitsNumber = highlightMaximumHitsNumber;
            return this;
        }

        public Builder withMaximumHitsNumber(int maximumHitsNumber) {
            this.maximumHitsNumber = maximumHitsNumber;
            return this;
        }

        public Builder withResourceURLFilter(String resourceURLFilter) {
            this.resourceURLFilter = resourceURLFilter;
            return this;
        }

        public Builder withReviewAuthorName(String reviewAuthorName) {
            this.reviewAuthorName = reviewAuthorName;
            return this;
        }

        public Builder withReviewRecentThan(long reviewRecentThan) {
            this.reviewRecentThan = reviewRecentThan;
            return this;
        }

        public Builder withReviewReturnMode(ReviewReturnStructureMode reviewReturnMode) {
            this.reviewReturnMode = reviewReturnMode;
            return this;
        }

        public Builder withReviewType(ReviewType reviewType) {
            this.reviewType = reviewType;
            return this;
        }

        public Builder withSearchScope(SearchScope searchScope) {
            this.searchScope = searchScope;
            return this;
        }

        public Builder withHighlighting(boolean isHighlighting) {
            this.isHighlighting = isHighlighting;
            return this;
        }

        public Builder withCurrentPage(int currentPage) {
            this.currentPage = currentPage;
            return this;
        }

        public Builder withSelectedResources(List<String> selectedResources) {
            if (selectedResources != null) {
                this.selectedResources = selectedResources;
            }
            return this;
        }

        public Builder withPageSize(int pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        public Builder withPagination(boolean applyPagination) {
            this.applyPagination = applyPagination;
            return this;
        }

        public Builder withAdvancedScoring(boolean applyAdvancedScoring) {
            this.applyAdvancedScoring = applyAdvancedScoring;
            return this;
        }

        public Builder withFacets(String facets) {
            this.facets = facets;
            return this;
        }

        public SearchOptions build() {
            return new SearchOptions(this);
        }
    }

    public static enum ReviewType {
        HIGHLIGHT,
        INSERT,
        DELETE,
        INSERT_OR_DELETE,
        COMMENT;

    }

    public static enum DefaultJoinOperator {
        AND,
        OR;

    }

    public static enum SearchScope {
        IN_PATHS,
        IN_CONTENT,
        IN_REVIEWS,
        IN_REUSABLE_COMPONENTS,
        IN_LABEL;

    }

    public static enum ReviewReturnStructureMode {
        INTERLEAVED,
        REVIEWS_ONLY,
        MAIN_RESOURCES_ONLY;

    }
}

