/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch;

import java.io.File;
import java.net.URLConnection;
import java.text.MessageFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.textsearch.IndexerEngine;
import ro.sync.textsearch.IndexingOptions;
import ro.sync.textsearch.xml.XMLOptions;
import ro.sync.textsearch.xml.XMLOptionsForTests;

public class IndexerEngineAuthorized
extends IndexerEngine {
    private static final Logger logger = LoggerFactory.getLogger((String)IndexerEngineAuthorized.class.getName());
    private static final String BASIC_AUTH = "Basic {0}";
    private String credentials;

    public IndexerEngineAuthorized(File indexDirFile, XMLOptions xmlOptions, IndexingOptions indexingOptions, String credentials) {
        super(indexDirFile, xmlOptions, indexingOptions);
        this.credentials = credentials;
    }

    public IndexerEngineAuthorized(File indexDirFile, String credentials) {
        super(indexDirFile, new XMLOptionsForTests(), new IndexingOptions(null, true, true, null, null, true, "UTF-8", -1, false, null));
        this.credentials = credentials;
    }

    @Override
    protected void addHeaders(URLConnection connection) {
        String basicAuth = MessageFormat.format(BASIC_AUTH, this.credentials);
        connection.setRequestProperty("Authorization", basicAuth);
        logger.debug("Last modified for {} was {}", (Object)connection.getURL(), (Object)connection.getLastModified());
        logger.debug("Etag for {} was {}", (Object)connection.getURL(), (Object)connection.getHeaderField("Etag"));
    }
}

