/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.miscellaneous.PerFieldAnalyzerWrapper;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexNotFoundException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopScoreDocCollectorManager;
import org.apache.lucene.search.WildcardQuery;
import org.apache.lucene.search.spell.LuceneDictionary;
import org.apache.lucene.search.suggest.InputIterator;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.textsearch.CannotIndexLargeFileException;
import ro.sync.textsearch.Compatibility;
import ro.sync.textsearch.DefaultErrorHandler;
import ro.sync.textsearch.DocumentCreator;
import ro.sync.textsearch.DocumentFactory;
import ro.sync.textsearch.ErrorHandler;
import ro.sync.textsearch.IgnoreHandler;
import ro.sync.textsearch.IndexingOptions;
import ro.sync.textsearch.LangToAnalyzer;
import ro.sync.textsearch.ResourceInfo;
import ro.sync.textsearch.ReusableMeta;
import ro.sync.textsearch.SearchOptions;
import ro.sync.textsearch.SearchQueryBuilder;
import ro.sync.textsearch.SearchResult;
import ro.sync.textsearch.analyzer.HyphenAwareCompoundWordAnalyzer;
import ro.sync.textsearch.collectors.SelectedResourcesCollectorManager;
import ro.sync.textsearch.collectors.TopDocsAndTotalHits;
import ro.sync.textsearch.completion.CompletionOptions;
import ro.sync.textsearch.completion.CompletionWhitespaceAnalyzer;
import ro.sync.textsearch.completion.ContentReconstructor;
import ro.sync.textsearch.completion.PhraseCompletionEngine;
import ro.sync.textsearch.completion.ScoredCompletion;
import ro.sync.textsearch.completion.WordCompletionEngine;
import ro.sync.textsearch.highlighter.HighlighterAndEncoder;
import ro.sync.textsearch.io.TextSearchIOUtil;
import ro.sync.textsearch.io.TextSearchURIUtil;
import ro.sync.textsearch.props.InputSourceWithProperties;
import ro.sync.textsearch.props.ResourceProperties;
import ro.sync.textsearch.props.ResourcePropertiesProvider;
import ro.sync.textsearch.util.Pair;
import ro.sync.textsearch.util.TextSearchEqualer;
import ro.sync.textsearch.webhelp.converter.IContentConverter;
import ro.sync.textsearch.webhelp.embeddings.IEmbeddingProvider;
import ro.sync.textsearch.webhelp.faceting.FacetsConfigUtils;
import ro.sync.textsearch.xml.XMLOptions;
import ro.sync.textsearch.xml.XMLOptionsForTests;

public class IndexerEngine {
    protected static final File INDEX_DIR = new File("index");
    private static final Logger logger = LoggerFactory.getLogger((String)IndexerEngine.class.getName());
    protected final ReentrantReadWriteLock rwl;
    private final ReentrantLock createSearcherLock = new ReentrantLock();
    private volatile IndexSearcher searcher;
    private DocumentFactory documentFactory;
    private IgnoreHandler ignoreHandler;
    private IOException indexProblem = null;
    private final Compatibility compatibility;
    protected IndexingOptions indexingOptions;
    private final XMLOptions xmlOptions;
    protected List<String> tagsAndClassesToIgnore = null;
    private IEmbeddingProvider embeddingProvider;
    private Analyzer indexingAnalyzer;
    protected Analyzer searchingAnalyzer;
    private Directory indexDir;
    private File indexDirFile;
    private static final LangToAnalyzer langToAnanlyzer = new LangToAnalyzer();
    private List<WeakReference<IndexWriter>> indexWriterList = new ArrayList<WeakReference<IndexWriter>>(2);
    private AtomicLong closingFlag = new AtomicLong(0L);

    IndexerEngine() {
        this(INDEX_DIR);
    }

    public IndexerEngine(File indexDirFile) {
        this(indexDirFile, new XMLOptionsForTests(), new IndexingOptions(null, true, true, null, null, true, "UTF-8", -1, false, null));
    }

    public IndexerEngine(File indexDirFile, XMLOptions xmlOptions, IndexingOptions indexingOptions) {
        this(indexDirFile, new Compatibility(indexDirFile), xmlOptions, indexingOptions, null);
    }

    public IndexerEngine(File indexDirFile, Compatibility compatibility, XMLOptions xmlOptions, IndexingOptions indexingOptions, IEmbeddingProvider embeddingProvider) {
        this.rwl = new ReentrantReadWriteLock();
        this.embeddingProvider = embeddingProvider;
        logger.debug("Building an indexer over " + TextSearchURIUtil.maskPasswords(String.valueOf(indexDirFile)));
        this.compatibility = compatibility;
        this.indexDirFile = indexDirFile;
        this.xmlOptions = xmlOptions;
        try {
            this.setIndexingOptions(indexingOptions);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public IndexerEngine(File indexDirFile, XMLOptions xmlOptions, IndexingOptions indexingOptions, ReentrantReadWriteLock indexLock, IEmbeddingProvider embeddingProvider) {
        this.rwl = indexLock;
        this.embeddingProvider = embeddingProvider;
        logger.debug("Building an indexer over {}", (Object)TextSearchURIUtil.maskPasswords(String.valueOf(indexDirFile)));
        this.compatibility = new Compatibility(indexDirFile);
        this.indexDirFile = indexDirFile;
        this.xmlOptions = xmlOptions;
        try {
            this.setIndexingOptions(indexingOptions);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setIndexingOptions(IndexingOptions indexingOptions) throws IOException {
        boolean clearedIndex;
        block5: {
            clearedIndex = false;
            this.rwl.writeLock().lock();
            try {
                if (TextSearchEqualer.verifyEquals(this.indexingOptions, indexingOptions)) break block5;
                this.indexingOptions = indexingOptions;
                try {
                    this.close(false);
                    this.compatibility.handleCompatibility(indexingOptions);
                    this.indexDir = FSDirectory.open((Path)this.indexDirFile.toPath());
                    this.ignoreHandler = new IgnoreHandler(indexingOptions.getIgnorePatterns());
                    this.documentFactory = new DocumentFactory(this.xmlOptions, indexingOptions);
                    clearedIndex = !this.hasData();
                }
                catch (IOException ex) {
                    logger.error(ex.getMessage(), (Throwable)ex);
                    this.indexProblem = ex;
                    throw ex;
                }
                this.createAnalyzers();
            }
            finally {
                this.rwl.writeLock().unlock();
            }
        }
        return clearedIndex;
    }

    public boolean isValid() {
        return this.indexProblem == null;
    }

    protected SearchResult search(Query searchQuery, Query highlightQuery, String queryTermsPattern, SearchOptions searchOptions) throws IOException, ParseException {
        HashSet<String> toDeleteURIs = new HashSet<String>();
        int deleted = 0;
        IndexSearcher searcher = this.getSearcher();
        if (searcher == null) {
            throw new IOException("There is no index structure at: " + INDEX_DIR + ". Make sure you build the index first.");
        }
        SelectedResourcesCollectorManager selectedFilesCollectorManager = new SelectedResourcesCollectorManager(searcher, searchOptions, this.createFacetsCollector());
        long t0 = System.currentTimeMillis();
        TopDocsAndTotalHits topDocsAndHits = (TopDocsAndTotalHits)searcher.search(searchQuery, (CollectorManager)selectedFilesCollectorManager);
        long t1 = System.currentTimeMillis();
        logger.debug("Search took: {}", (Object)(t1 - t0));
        List<Integer> docIds = this.preProcessScoredDocs(searcher, topDocsAndHits.topDocs);
        List<Document> docs = new ArrayList<Document>(docIds.size());
        for (int i = 0; i < docIds.size(); ++i) {
            int docId = docIds.get(i);
            Document d = searcher.storedFields().document(docId);
            String uri = d.get("__uri__");
            if (this.ignoreHandler.isIgnored(uri)) continue;
            if (IndexerEngine.exists(uri)) {
                docs.add(d);
                continue;
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Document does not exist. Removing from index: {}", (Object)TextSearchURIUtil.maskPasswords(uri));
            }
            toDeleteURIs.add(uri);
            ++deleted;
        }
        if (searchOptions.isApplyPagination()) {
            docs = this.applyPagination(docs, searchOptions);
        }
        docs = highlightQuery != null ? this.getHighlighter(searchOptions).process(highlightQuery, docs) : this.getHighlighter(searchOptions).process(searchQuery, docs);
        SearchOptions.SearchScope scope = searchOptions.getSearchScope();
        if (scope == SearchOptions.SearchScope.IN_REVIEWS) {
            docs = this.groupReviewResults(searchOptions.getReviewReturnMode(), docs);
        }
        return new SearchResult(docs.toArray(new Document[0]), topDocsAndHits.totalHits - deleted, queryTermsPattern, toDeleteURIs);
    }

    protected List<Integer> preProcessScoredDocs(IndexSearcher indexSearcher, TopDocs topDocs) {
        return Arrays.asList(topDocs.scoreDocs).stream().map(scoredDoc -> scoredDoc.doc).collect(Collectors.toList());
    }

    protected HighlighterAndEncoder getHighlighter(SearchOptions searchOptions) {
        return new HighlighterAndEncoder(this.searchingAnalyzer, searchOptions);
    }

    private List<Document> applyPagination(List<Document> docs, SearchOptions searchOptions) {
        int startIndex = (searchOptions.getCurrentPage() - 1) * searchOptions.getPageSize();
        int endIndex = searchOptions.getCurrentPage() * searchOptions.getPageSize();
        endIndex = docs.size() < endIndex ? docs.size() : endIndex;
        return startIndex < endIndex ? docs.subList(startIndex, endIndex) : Collections.emptyList();
    }

    private List<Document> groupReviewResults(SearchOptions.ReviewReturnStructureMode reviewReturnMode, List<Document> docs) throws IOException {
        switch (reviewReturnMode) {
            case REVIEWS_ONLY: {
                break;
            }
            case MAIN_RESOURCES_ONLY: {
                docs = this.getMainResourcesDocuments(docs);
                break;
            }
            case INTERLEAVED: {
                LinkedHashSet<Document> tmp = new LinkedHashSet<Document>(docs);
                List<Document> resourcesDocuments = this.getMainResourcesDocuments(docs);
                for (int i = resourcesDocuments.size() - 1; i >= 0; --i) {
                    Document mainResource = resourcesDocuments.get(i);
                    int pos = i + 1;
                    for (Document review : tmp) {
                        if (!TextSearchEqualer.verifyEquals(review.get("__uri__"), mainResource.get("__uri__"))) continue;
                        resourcesDocuments.add(pos++, review);
                    }
                }
                docs = resourcesDocuments;
                break;
            }
            default: {
                logger.error("Programming error.Should not get here {}", (Object)reviewReturnMode);
            }
        }
        return docs;
    }

    private List<Document> getMainResourcesDocuments(List<Document> reviewDocs) throws IOException {
        ArrayList<Document> mainDocs = new ArrayList<Document>();
        LinkedHashSet<String> mainDocsUris = new LinkedHashSet<String>();
        for (Document d : reviewDocs) {
            String uri = d.get("__uri__");
            mainDocsUris.add(uri);
        }
        for (String uri : mainDocsUris) {
            mainDocs.add(this.getDocumentForURI(uri));
        }
        return mainDocs;
    }

    static boolean exists(String uri) {
        boolean exists = false;
        if (uri != null) {
            if (!uri.startsWith("file:")) {
                exists = true;
            } else {
                try {
                    exists = TextSearchIOUtil.fileFromURI(new URI(uri)).exists();
                }
                catch (URISyntaxException e) {
                    exists = false;
                }
            }
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void index(File directory) throws IOException, ParseException, URISyntaxException {
        this.rwl.writeLock().lock();
        try {
            IndexWriter writer = this.createIndexWriter();
            try {
                BytesRefBuilder tBytesRef = new BytesRefBuilder();
                this.indexDocs(writer, directory, this.getSearcher(), tBytesRef);
            }
            finally {
                this.closeSearcher();
                this.closeIndexWriter(writer);
            }
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    protected void closeIndexWriter(IndexWriter writer) throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug("Now closing the writer.");
        }
        writer.close();
        if (logger.isDebugEnabled()) {
            logger.debug("Writer closed normally.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getAllRootNames() throws IOException {
        this.rwl.readLock().lock();
        try {
            ArrayList<String> names = new ArrayList<String>();
            IndexSearcher searcher = this.getSearcher();
            if (searcher != null) {
                LuceneDictionary dict = new LuceneDictionary(searcher.getIndexReader(), "__xml_root__");
                InputIterator wordsIterator = dict.getEntryIterator();
                BytesRef word = wordsIterator.next();
                while (word != null) {
                    String wordStr = word.utf8ToString();
                    names.add(wordStr);
                    word = wordsIterator.next();
                }
                Collections.sort(names);
            }
            String[] stringArray = names.toArray(new String[names.size()]);
            return stringArray;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    protected IndexSearcher getSearcher() throws IOException {
        if (this.indexProblem != null) {
            throw new IOException("Cannot execute query. The index had a problem when it was created: " + this.indexProblem, this.indexProblem);
        }
        if (this.searcher == null) {
            try {
                this.createSearcherLock.lock();
                if (this.searcher == null) {
                    try {
                        DirectoryReader reader = DirectoryReader.open((Directory)this.indexDir);
                        this.searcher = new IndexSearcher((IndexReader)reader);
                        IndexSearcher.setMaxClauseCount((int)2048);
                    }
                    catch (IndexNotFoundException ex) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("No index found.");
                        }
                        this.searcher = null;
                    }
                }
            }
            finally {
                this.createSearcherLock.unlock();
            }
        }
        return this.searcher;
    }

    private void indexDocs(IndexWriter writer, File file, IndexSearcher searcher, BytesRefBuilder tBytesRef) throws IOException, ParseException, URISyntaxException {
        if (!file.isHidden()) {
            if (file.isDirectory()) {
                File[] files = file.listFiles();
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        this.indexDocs(writer, files[i], searcher, tBytesRef);
                    }
                }
            } else {
                this.indexURL(writer, file.getCanonicalFile().toURI().toURL(), searcher, tBytesRef, null, null);
            }
        }
    }

    public Map<IndexingResult, Integer> index(Iterator<URL> resources) throws IOException, CannotIndexLargeFileException {
        return this.index(resources, null, null, null);
    }

    public Map<IndexingResult, Integer> index(Iterator<URL> resources, ResourcePropertiesProvider props, ErrorHandler errorHandler) throws IOException {
        return this.index(resources, props, errorHandler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<IndexingResult, Integer> index(Iterator<URL> resources, ResourcePropertiesProvider props, ErrorHandler errorHandler, IContentConverter contentConverter) throws IOException {
        EnumMap<IndexingResult, Integer> statistics;
        block13: {
            if (errorHandler == null) {
                errorHandler = new DefaultErrorHandler();
            }
            statistics = new EnumMap<IndexingResult, Integer>(IndexingResult.class);
            this.rwl.writeLock().lock();
            try {
                IndexWriter writer = this.createIndexWriter();
                IndexSearcher searcher = this.getSearcher();
                statistics.put(IndexingResult.UPDATED, 0);
                statistics.put(IndexingResult.SKIPPED, 0);
                BytesRefBuilder tBytesRef = new BytesRefBuilder();
                block10: while (true) {
                    while (resources.hasNext() && !this.closeRequest()) {
                        URL url = resources.next();
                        try {
                            IndexingResult ir = this.indexURL(writer, url, searcher, tBytesRef, props, contentConverter);
                            int currentValue = (Integer)statistics.get((Object)ir) + 1;
                            statistics.put(ir, currentValue);
                            continue block10;
                        }
                        catch (CannotIndexLargeFileException ex) {
                            throw ex;
                        }
                        catch (URISyntaxException uex) {
                            errorHandler.warning(url, uex);
                        }
                        catch (IOException uex) {
                            errorHandler.error(url, uex);
                        }
                    }
                    break block13;
                    {
                        continue block10;
                        break;
                    }
                    break;
                }
                finally {
                    this.closeSearcher();
                    this.closeIndexWriter(writer);
                }
            }
            finally {
                this.rwl.writeLock().unlock();
            }
        }
        return statistics;
    }

    protected boolean closeRequest() {
        return this.closingFlag.get() > 0L;
    }

    protected IndexWriter createIndexWriter() throws IOException {
        this.createAnalyzers();
        IndexWriterConfig config = new IndexWriterConfig(this.indexingAnalyzer);
        IndexWriter writer = new IndexWriter(this.indexDir, config);
        this.indexWriterList.add(new WeakReference<IndexWriter>(writer));
        return writer;
    }

    public static Analyzer createAnalyzer(String lang, List<String> stopWords, boolean breakCompoundWords, boolean generatesCompletionFields) {
        Analyzer analyzer;
        if (lang == null || "en".equals(lang)) {
            analyzer = IndexerEngine.createHyphenAwareAnalyzer(stopWords, breakCompoundWords);
        } else {
            analyzer = langToAnanlyzer.buildAnalyzer(lang, stopWords);
            if (analyzer == null) {
                analyzer = IndexerEngine.createHyphenAwareAnalyzer(stopWords, breakCompoundWords);
            }
        }
        if (generatesCompletionFields) {
            HashMap<String, CompletionWhitespaceAnalyzer> fieldAnalyzers = new HashMap<String, CompletionWhitespaceAnalyzer>(1);
            fieldAnalyzers.put("__completion_terms__", new CompletionWhitespaceAnalyzer());
            fieldAnalyzers.put("__lc_completion_terms__", new CompletionWhitespaceAnalyzer());
            fieldAnalyzers.put("__lc_title_completion_terms__", new CompletionWhitespaceAnalyzer());
            fieldAnalyzers.put("__lc_keywords_completion_terms__", new CompletionWhitespaceAnalyzer());
            analyzer = new PerFieldAnalyzerWrapper(analyzer, fieldAnalyzers);
        }
        return analyzer;
    }

    private static Analyzer createHyphenAwareAnalyzer(List<String> stopWords, boolean breakCompoundWords) {
        HyphenAwareCompoundWordAnalyzer analyzer = stopWords != null ? new HyphenAwareCompoundWordAnalyzer(breakCompoundWords, new CharArraySet(stopWords, true)) : new HyphenAwareCompoundWordAnalyzer(breakCompoundWords);
        return analyzer;
    }

    private void createAnalyzers() {
        this.indexingAnalyzer = IndexerEngine.createAnalyzer(this.indexingOptions.getLang(), this.indexingOptions.getStopWords(), true, this.generatesCompletionFields());
        this.searchingAnalyzer = IndexerEngine.createAnalyzer(this.indexingOptions.getLang(), this.indexingOptions.getStopWords(), false, this.generatesCompletionFields());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    IndexingResult indexURL(IndexWriter writer, URL url, IndexSearcher searcher, BytesRefBuilder tBytesRef, ResourcePropertiesProvider propsProvider, IContentConverter contentConverter) throws IOException, URISyntaxException {
        IndexingResult ir;
        block22: {
            if (logger.isDebugEnabled()) {
                logger.debug("Indexing URL " + TextSearchURIUtil.maskPasswords(String.valueOf(url)));
            }
            ir = null;
            URLConnection connection = null;
            try {
                connection = this.openConnection(url);
                ResourceProperties props = this.getAssociatedProperties(url, propsProvider);
                ResourceInfo resourceInfo = this.getResourceInfo(connection, props);
                if (resourceInfo.shouldIndex()) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("IndexURL - Has url {} resource properties {}", (Object)TextSearchURIUtil.maskPasswords(String.valueOf(url)), (Object)props);
                        logger.debug("Does properties forces reindexing ? {}", (Object)(props != null && props.forceReindex() ? 1 : 0));
                    }
                    boolean isAlreadyInIndex = this.isAlreadyInIndex(searcher, tBytesRef, resourceInfo);
                    boolean forceReindex = props != null && props.forceReindex();
                    ReusableMeta meta = this.getReusableMeta(tBytesRef, resourceInfo, props);
                    if (!forceReindex && isAlreadyInIndex && meta.isSameReusableState()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Skipped \t" + resourceInfo.getUriStrNoUI() + ",  is already in index.");
                        }
                        ir = IndexingResult.SKIPPED;
                        break block22;
                    }
                    try (InputStream inputStream = null;){
                        boolean addToIndex;
                        Document[] docs;
                        block23: {
                            docs = null;
                            addToIndex = true;
                            if (resourceInfo.shouldIndexContent()) {
                                try {
                                    Pair<Document[], InputStream> p = this.indexContent(props, resourceInfo, connection, contentConverter);
                                    docs = p.getLeft();
                                    inputStream = p.getRight();
                                }
                                catch (IOException ex) {
                                    if (logger.isDebugEnabled()) {
                                        logger.debug("The resource " + resourceInfo.getUriStrNoUI() + " cannot be opened due to: " + ex);
                                    }
                                    if (!resourceInfo.isLocalFile()) break block23;
                                    logger.debug("A local file with problems");
                                    addToIndex = false;
                                }
                            }
                        }
                        if (addToIndex) {
                            this.addDocumentsToIndex(writer, resourceInfo, meta, docs);
                            ir = IndexingResult.UPDATED;
                        } else {
                            ir = IndexingResult.SKIPPED;
                        }
                        break block22;
                    }
                }
                ir = IndexingResult.SKIPPED;
            }
            finally {
                this.closeConnection(connection);
            }
        }
        return ir;
    }

    private void addDocumentsToIndex(IndexWriter writer, ResourceInfo resourceInfo, ReusableMeta meta, Document[] docs) throws IOException {
        if (docs == null) {
            docs = new Document[]{new Document()};
        }
        writer.deleteDocuments(new Term[]{new Term("__uri__", resourceInfo.getUriStrNoUI())});
        boolean uriContainsReview = false;
        for (Document doc : docs) {
            uriContainsReview = uriContainsReview || doc.get("__review_type__") != null;
            this.addGenericMeta(resourceInfo, doc);
            FacetsConfigUtils.saveFacetsConfig(this.indexingOptions.getFacetsConfig(), this.indexingOptions.getTaxonomyDirectoryFile());
            doc = this.addFacetsToDocumentAndTaxonomy(doc);
            if (logger.isDebugEnabled()) {
                logger.debug("Updated \t" + resourceInfo.getUriStrNoUI() + " " + doc);
            }
            writer.addDocument((Iterable)doc);
        }
        this.addReviewMeta(writer, uriContainsReview, resourceInfo);
        this.addReusableMeta(writer, meta, resourceInfo);
    }

    private Pair<Document[], InputStream> indexContent(ResourceProperties props, ResourceInfo resourceInfo, URLConnection connection, IContentConverter contentConverter) throws IOException {
        Document[] docs;
        InputStream inputStream;
        block4: {
            InputSourceWithProperties source = new InputSourceWithProperties(props);
            URL url = resourceInfo.getUrl();
            inputStream = null;
            docs = null;
            try {
                inputStream = this.getInputStream(url, resourceInfo.getUri(), connection);
                source.setByteStream(inputStream);
                source.setSystemId(resourceInfo.getUriStr());
                docs = this.documentFactory.buildDocumentsFor(source, resourceInfo.getContentLength(), this.tagsAndClassesToIgnore, contentConverter, this.embeddingProvider, this.generatesCompletionFields());
            }
            catch (DocumentCreator.ParseException e) {
                logger.debug("Got exception when parsing " + e, (Throwable)e);
                try {
                    inputStream.close();
                    this.closeConnection(connection);
                    connection = this.openConnection(url);
                    inputStream = this.getInputStream(url, resourceInfo.getUri(), connection);
                    source.setByteStream(inputStream);
                    docs = new Document[]{this.documentFactory.buildPlainTextDocumentFor(source)};
                }
                catch (IOException ex) {
                    if (!logger.isDebugEnabled()) break block4;
                    logger.debug("Could not parse as text " + resourceInfo.getUriStrNoUI() + " due to  " + ex, (Throwable)ex);
                }
            }
        }
        logger.debug("Start post processing of Lucene documents for {}", (Object)resourceInfo.getUriStrNoUI());
        this.postProcessDocuments(docs);
        return new Pair<Object, InputStream>(docs, inputStream);
    }

    protected void postProcessDocuments(Document[] docs) {
    }

    private boolean isAlreadyInIndex(IndexSearcher searcher, BytesRefBuilder tBytesRef, ResourceInfo resourceInfo) throws IOException {
        boolean isAlreadyInIndex = false;
        if (searcher != null) {
            BooleanQuery.Builder bq = new BooleanQuery.Builder();
            tBytesRef.copyChars((CharSequence)resourceInfo.getUriStrNoUI());
            bq.add((Query)new TermQuery(new Term("__uri__", tBytesRef.get())), BooleanClause.Occur.MUST);
            bq.add(LongPoint.newRangeQuery((String)"__modified__", (long)resourceInfo.getLastModified(), (long)resourceInfo.getLastModified()), BooleanClause.Occur.MUST);
            logger.debug("isAlreadyInIndex : Last modified for {} was {}", (Object)tBytesRef.get(), (Object)resourceInfo.getLastModified());
            TopDocs topDocs = searcher.search((Query)bq.build(), 1);
            isAlreadyInIndex = topDocs.totalHits.value > 0L;
        } else {
            logger.debug("There is no searcher yet.");
        }
        return isAlreadyInIndex;
    }

    protected ResourceInfo getResourceInfo(URLConnection connection, ResourceProperties props) throws URISyntaxException {
        return new ResourceInfo(connection, this.indexingOptions, props);
    }

    private ResourceProperties getAssociatedProperties(URL url, ResourcePropertiesProvider propsProvider) {
        return propsProvider != null ? propsProvider.getProperties(url) : null;
    }

    private ReusableMeta getReusableMeta(BytesRefBuilder tBytesRef, ResourceInfo resourceInfo, ResourceProperties props) throws IOException {
        boolean wasReusableTopic = false;
        boolean isReusableTopic = props != null && props.isReusableTopic();
        Document doc = this.getReusableMetaDocument(tBytesRef, resourceInfo);
        if (doc != null) {
            wasReusableTopic = true;
        }
        return new ReusableMeta(isReusableTopic, wasReusableTopic);
    }

    private Document getReusableMetaDocument(BytesRefBuilder tBytesRef, ResourceInfo resourceInfo) throws IOException {
        Document doc = null;
        if (this.searcher != null) {
            tBytesRef.copyChars((CharSequence)resourceInfo.getUriStrNoUI());
            BooleanQuery.Builder bq = new BooleanQuery.Builder();
            bq.add((Query)new TermQuery(new Term("__uri__", tBytesRef.get())), BooleanClause.Occur.MUST);
            bq.add((Query)new TermQuery(new Term("__reusable_topic__", String.valueOf(Boolean.TRUE))), BooleanClause.Occur.MUST);
            TopDocs topDocs = (TopDocs)this.searcher.search((Query)bq.build(), (CollectorManager)new TopScoreDocCollectorManager(1, null, 0, false));
            ScoreDoc[] hits = topDocs.scoreDocs;
            if (hits.length > 0) {
                doc = this.searcher.storedFields().document(hits[0].doc);
            }
        } else {
            logger.debug("There is no searcher yet.");
        }
        return doc;
    }

    private void addReviewMeta(IndexWriter writer, boolean uriContainsReview, ResourceInfo resourceInfo) throws IOException {
        if (uriContainsReview) {
            if (logger.isDebugEnabled()) {
                logger.debug("Adding review meta: " + resourceInfo.getUriStrNoUI() + ", contains review" + uriContainsReview);
            }
            Document newDocument = new Document();
            newDocument.add((IndexableField)new StringField("__reviewed_topic__", "true", Field.Store.YES));
            newDocument.add((IndexableField)new StringField("__uri__", resourceInfo.getUriStrNoUI(), Field.Store.YES));
            writer.addDocument((Iterable)newDocument);
        }
    }

    private void addReusableMeta(IndexWriter writer, ReusableMeta meta, ResourceInfo resourceInfo) throws IOException {
        if (meta.isReusableTopic()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Adding reusable meta: {}", (Object)resourceInfo.getUriStrNoUI());
            }
            Document newDocument = new Document();
            newDocument.add((IndexableField)new StringField("__reusable_topic__", String.valueOf(meta.isReusableTopic()), Field.Store.NO));
            newDocument.add((IndexableField)new StringField("__uri__", resourceInfo.getUriStrNoUI(), Field.Store.YES));
            writer.addDocument((Iterable)newDocument);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getIndexedReusableTopics() throws IOException {
        this.rwl.readLock().lock();
        try {
            BooleanQuery.Builder bq = new BooleanQuery.Builder();
            bq.add((Query)new TermQuery(new Term("__reusable_topic__", Boolean.TRUE.toString())), BooleanClause.Occur.MUST);
            HashSet<String> uris = new HashSet<String>();
            IndexSearcher searcher = this.getSearcher();
            if (searcher != null) {
                TopDocs hits = searcher.search((Query)bq.build(), Integer.MAX_VALUE);
                int i = 0;
                while ((long)i < hits.totalHits.value) {
                    int docID = hits.scoreDocs[i].doc;
                    Document doc = searcher.storedFields().document(docID);
                    IndexableField uriField = doc.getField("__uri__");
                    if (uriField != null) {
                        String stringValue = uriField.stringValue();
                        uris.add(stringValue);
                    }
                    ++i;
                }
            }
            HashSet<String> hashSet = uris;
            return hashSet;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    protected void closeConnection(URLConnection connection) {
        if (connection instanceof HttpURLConnection) {
            ((HttpURLConnection)connection).disconnect();
        }
    }

    protected URLConnection openConnection(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        this.addHeaders(connection);
        return connection;
    }

    protected void addHeaders(URLConnection connection) {
    }

    private void addGenericMeta(ResourceInfo resourceInfo, Document doc) {
        StringField uriField = new StringField("__uri__", resourceInfo.getUriStrNoUI(), Field.Store.YES);
        doc.add((IndexableField)uriField);
        String searchURIStr = TextSearchURIUtil.uncorrect(resourceInfo.getUriNoUI(), false).toLowerCase();
        StringField lcPathField = new StringField("__lc_uri__", searchURIStr, Field.Store.YES);
        doc.add((IndexableField)lcPathField);
        boolean removeAnchors = !"file".equals(resourceInfo.getUri().getScheme());
        String fileName = TextSearchIOUtil.extractFileName(resourceInfo.getUriStrNoUI(), removeAnchors);
        StringField fileNameField = new StringField("__file_name__", fileName, Field.Store.YES);
        doc.add((IndexableField)fileNameField);
        String searchFileName = TextSearchIOUtil.extractFileName(searchURIStr, removeAnchors);
        StringField lcFileNameField = new StringField("__lc_file_name__", searchFileName, Field.Store.YES);
        doc.add((IndexableField)lcFileNameField);
        doc.add((IndexableField)new LongPoint("__modified__", new long[]{resourceInfo.getLastModified()}));
        doc.add((IndexableField)new StoredField("__modified__", resourceInfo.getLastModified()));
        if (doc.get("__review_type__") == null) {
            doc.add((IndexableField)new StringField("__review_type__", "<NULL>", Field.Store.YES));
        }
    }

    private final InputStream getInputStream(URL url, URI uri, URLConnection connection) throws IOException {
        InputStream is = "file".equals(url.getProtocol()) ? new FileInputStream(TextSearchIOUtil.fileFromURI(uri)) : connection.getInputStream();
        return is;
    }

    public void clearIndex() throws IOException {
        this.rwl.writeLock().lock();
        try {
            this.close();
            TextSearchIOUtil.deleteDir(this.indexDirFile);
            this.indexDir = FSDirectory.open((Path)this.indexDirFile.toPath());
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public void replaceIndexFromSource(File sourceDirectory) throws IOException {
        this.rwl.writeLock().lock();
        try {
            this.close();
            TextSearchIOUtil.deleteDir(this.indexDirFile);
            Files.move(sourceDirectory.toPath(), this.indexDirFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            this.indexDir = FSDirectory.open((Path)this.indexDirFile.toPath());
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    public void initIndex() throws IOException {
        this.clearIndex();
        this.compatibility.writeCompatibilityMarker(this.indexingOptions);
    }

    public SearchResult search(String text, SearchOptions.SearchScope searchScope, boolean exactSearch) throws ParseException, IOException {
        return this.search(text, new SearchOptions.Builder().withSearchScope(searchScope).withExactSearch(exactSearch).build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchResult search(String text, SearchOptions searchOptions) throws ParseException, IOException {
        SearchResult result = null;
        this.rwl.readLock().lock();
        try {
            SearchQueryBuilder qb = new SearchQueryBuilder(this.searchingAnalyzer, text, searchOptions, true);
            result = this.search(qb.getQuery(), null, qb.getTermMatchingPattern(), searchOptions);
        }
        catch (IndexSearcher.TooManyClauses ex) {
            SearchQueryBuilder qb = new SearchQueryBuilder(this.searchingAnalyzer, text, searchOptions, false);
            result = this.search(qb.getQuery(), null, qb.getTermMatchingPattern(), searchOptions);
        }
        finally {
            this.rwl.readLock().unlock();
        }
        this.cleanupStaleDocuments(result);
        if (searchOptions.isHighlighting()) {
            this.addHighlightTokens(text, result);
        }
        return result;
    }

    protected void addHighlightTokens(String text, SearchResult result) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanupStaleDocuments(SearchResult result) throws IOException {
        if (!result.getNonExistingURIs().isEmpty()) {
            this.rwl.writeLock().lock();
            try (IndexWriter writer = this.createIndexWriter();){
                Set<String> toDelete = result.getNonExistingURIs();
                for (String uri : toDelete) {
                    if (IndexerEngine.exists(uri)) continue;
                    writer.deleteDocuments(new Term[]{new Term("__uri__", uri)});
                }
                this.closeSearcher();
            }
            finally {
                this.rwl.writeLock().unlock();
            }
        }
    }

    public Document getDocumentForURI(URI uri) throws IOException, URISyntaxException {
        if (uri.getUserInfo() != null) {
            uri = TextSearchURIUtil.removeUserAndPassword(uri);
        }
        this.rwl.readLock().lock();
        try {
            Document document = this.getDocumentForURI(uri.toString());
            return document;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    private Document getDocumentForURI(String uriStr) throws IOException {
        Document document = null;
        IndexSearcher indexerSearcher = this.getSearcher();
        if (indexerSearcher != null) {
            BooleanQuery.Builder bq = new BooleanQuery.Builder();
            bq.add((Query)new TermQuery(new Term("__uri__", uriStr)), BooleanClause.Occur.MUST);
            bq.add((Query)new TermQuery(new Term("__review_type__", "<NULL>")), BooleanClause.Occur.MUST);
            TopDocs topDocs = (TopDocs)indexerSearcher.search((Query)bq.build(), (CollectorManager)new TopScoreDocCollectorManager(1, null, 0, false));
            ScoreDoc[] hits = topDocs.scoreDocs;
            if (hits.length > 0) {
                document = indexerSearcher.storedFields().document(hits[0].doc);
            }
            if (document != null && logger.isDebugEnabled()) {
                logger.debug("For \n\t" + TextSearchURIUtil.maskPasswords(uriStr) + "\n got:");
                logger.debug("URI " + TextSearchURIUtil.maskPasswords(String.valueOf(document.get("__uri__"))));
                logger.debug("REVIEWTYPE " + document.get("__review_type__"));
            }
        }
        return document;
    }

    public boolean hasData() {
        try {
            return DirectoryReader.indexExists((Directory)this.indexDir);
        }
        catch (IOException | AlreadyClosedException e) {
            logger.debug("Index Directory problem : {}", (Object)e.getMessage());
            return false;
        }
    }

    public int getIndexDocumentsCount() throws IOException {
        int count = 0;
        this.rwl.readLock().lock();
        try {
            IndexSearcher searcher = this.getSearcher();
            if (searcher != null) {
                count = searcher.getIndexReader().numDocs();
            }
        }
        finally {
            this.rwl.readLock().unlock();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("The total number of documents in the index " + TextSearchURIUtil.maskPasswords(String.valueOf(this.indexDirFile)) + " is " + count);
        }
        return count;
    }

    public void close() throws IOException {
        try {
            this.closingFlag.incrementAndGet();
            this.rwl.writeLock().lock();
            this.close(true);
        }
        finally {
            this.closingFlag.decrementAndGet();
            this.rwl.writeLock().unlock();
        }
    }

    private void close(boolean waitForMerges) throws IOException {
        this.closingFlag.incrementAndGet();
        try {
            this.closeIndexWriters(waitForMerges);
            this.closeSearcher();
            if (logger.isDebugEnabled()) {
                logger.debug("Closing index directory " + TextSearchURIUtil.maskPasswords(String.valueOf(this.indexDir)));
            }
            if (this.indexDir != null) {
                this.indexDir.close();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Closed index directory.");
            }
        }
        finally {
            this.closingFlag.decrementAndGet();
        }
    }

    private void closeIndexWriters(boolean waitForMerges) throws IOException {
        for (WeakReference<IndexWriter> wr : this.indexWriterList) {
            IndexWriter indexWriter = (IndexWriter)wr.get();
            if (indexWriter == null) continue;
            indexWriter.close();
        }
        this.indexWriterList.clear();
    }

    protected void closeSearcher() throws IOException {
        if (this.searcher != null) {
            if (logger.isDebugEnabled()) {
                logger.debug("Closing searcher for " + TextSearchURIUtil.maskPasswords(String.valueOf(this.indexDirFile)));
            }
            this.searcher.getIndexReader().close();
            this.searcher = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getIndexModificationTime() {
        this.rwl.readLock().lock();
        try {
            long itime = -1L;
            File[] files = this.indexDirFile.listFiles();
            if (files != null) {
                for (File file : files) {
                    long lastModified;
                    if (file.getName().equals(this.compatibility.getCompatibilityFileName()) || (lastModified = file.lastModified()) <= itime) continue;
                    itime = lastModified;
                }
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Last modification time for index " + TextSearchURIUtil.maskPasswords(String.valueOf(this.indexDirFile)) + " is " + itime);
            }
            long l = itime;
            return l;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Iterator<URL> iterator) throws IOException {
        try {
            this.rwl.writeLock().lock();
            IndexWriter writer = this.createIndexWriter();
            while (iterator.hasNext()) {
                URL url = iterator.next();
                try {
                    String uriStr = TextSearchURIUtil.removeUserAndPassword(url.toURI()).toString();
                    if (uriStr.endsWith("/")) {
                        WildcardQuery q = new WildcardQuery(new Term("__uri__", uriStr + "*"));
                        writer.deleteDocuments(new Query[]{q});
                        continue;
                    }
                    BooleanQuery.Builder bq = new BooleanQuery.Builder();
                    bq.add((Query)new TermQuery(new Term("__uri__", uriStr)), BooleanClause.Occur.SHOULD);
                    bq.add((Query)new WildcardQuery(new Term("__uri__", uriStr + "/*")), BooleanClause.Occur.SHOULD);
                    bq.setMinimumNumberShouldMatch(1);
                    writer.deleteDocuments(new Query[]{bq.build()});
                }
                catch (URISyntaxException ex) {
                    logger.warn("Could not remove a resource from index: " + url.getPath() + " because: " + ex, (Throwable)ex);
                }
            }
            this.closeIndexWriter(writer);
            this.closeSearcher();
        }
        finally {
            this.rwl.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getAllReviewAuthorNames(String fieldName) throws IOException {
        this.rwl.readLock().lock();
        try {
            ArrayList<String> names = new ArrayList<String>();
            IndexSearcher searcher = this.getSearcher();
            if (searcher != null) {
                LuceneDictionary dict = new LuceneDictionary(searcher.getIndexReader(), fieldName);
                InputIterator wordsIterator = dict.getEntryIterator();
                BytesRef word = wordsIterator.next();
                while (word != null) {
                    String wordStr = word.utf8ToString();
                    names.add(wordStr);
                    word = wordsIterator.next();
                }
                Collections.sort(names, Collator.getInstance());
            }
            String[] stringArray = names.toArray(new String[0]);
            return stringArray;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    public String[] getAllReviewAuthorNames() throws IOException {
        return this.getAllReviewAuthorNames("__review_lc_author__");
    }

    public String[] getAllReviewAuthorNamesWithCasePreserved() throws IOException {
        return this.getAllReviewAuthorNames("__review_author__");
    }

    public static String[] getSupportedLanguages() {
        return langToAnanlyzer.getSupportedLanguages();
    }

    public static String[] getStopWordsForLanguage(String lang) {
        String[] stopWords = null;
        Analyzer analyzer = null;
        analyzer = lang == null || lang.trim().isEmpty() ? langToAnanlyzer.buildAnalyzer("en", null) : langToAnanlyzer.buildAnalyzer(lang, null);
        CharArraySet defaultWords = null;
        if (analyzer instanceof StopwordAnalyzerBase) {
            defaultWords = ((StopwordAnalyzerBase)analyzer).getStopwordSet();
        } else if ("nl".equals(lang)) {
            try {
                defaultWords = (CharArraySet)analyzer.getClass().getMethod("getDefaultStopSet", new Class[0]).invoke(null, new Object[0]);
            }
            catch (Throwable e) {
                logger.error("Cannot get default stop words for Dutch ", e);
            }
        }
        if (defaultWords != null && !defaultWords.isEmpty()) {
            TreeSet<String> set = new TreeSet<String>();
            for (Object item : defaultWords) {
                if (item instanceof char[]) {
                    set.add(new String((char[])item));
                    continue;
                }
                set.add(String.valueOf(item));
            }
            stopWords = set.toArray(new String[0]);
        }
        return stopWords;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getIndexedURIsWithReviews() throws IOException {
        this.rwl.readLock().lock();
        try {
            BooleanQuery.Builder bq = new BooleanQuery.Builder();
            bq.add((Query)new TermQuery(new Term("__reviewed_topic__", "true")), BooleanClause.Occur.MUST);
            HashSet<String> uris = new HashSet<String>();
            IndexSearcher indexSearcher = this.getSearcher();
            if (indexSearcher != null) {
                TopDocs hits = indexSearcher.search((Query)bq.build(), Integer.MAX_VALUE);
                int i = 0;
                while ((long)i < hits.totalHits.value) {
                    int docID = hits.scoreDocs[i].doc;
                    Document doc = indexSearcher.storedFields().document(docID);
                    IndexableField uriField = doc.getField("__uri__");
                    if (uriField != null) {
                        String stringValue = uriField.stringValue();
                        uris.add(stringValue);
                    }
                    ++i;
                }
            }
            HashSet<String> hashSet = uris;
            return hashSet;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Document> getReviewDocuments(String uriStr) throws IOException {
        this.rwl.readLock().lock();
        try {
            LinkedList<Document> docs = new LinkedList<Document>();
            IndexSearcher indexSearcher = this.getSearcher();
            if (indexSearcher != null) {
                BooleanQuery.Builder bq = new BooleanQuery.Builder();
                bq.add((Query)new TermQuery(new Term("__uri__", uriStr)), BooleanClause.Occur.MUST);
                bq.add((Query)new WildcardQuery(new Term("__review_type__", "*")), BooleanClause.Occur.MUST);
                bq.add((Query)new TermQuery(new Term("__review_type__", "<NULL>")), BooleanClause.Occur.MUST_NOT);
                TopDocs hits = indexSearcher.search((Query)bq.build(), Integer.MAX_VALUE);
                if (hits.totalHits.value > 0L) {
                    ScoreDoc[] scoreDocs = hits.scoreDocs;
                    for (int i = 0; i < scoreDocs.length; ++i) {
                        int doc = scoreDocs[i].doc;
                        Document document = indexSearcher.storedFields().document(doc);
                        docs.add(document);
                    }
                }
            }
            LinkedList<Document> linkedList = docs;
            return linkedList;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    public List<ScoredCompletion> getCompletions(String prefix, CompletionOptions completionOptions) throws IOException {
        List<ScoredCompletion> result;
        IndexSearcher indexSearcher = this.getSearcher();
        if (indexSearcher == null) {
            result = Collections.emptyList();
        } else {
            if (prefix != null) {
                prefix = prefix.toLowerCase();
            }
            PhraseCompletionEngine phraseCompletionEngine = new PhraseCompletionEngine("__lc_title_completion_terms__", indexSearcher, this.searchingAnalyzer);
            result = phraseCompletionEngine.getCompletions(prefix, completionOptions);
            phraseCompletionEngine = new PhraseCompletionEngine("__lc_completion_terms__", indexSearcher, this.searchingAnalyzer);
            result.addAll(phraseCompletionEngine.getCompletions(prefix, completionOptions));
            if (result.isEmpty()) {
                WordCompletionEngine wordCompletionEngine = new WordCompletionEngine(indexSearcher, this.searchingAnalyzer);
                result.addAll(wordCompletionEngine.getCompletions(prefix, completionOptions));
            }
        }
        return this.filterCompletions(result, this.indexingOptions.getStopWords());
    }

    protected List<ScoredCompletion> filterCompletions(List<ScoredCompletion> result, List<String> stopWords) {
        return result.stream().distinct().collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getIndexedTextContent() throws IOException {
        this.rwl.readLock().lock();
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            StringBuilder sb = new StringBuilder();
            IndexSearcher indexSearcher = this.getSearcher();
            if (indexSearcher != null) {
                ContentReconstructor reconstructor = new ContentReconstructor("__completion_terms__", indexSearcher);
                BooleanQuery.Builder bq = new BooleanQuery.Builder();
                bq.add(new BooleanClause((Query)new MatchAllDocsQuery(), BooleanClause.Occur.MUST));
                TopDocs hits = indexSearcher.search((Query)bq.build(), Integer.MAX_VALUE);
                if (hits.totalHits.value > 0L) {
                    ScoreDoc[] scoreDocs = hits.scoreDocs;
                    for (int i = 0; i < scoreDocs.length; ++i) {
                        int doc = scoreDocs[i].doc;
                        String[] tokens = reconstructor.reconstructDocument(doc);
                        if (tokens != null) {
                            for (String string : tokens) {
                                sb.append(string);
                                sb.append(' ');
                            }
                        }
                        map.put(indexSearcher.storedFields().document(doc).get("__uri__"), sb.toString());
                        sb.setLength(0);
                    }
                }
            }
            HashMap<String, String> hashMap = map;
            return hashMap;
        }
        finally {
            this.rwl.readLock().unlock();
        }
    }

    protected Document addFacetsToDocumentAndTaxonomy(Document doc) {
        return doc;
    }

    protected boolean generatesCompletionFields() {
        return false;
    }

    protected boolean createFacetsCollector() {
        return false;
    }

    public static enum IndexingResult {
        SKIPPED,
        UPDATED,
        SKIPPED_CONTENT_ERROR;

    }
}

