/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.json.instance.generator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.SchemaClient;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.json.oxygen.JSONUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.json.instance.generator.GenerationStoppedException;
import ro.sync.json.instance.generator.IGeneratorProgressNotifier;
import ro.sync.json.instance.generator.JSONGenerationException;
import ro.sync.json.instance.generator.JsonGeneratorOptions;
import ro.sync.json.instance.generator.JsonGeneratorUtil;
import ro.sync.json.instance.generator.engine.JsonGeneratorEngine;

public class JsonInstanceGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)JsonInstanceGenerator.class.getName());
    private final SchemaClient clientResolver;
    private IGeneratorProgressNotifier progressTracker;

    public JsonInstanceGenerator() {
        this(null, null);
    }

    public JsonInstanceGenerator(SchemaClient clientResolver, IGeneratorProgressNotifier progressTracker) {
        this.clientResolver = clientResolver;
        this.progressTracker = progressTracker;
    }

    public List<File> generateInstances(JsonGeneratorOptions options) throws JSONGenerationException {
        int dotIndex;
        String fileName = options.getFileName();
        File newDirectory = new File(options.getOutputDirectory());
        if (!newDirectory.exists()) {
            newDirectory.mkdir();
        }
        String filePrefix = (dotIndex = fileName.lastIndexOf(46)) != -1 ? fileName.substring(0, dotIndex) : fileName;
        String fileExtension = dotIndex != -1 ? fileName.substring(dotIndex) : "";
        int noOfInstances = options.getNrOfInstances();
        List<File> generatedInstaces = this.runGenerator(filePrefix, fileExtension, options);
        if (this.progressTracker != null) {
            this.progressTracker.change(noOfInstances == 1 ? 0 : noOfInstances);
            this.progressTracker.done();
        }
        return generatedInstaces;
    }

    private List<File> runGenerator(String filePrefix, String fileExtension, JsonGeneratorOptions options) throws JSONGenerationException {
        ArrayList<File> generatedFiles = new ArrayList<File>();
        int noOfInstances = options.getNrOfInstances();
        Schema jsonSchema = JsonGeneratorUtil.loadSchemaThroughItsSystemID(options.getJSONSchemaSystemID(), this.clientResolver);
        for (int i = 1; i <= noOfInstances; ++i) {
            File newFile = new File(options.getOutputDirectory(), filePrefix + Integer.toString(i) + fileExtension);
            if (this.progressTracker != null && this.progressTracker.isCanceled()) {
                throw new GenerationStoppedException();
            }
            this.changeTaskName(newFile.getPath(), i, noOfInstances);
            if (!options.isOverwriteFiles() && newFile.exists()) continue;
            this.generateInstanceFile(newFile, jsonSchema, options);
            generatedFiles.add(newFile);
        }
        return generatedFiles;
    }

    private String createJSONContentPrettyPrinted(String instance, int indentSize, boolean useTabs) {
        try {
            Object jsonInstance = JSONUtil.createJsonInstance((JSONTokener)new JSONTokener(instance), (boolean)true);
            if (jsonInstance instanceof JSONObject) {
                instance = ((JSONObject)jsonInstance).toString(indentSize, false, useTabs);
            } else if (jsonInstance instanceof JSONArray) {
                instance = ((JSONArray)jsonInstance).toString(indentSize, false, useTabs);
            }
        }
        catch (JSONException e) {
            return instance;
        }
        return instance;
    }

    public String generateInstance(Schema schema, JsonGeneratorOptions options) throws JSONGenerationException {
        try {
            JsonGeneratorEngine jsonEngine = new JsonGeneratorEngine(options);
            return this.createJSONContentPrettyPrinted(jsonEngine.generateInstance(schema), options.getIndentSize(), options.isUseTabs());
        }
        catch (Throwable e) {
            throw new JSONGenerationException("Could not generate JSON instance", e);
        }
    }

    public String generateInstance(InputStream schema, JsonGeneratorOptions options, SchemaClient schemaClientResolver) throws JSONGenerationException {
        Schema jsonSchema = JsonGeneratorUtil.loadSchemaSourceStream(schema, schemaClientResolver);
        return this.generateInstance(jsonSchema, options);
    }

    private void generateInstanceFile(File newFile, Schema schema, JsonGeneratorOptions options) throws JSONGenerationException {
        try (PrintWriter writer = new PrintWriter(new FileWriter(newFile, false));){
            writer.write(this.generateInstance(schema, options));
        }
        catch (IOException e) {
            throw new JSONGenerationException("Cannot create file: " + newFile.getPath(), e);
        }
    }

    private void changeTaskName(String filename, int current, int max) {
        String msg = "Generating " + current + " of " + max + " : " + filename;
        if (this.progressTracker != null) {
            this.progressTracker.changeDetailsMessage(msg);
            if (max != 1) {
                this.progressTracker.change(current);
            }
        } else if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(msg);
        }
    }
}

