/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WeakList<E>
extends AbstractList<E> {
    private final ReferenceQueue<E> queue = new ReferenceQueue();
    private final List<WeakReference<E>> list = new ArrayList<WeakReference<E>>();

    @Override
    public boolean add(E o) {
        this.expungeStaleEntries();
        return this.list.add(new WeakReference<E>(o, this.queue));
    }

    @Override
    public E get(int i) {
        this.expungeStaleEntries();
        return (E)this.list.get(i).get();
    }

    @Override
    public Iterator<E> iterator() {
        this.expungeStaleEntries();
        final Iterator<WeakReference<E>> i = this.list.iterator();
        return new Iterator<E>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public E next() {
                return ((WeakReference)i.next()).get();
            }

            @Override
            public void remove() {
                i.remove();
            }
        };
    }

    @Override
    public int size() {
        this.expungeStaleEntries();
        return this.list.size();
    }

    @Override
    public E remove(int index) {
        return (E)this.list.remove(index).get();
    }

    private void expungeStaleEntries() {
        Reference<E> r;
        while ((r = this.queue.poll()) != null) {
            int i = this.list.indexOf(r);
            if (i == -1) continue;
            this.list.remove(i);
        }
    }
}

