/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.basic.io;

import java.io.IOException;
import java.io.InputStream;

public class RewindableInputStream
extends InputStream {
    static int MIN_SIZE = 1024;
    private Block head;
    private int curBlockAvail;
    private Block curBlock;
    private int curBlockPos;
    private Block lastBlock;
    private boolean saving = true;
    private final InputStream in;
    private boolean pretendClosed = false;
    private boolean eof;

    public RewindableInputStream(InputStream in) {
        if (in == null) {
            throw new NullPointerException();
        }
        this.in = in;
    }

    @Override
    public void close() throws IOException {
        if (this.saving) {
            this.curBlockAvail = 0;
            this.curBlock = null;
            this.pretendClosed = true;
        } else {
            this.head = null;
            this.curBlock = null;
            this.lastBlock = null;
            this.saving = false;
            this.curBlockAvail = 0;
            this.in.close();
        }
    }

    public void rewind() {
        if (!this.saving) {
            throw new IllegalStateException("rewind() after willNotRewind()");
        }
        this.pretendClosed = false;
        if (this.head == null) {
            return;
        }
        this.curBlock = this.head;
        this.curBlockPos = 0;
        this.curBlockAvail = this.curBlock.used;
    }

    public boolean canRewind() {
        return this.saving;
    }

    public void willNotRewind() {
        this.saving = false;
        this.head = null;
        this.lastBlock = null;
        if (this.pretendClosed) {
            this.pretendClosed = false;
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public int read() throws IOException {
        if (this.curBlockAvail > 0) {
            int c = this.curBlock.buf[this.curBlockPos++] & 0xFF;
            --this.curBlockAvail;
            if (this.curBlockAvail == 0) {
                this.curBlock = this.curBlock.next;
                if (this.curBlock != null) {
                    this.curBlockPos = 0;
                    this.curBlockAvail = this.curBlock.used;
                }
            }
            return c;
        }
        int c = this.in.read();
        if (this.saving && c != -1) {
            if (this.lastBlock == null) {
                this.lastBlock = this.head = new Block();
            } else if (this.lastBlock.used == this.lastBlock.buf.length) {
                this.lastBlock = this.lastBlock.next = new Block();
            }
            this.lastBlock.append((byte)c);
        }
        return c;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int nRead;
        block16: {
            if (this.curBlockAvail == 0 && !this.saving) {
                return this.in.read(b, off, len);
            }
            if (b == null) {
                throw new NullPointerException();
            }
            if (len < 0) {
                throw new IndexOutOfBoundsException();
            }
            nRead = 0;
            if (this.curBlockAvail != 0) {
                while (true) {
                    if (len == 0) {
                        return nRead;
                    }
                    b[off++] = this.curBlock.buf[this.curBlockPos++];
                    --len;
                    ++nRead;
                    --this.curBlockAvail;
                    if (this.curBlockAvail != 0) continue;
                    this.curBlock = this.curBlock.next;
                    if (this.curBlock == null) break;
                    this.curBlockAvail = this.curBlock.used;
                    this.curBlockPos = 0;
                }
            }
            if (len == 0) {
                return nRead;
            }
            if (this.eof) {
                return nRead > 0 ? nRead : -1;
            }
            try {
                int n = this.in.read(b, off, len);
                if (n < 0) {
                    this.eof = true;
                    return nRead > 0 ? nRead : -1;
                }
                nRead += n;
                if (this.saving) {
                    if (this.lastBlock == null) {
                        this.lastBlock = this.head = new Block(n);
                    } else if (this.lastBlock.buf.length - this.lastBlock.used < n) {
                        if (this.lastBlock.used != this.lastBlock.buf.length) {
                            int free = this.lastBlock.buf.length - this.lastBlock.used;
                            this.lastBlock.append(b, off, free);
                            off += free;
                            n -= free;
                        }
                        this.lastBlock = this.lastBlock.next = new Block(n);
                    }
                    this.lastBlock.append(b, off, n);
                }
            }
            catch (IOException e) {
                this.eof = true;
                if (nRead != 0) break block16;
                throw e;
            }
        }
        return nRead;
    }

    private static class Block {
        private Block next;
        private final byte[] buf;
        private int used = 0;

        private Block(int minSize) {
            this.buf = new byte[Math.max(MIN_SIZE, minSize)];
        }

        private Block() {
            this(0);
        }

        private void append(byte b) {
            this.buf[this.used++] = b;
        }

        private void append(byte[] b, int off, int len) {
            System.arraycopy(b, off, this.buf, this.used, len);
            this.used += len;
        }
    }
}

