/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.licensemanager.webhelp;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Collectors;
import ro.sync.annotations.obfuscate.SkipLevel;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.Equaler;
import ro.sync.licensemanager.base.A;
import ro.sync.licensemanager.base.F;
import ro.sync.licensemanager.base.LicenseCheckerWithOxygenParent;
import ro.sync.licensemanager.base.N;
import ro.sync.licensemanager.base.S;
import ro.sync.licensemanager.webhelp.LicenseRequirements;
import ro.sync.licensemanager.webhelp.WebHelpProductDescriptor;

@SkipObfuscate(classes=SkipLevel.NOT_SPECIFIED, fields=SkipLevel.PUBLIC, methods=SkipLevel.PUBLIC)
public class WebHelpLicenseChecker
extends LicenseCheckerWithOxygenParent {
    private static final String J = "\nThe generated output may contain partially scrambled content as using trial version.\n";
    public static final String PRODUCT_NAME = "Oxygen WebHelp";
    private static final String[] D = new String[]{"Scripting", "Publishing-Engine"};
    private static final String B = "licensekey.txt";
    private final String C;
    private final String G;
    private final String H;
    private final String E;
    private final String I;
    private boolean F;
    private LicenseRequirements K;

    public WebHelpLicenseChecker(LicenseCheckerWithOxygenParent.LicenseValidationHandler licenseValidationHandler, String string, String string2, String string3) {
        this(licenseValidationHandler, string, string2, string3, PRODUCT_NAME, D);
    }

    public WebHelpLicenseChecker(LicenseCheckerWithOxygenParent.LicenseValidationHandler licenseValidationHandler, String string, String string2, String string3, String string4) {
        this(licenseValidationHandler, string, string2, string3, string4, D);
    }

    public WebHelpLicenseChecker(LicenseCheckerWithOxygenParent.LicenseValidationHandler licenseValidationHandler, String string, String string2, String string3, String string4, String[] stringArray) {
        this(licenseValidationHandler, string, string2, string3, string4, new LicenseRequirements(stringArray, null));
    }

    public WebHelpLicenseChecker(LicenseCheckerWithOxygenParent.LicenseValidationHandler licenseValidationHandler, String string, String string2, String string3, String string4, LicenseRequirements licenseRequirements) {
        this.validationHandler = licenseValidationHandler;
        this.G = string;
        this.H = string2;
        this.C = string3;
        this.K = licenseRequirements;
        this.E = this.getMajorVersion();
        this.I = string4;
    }

    private void C() {
        File file = this.E();
        String string = null;
        if (file != null) {
            try {
                string = N.A(new BufferedInputStream(Files.newInputStream(file.toPath(), new OpenOption[0])));
            }
            catch (IOException iOException) {
                this.validationHandler.error(MessageFormat.format("Could not read the {0} license file: {1}\n{2}", this.I, file, iOException.getMessage()));
            }
        }
        if (string == null || !this.B(string)) {
            this.validationHandler.error(this.B());
        }
    }

    private String B() {
        if (this.C != null) {
            return this.C;
        }
        return this.F();
    }

    private String F() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(MessageFormat.format(this.D(), this.H, this.G));
        return stringBuilder.toString();
    }

    String D() {
        return "You must have a valid " + this.I + " license key to run an " + this.I + " transformation.\nPlease place your license key in a file named {0} in the {1} directory or in the current [DITA-OT-DIRECTORY].\nIf you don't have a license key or you need more details, please contact sales@oxygenxml.com.\n";
    }

    private File E() {
        File file = null;
        if (this.G != null) {
            try {
                File file2 = new File(this.G).getCanonicalFile();
                File file3 = new File(file2, this.H);
                if (file3.exists()) {
                    file = file3;
                } else {
                    File file4 = this.A(file2);
                    if (file4 != null && file4.exists()) {
                        file = file4;
                    }
                }
            }
            catch (IOException iOException) {
                String string = iOException.getMessage();
                this.validationHandler.error(string != null ? string : String.valueOf(iOException));
            }
        }
        return file;
    }

    private File A(File file) {
        File file2;
        File file3;
        File file4 = null;
        File file5 = file.getParentFile();
        if (file5 != null && (file3 = file5.getParentFile()) != null && (file2 = new File(file3, this.H)).exists()) {
            file4 = file2;
        }
        return file4;
    }

    private boolean B(String string) {
        boolean bl = false;
        if (string != null && !string.trim().isEmpty()) {
            WebHelpProductDescriptor webHelpProductDescriptor = new WebHelpProductDescriptor();
            try {
                S s = new S(webHelpProductDescriptor);
                s.A(string, this.E, this.K.getAllowedLicenseComponents(), this.K.getAllowedLicenseCategories());
                F f = s.B();
                String string2 = ((SimpleDateFormat)DateFormat.getDateInstance(2)).format(f.M());
                String string3 = f.J();
                String string4 = f.R();
                this.validationHandler.info(MessageFormat.format("{0} license valid, licensed to: {1}, start date: {2}, license version: {3}", this.I, string3, string2, string4));
                bl = true;
                this.F = f.W();
                if (this.F) {
                    this.validationHandler.warn(J);
                }
            }
            catch (A a2) {
                this.validationHandler.error(MessageFormat.format("Wrong version number in the license key: {0}, required version number: {1}", a2.getMessage(), this.E));
            }
            catch (Exception exception) {
                this.validationHandler.error("Invalid license: " + exception.getMessage());
            }
        }
        return bl;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length <= 0) {
            System.err.format("No parameter found. You need to set the path of the directory with the %s license key as the first parameter of the command.", PRODUCT_NAME);
            System.err.println();
            System.exit(-1);
        } else {
            String string = stringArray[0];
            WebHelpLicenseChecker webHelpLicenseChecker = new WebHelpLicenseChecker(new _A(), string, B, null);
            webHelpLicenseChecker.checkLicense();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkLicense() {
        this.validationHandler.validationStarted();
        try {
            String[] stringArray;
            boolean bl;
            Optional<String> optional;
            if (!this.isRunFromOxygenOrOtherRelatedProduct()) {
                this.C();
            } else if (this.K.hasAllowedLicenseCategories() && (optional = this.getRunFromOxygenCategory()).isPresent() && !(bl = Arrays.stream(stringArray = this.K.getAllowedLicenseCategories()).anyMatch(string -> Equaler.verifyEquals((Object)string, optional.get())))) {
                this.validationHandler.error(MessageFormat.format("An Oxygen license is required with one of the following categories: {0}.\nThe current Oxygen license category is: {1}.", Arrays.stream(stringArray).collect(Collectors.joining(",")), optional.get()));
            }
        }
        finally {
            this.validationHandler.validationEnded();
        }
    }

    public final boolean isTrial() {
        return this.F;
    }

    private static class _A
    implements LicenseCheckerWithOxygenParent.LicenseValidationHandler {
        private boolean A;

        private _A() {
        }

        @Override
        public void error(String string) {
            this.A = true;
            System.err.println(string);
        }

        @Override
        public void info(String string) {
            System.err.println(string);
        }

        @Override
        public void validationStarted() {
            this.A = false;
        }

        @Override
        public void validationEnded() {
            if (this.A) {
                System.exit(-3);
            }
        }

        @Override
        public void warn(String string) {
            System.err.println(string);
        }

        @Override
        public boolean hasErrors() {
            return this.A;
        }
    }
}

