/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.oxygen.json.schema.generator;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.oxygen.JSONUtil;
import ro.sync.basic.io.IOUtil;
import ro.sync.oxygen.json.schema.generator.FormatMatcher;
import ro.sync.oxygen.json.schema.generator.JSONSchemaGeneratorOptions;
import ro.sync.oxygen.json.schema.generator.JSONSchemaSpec;

public class JSONSchemaGenerator {
    private JSONSchemaGeneratorOptions options;
    private JSONSchemaSpec schemaSpecification;
    private JSONObject definitions;

    public JSONSchemaGenerator(JSONSchemaGeneratorOptions options) {
        this.options = options;
    }

    public String generateJSONSchema(String jsonInstance) {
        return this.generateJSONSchema(jsonInstance, 4, false);
    }

    public String generateJSONSchema(String jsonInstance, int indentSize, boolean useTabs) {
        String schemaVersion;
        Object jsonNode = JSONUtil.createJsonInstance((String)jsonInstance);
        JSONObject jsonSchema = new JSONObject();
        this.definitions = new JSONObject();
        this.schemaSpecification = JSONSchemaSpec.DRAFT_4;
        String string = schemaVersion = this.options.getSchemaVersion() != null ? this.options.getSchemaVersion() : this.schemaSpecification.schemaVersion();
        if (schemaVersion.equals(JSONSchemaSpec.DRAFT_4.schemaVersion())) {
            this.schemaSpecification = JSONSchemaSpec.DRAFT_4;
        } else if (schemaVersion.equals(JSONSchemaSpec.DRAFT_6.schemaVersion())) {
            this.schemaSpecification = JSONSchemaSpec.DRAFT_6;
        } else if (schemaVersion.equals(JSONSchemaSpec.DRAFT_7.schemaVersion())) {
            this.schemaSpecification = JSONSchemaSpec.DRAFT_7;
        } else if (schemaVersion.equals(JSONSchemaSpec.DRAFT_2019_09.schemaVersion())) {
            this.schemaSpecification = JSONSchemaSpec.DRAFT_2019_09;
        } else if (schemaVersion.equals(JSONSchemaSpec.DRAFT_2020_12.schemaVersion())) {
            this.schemaSpecification = JSONSchemaSpec.DRAFT_2020_12;
        }
        jsonSchema.put("$schema", (Object)this.schemaSpecification.metaSchemaURL());
        this.generateJsonType(jsonSchema, jsonNode);
        if (this.definitions.length() != 0) {
            jsonSchema.put(this.schemaSpecification.defsKeyword(), (Object)this.definitions);
        }
        return jsonSchema.toString(indentSize, false, useTabs);
    }

    public void generateJSONSchemaFile(URL jsonDocument, int indentSize, boolean useTabs) throws IOException {
        URL outputURL = this.options.getOutputSchemaFile().toURI().toURL();
        String generatedSchema = this.generateJSONSchema(IOUtil.readURL((URL)jsonDocument, (String)"UTF-8"), indentSize, useTabs);
        IOUtil.saveInURLWithUTF8((URL)outputURL, (String)generatedSchema);
    }

    private Object getDefaultValue(Object jsonNode) {
        Object defaultValue = null;
        if (jsonNode instanceof Boolean) {
            defaultValue = false;
        } else if (jsonNode instanceof Number) {
            defaultValue = 0;
        } else if (jsonNode instanceof String) {
            defaultValue = "";
        }
        return defaultValue;
    }

    private boolean hasSameTypeItems(JSONArray array) {
        Class<?> firstItemType = array.get(0).getClass();
        return IntStream.range(1, array.length()).allMatch(i -> firstItemType == array.get(i).getClass());
    }

    private JSONObject generateObjectTypeItem(JSONArray jsonArray) {
        ArrayList properties = new ArrayList();
        JSONObject resultingObject = new JSONObject();
        for (int i = 0; i < jsonArray.length(); ++i) {
            JSONObject objectItem = (JSONObject)jsonArray.get(i);
            this.mergeObjects(resultingObject, objectItem);
            properties.addAll(objectItem.keySet());
        }
        Set<String> requiredProperties = properties.stream().filter(property -> Collections.frequency(properties, property) == jsonArray.length()).collect(Collectors.toSet());
        JSONObject itemObject = new JSONObject();
        this.generateObjectSchema(itemObject, resultingObject, requiredProperties);
        return itemObject;
    }

    public JSONObject mergeObjects(JSONObject base, JSONObject toMerge) {
        for (String key : toMerge.keySet()) {
            Object value = toMerge.get(key);
            if (!base.has(key)) {
                base.put(key, value);
                continue;
            }
            if (value instanceof JSONObject) {
                JSONObject valueObject = (JSONObject)value;
                if (base.optJSONObject(key) == null) continue;
                this.mergeObjects(base.getJSONObject(key), valueObject);
                continue;
            }
            if (base.get(key) instanceof JSONArray && value instanceof JSONArray) {
                JSONArray baseArray = (JSONArray)base.get(key);
                baseArray.putAll((JSONArray)value);
                continue;
            }
            if (base.get(key) instanceof Number && value instanceof Integer) continue;
            base.put(key, value);
        }
        return base;
    }

    private void generateArraySchema(JSONObject jsonSchema, JSONArray jsonArray) {
        jsonSchema.put("type", (Object)"array");
        jsonSchema.put("minItems", 0);
        if (jsonArray.length() != 0) {
            JSONObject itemsType;
            Object itemNode = jsonArray.get(0);
            if (this.hasSameTypeItems(jsonArray)) {
                if (itemNode instanceof JSONObject) {
                    itemsType = this.generateObjectTypeItem(jsonArray);
                } else {
                    JSONObject itemObject = new JSONObject();
                    this.generateJsonType(itemObject, itemNode);
                    itemsType = itemObject;
                }
            } else {
                JSONArray itemsArray = new JSONArray();
                for (int i = 0; i < jsonArray.length(); ++i) {
                    JSONObject itemType = new JSONObject();
                    this.generateJsonType(itemType, jsonArray.get(i));
                    itemsArray.put((Object)itemType);
                }
                itemsType = itemsArray;
            }
            if (itemsType instanceof JSONArray && this.schemaSpecification.isAtLeast(JSONSchemaSpec.DRAFT_2020_12)) {
                jsonSchema.put("prefixItems", (Object)itemsType);
            } else {
                jsonSchema.put("items", (Object)itemsType);
            }
        }
        if (this.options.restrictAdditionals()) {
            jsonSchema.put(this.schemaSpecification.isAtLeast(JSONSchemaSpec.DRAFT_2019_09) ? "unevaluatedItems" : "additionalItems", false);
        }
    }

    private void generateObjectSchema(JSONObject jsonSchema, JSONObject jsonObj, Set<String> requiredProps) {
        JSONObject properties = new JSONObject();
        jsonSchema.put("type", (Object)"object");
        for (String propertyName : jsonObj.keySet()) {
            JSONObject propertySchema = new JSONObject();
            this.generateJsonType(propertySchema, jsonObj.get(propertyName));
            if ("object".equals(propertySchema.get("type")) || "array".equals(propertySchema.get("type"))) {
                String definition = this.extractDefinition(propertyName, propertySchema);
                this.definitions.put(definition, (Object)propertySchema);
                String reference = "#/" + this.schemaSpecification.defsKeyword() + "/" + definition;
                properties.put(propertyName, (Object)new JSONObject().put("$ref", (Object)reference));
                continue;
            }
            properties.put(propertyName, (Object)propertySchema);
        }
        jsonSchema.put("properties", (Object)properties);
        if (this.options.isMakeAllRequired()) {
            jsonSchema.put("required", (Object)properties.names());
        } else if (requiredProps != null && !requiredProps.isEmpty()) {
            jsonSchema.put("required", requiredProps);
        }
        if (this.options.restrictAdditionals()) {
            jsonSchema.put(this.schemaSpecification.isAtLeast(JSONSchemaSpec.DRAFT_2019_09) ? "unevaluatedProperties" : "additionalProperties", false);
        }
    }

    private String extractDefinition(String propertyName, JSONObject propertySchema) {
        Object definition;
        block3: {
            block4: {
                definition = propertyName + "_type";
                if (!this.definitions.has((String)definition)) break block4;
                JSONObject definitionValue = (JSONObject)this.definitions.get((String)definition);
                if (definitionValue.similar((Object)propertySchema)) break block3;
                boolean similarDef = false;
                for (String globalDef : this.definitions.keySet()) {
                    if (!propertySchema.similar(this.definitions.get(globalDef))) continue;
                    definition = globalDef;
                    similarDef = true;
                    break;
                }
                if (similarDef) break block3;
                int defIndex = 2;
                while (this.definitions.has((String)definition)) {
                    definition = propertyName + defIndex++ + "_type";
                }
                break block3;
            }
            for (String globalDef : this.definitions.keySet()) {
                if (!propertySchema.similar(this.definitions.get(globalDef))) continue;
                definition = globalDef;
                break;
            }
        }
        return definition;
    }

    private void generateJsonType(JSONObject jsonSchema, Object jsonNode) {
        if (jsonNode instanceof JSONArray) {
            this.generateArraySchema(jsonSchema, (JSONArray)jsonNode);
        } else if (jsonNode instanceof JSONObject) {
            this.generateObjectSchema(jsonSchema, (JSONObject)jsonNode, null);
        } else if (jsonNode instanceof Boolean) {
            jsonSchema.put("type", (Object)"boolean");
        } else if (jsonNode instanceof Integer) {
            jsonSchema.put("type", (Object)"integer");
        } else if (jsonNode instanceof Number) {
            jsonSchema.put("type", (Object)"number");
        } else if (jsonNode.equals(JSONObject.NULL)) {
            jsonSchema.put("type", (Object)"null");
        } else if (jsonNode instanceof String) {
            String format;
            jsonSchema.put("type", (Object)"string");
            if (this.options.isMatchFormat() && (format = new FormatMatcher(this.schemaSpecification).getFormatToMatch(jsonNode.toString())) != null) {
                jsonSchema.put("format", (Object)format);
            }
        }
        if (this.options.isAddDefaultValues() && !JSONUtil.isComplexValue((Object)jsonNode)) {
            if (jsonNode instanceof String && this.schemaSpecification.isAtLeast(JSONSchemaSpec.DRAFT_6) && !jsonNode.toString().equals(this.getDefaultValue(jsonNode))) {
                jsonSchema.put("examples", (Object)new JSONArray().put((Object)jsonNode.toString()));
            }
            jsonSchema.put("default", this.getDefaultValue(jsonNode));
        }
    }
}

