/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.imaging.formats.jpeg;

import java.awt.Dimension;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.ByteOrder;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImageParser;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.common.BinaryFunctions;
import org.apache.commons.imaging.common.IImageMetadata;
import org.apache.commons.imaging.common.bytesource.ByteSource;
import org.apache.commons.imaging.formats.jpeg.JpegConstants;
import org.apache.commons.imaging.formats.jpeg.JpegPhotoshopMetadata;
import org.apache.commons.imaging.formats.jpeg.JpegUtils;
import org.apache.commons.imaging.formats.jpeg.decoder.JpegDecoder;
import org.apache.commons.imaging.formats.jpeg.iptc.IptcParser;
import org.apache.commons.imaging.formats.jpeg.iptc.PhotoshopApp13Data;
import org.apache.commons.imaging.formats.jpeg.segments.App13Segment;
import org.apache.commons.imaging.formats.jpeg.segments.App14Segment;
import org.apache.commons.imaging.formats.jpeg.segments.App2Segment;
import org.apache.commons.imaging.formats.jpeg.segments.ComSegment;
import org.apache.commons.imaging.formats.jpeg.segments.DqtSegment;
import org.apache.commons.imaging.formats.jpeg.segments.GenericSegment;
import org.apache.commons.imaging.formats.jpeg.segments.JfifSegment;
import org.apache.commons.imaging.formats.jpeg.segments.Segment;
import org.apache.commons.imaging.formats.jpeg.segments.SofnSegment;
import org.apache.commons.imaging.formats.jpeg.segments.UnknownSegment;
import org.apache.commons.imaging.formats.jpeg.xmp.JpegXmpParser;
import org.apache.commons.imaging.util.Debug;

public class JpegImageParser
extends ImageParser {
    private static final String DEFAULT_EXTENSION = ".jpg";
    private static final String[] ACCEPTED_EXTENSIONS = new String[]{".jpg", ".jpeg"};

    public JpegImageParser() {
        this.setByteOrder(ByteOrder.BIG_ENDIAN);
    }

    @Override
    protected ImageFormat[] getAcceptedTypes() {
        return new ImageFormat[]{ImageFormats.JPEG};
    }

    @Override
    public String getName() {
        return "Jpeg-Custom";
    }

    @Override
    public String getDefaultExtension() {
        return DEFAULT_EXTENSION;
    }

    @Override
    protected String[] getAcceptedExtensions() {
        return ACCEPTED_EXTENSIONS;
    }

    @Override
    public final BufferedImage getBufferedImage(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        JpegDecoder jpegDecoder = new JpegDecoder();
        return jpegDecoder.decode(byteSource);
    }

    private boolean keepMarker(int marker, int[] markers) {
        if (markers == null) {
            return true;
        }
        for (int marker2 : markers) {
            if (marker2 != marker) continue;
            return true;
        }
        return false;
    }

    public List<Segment> readSegments(ByteSource byteSource, final int[] markers, final boolean returnAfterFirst, boolean readEverything) throws ImageReadException, IOException {
        final ArrayList<Segment> result = new ArrayList<Segment>();
        final JpegImageParser parser = this;
        final int[] sofnSegments = new int[]{65472, 65473, 65474, 65475, 65477, 65478, 65479, 65481, 65482, 65483, 65485, 65486, 65487};
        JpegUtils.Visitor visitor = new JpegUtils.Visitor(){

            @Override
            public boolean beginSOS() {
                return false;
            }

            @Override
            public void visitSOS(int marker, byte[] markerBytes, byte[] imageData) {
            }

            @Override
            public boolean visitSegment(int marker, byte[] markerBytes, int markerLength, byte[] markerLengthBytes, byte[] segmentData) throws ImageReadException, IOException {
                if (marker == 65497) {
                    return false;
                }
                if (!JpegImageParser.this.keepMarker(marker, markers)) {
                    return true;
                }
                if (marker == 65517) {
                    result.add(new App13Segment(parser, marker, segmentData));
                } else if (marker == 65518) {
                    result.add(new App14Segment(marker, segmentData));
                } else if (marker == 65506) {
                    result.add(new App2Segment(marker, segmentData));
                } else if (marker == 65504) {
                    result.add(new JfifSegment(marker, segmentData));
                } else if (Arrays.binarySearch(sofnSegments, marker) >= 0) {
                    result.add(new SofnSegment(marker, segmentData));
                } else if (marker == 65499) {
                    result.add(new DqtSegment(marker, segmentData));
                } else if (marker >= 65505 && marker <= 65519) {
                    result.add(new UnknownSegment(marker, segmentData));
                } else if (marker == 65534) {
                    result.add(new ComSegment(marker, segmentData));
                }
                return !returnAfterFirst;
            }
        };
        new JpegUtils().traverseJFIF(byteSource, visitor);
        return result;
    }

    private byte[] assembleSegments(List<App2Segment> segments) throws ImageReadException {
        try {
            return this.assembleSegments(segments, false);
        }
        catch (ImageReadException e) {
            return this.assembleSegments(segments, true);
        }
    }

    private byte[] assembleSegments(List<App2Segment> segments, boolean startWithZero) throws ImageReadException {
        if (segments.isEmpty()) {
            throw new ImageReadException("No App2 Segments Found.");
        }
        int markerCount = segments.get((int)0).numMarkers;
        if (segments.size() != markerCount) {
            throw new ImageReadException("App2 Segments Missing.  Found: " + segments.size() + ", Expected: " + markerCount + ".");
        }
        Collections.sort(segments);
        int offset = startWithZero ? 0 : 1;
        int total = 0;
        for (int i = 0; i < segments.size(); ++i) {
            App2Segment segment = segments.get(i);
            if (i + offset != segment.curMarker) {
                this.dumpSegments(segments);
                throw new ImageReadException("Incoherent App2 Segment Ordering.  i: " + i + ", segment[" + i + "].curMarker: " + segment.curMarker + ".");
            }
            if (markerCount != segment.numMarkers) {
                this.dumpSegments(segments);
                throw new ImageReadException("Inconsistent App2 Segment Count info.  markerCount: " + markerCount + ", segment[" + i + "].numMarkers: " + segment.numMarkers + ".");
            }
            total += segment.iccBytes.length;
        }
        byte[] result = new byte[total];
        int progress = 0;
        for (App2Segment segment : segments) {
            System.arraycopy(segment.iccBytes, 0, result, progress, segment.iccBytes.length);
            progress += segment.iccBytes.length;
        }
        return result;
    }

    private void dumpSegments(List<? extends Segment> v) {
        Debug.debug();
        Debug.debug("dumpSegments: " + v.size());
        for (int i = 0; i < v.size(); ++i) {
            App2Segment segment = (App2Segment)v.get(i);
            Debug.debug(i + ": " + segment.curMarker + " / " + segment.numMarkers);
        }
        Debug.debug();
    }

    public List<Segment> readSegments(ByteSource byteSource, int[] markers, boolean returnAfterFirst) throws ImageReadException, IOException {
        return this.readSegments(byteSource, markers, returnAfterFirst, false);
    }

    @Override
    public byte[] getICCProfileBytes(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        List<Segment> segments = this.readSegments(byteSource, new int[]{65506}, false);
        ArrayList<App2Segment> filtered = new ArrayList<App2Segment>();
        if (segments != null) {
            for (Segment s : segments) {
                App2Segment segment = (App2Segment)s;
                if (segment.iccBytes == null) continue;
                filtered.add(segment);
            }
        }
        if (filtered.isEmpty()) {
            return null;
        }
        byte[] bytes = this.assembleSegments(filtered);
        if (this.getDebug()) {
            System.out.println("bytes: " + bytes.length);
        }
        if (this.getDebug()) {
            System.out.println("");
        }
        return bytes;
    }

    public static boolean isExifAPP1Segment(GenericSegment segment) {
        return BinaryFunctions.startsWith(segment.getSegmentData(), JpegConstants.EXIF_IDENTIFIER_CODE);
    }

    private List<Segment> filterAPP1Segments(List<Segment> segments) {
        ArrayList<Segment> result = new ArrayList<Segment>();
        for (Segment s : segments) {
            GenericSegment segment = (GenericSegment)s;
            if (!JpegImageParser.isExifAPP1Segment(segment)) continue;
            result.add(segment);
        }
        return result;
    }

    public byte[] getExifRawData(ByteSource byteSource) throws ImageReadException, IOException {
        List<Segment> segments = this.readSegments(byteSource, new int[]{65505}, false);
        if (segments == null || segments.isEmpty()) {
            return null;
        }
        List<Segment> exifSegments = this.filterAPP1Segments(segments);
        if (this.getDebug()) {
            System.out.println("exif_segments.size: " + exifSegments.size());
        }
        if (exifSegments.isEmpty()) {
            return null;
        }
        if (exifSegments.size() > 1) {
            throw new ImageReadException("Imaging currently can't parse EXIF metadata split across multiple APP1 segments.  Please send this image to the Imaging project.");
        }
        GenericSegment segment = (GenericSegment)exifSegments.get(0);
        byte[] bytes = segment.getSegmentData();
        return BinaryFunctions.remainingBytes("trimmed exif bytes", bytes, 6);
    }

    public boolean hasExifSegment(ByteSource byteSource) throws ImageReadException, IOException {
        final boolean[] result = new boolean[]{false};
        JpegUtils.Visitor visitor = new JpegUtils.Visitor(){

            @Override
            public boolean beginSOS() {
                return false;
            }

            @Override
            public void visitSOS(int marker, byte[] markerBytes, byte[] imageData) {
            }

            @Override
            public boolean visitSegment(int marker, byte[] markerBytes, int markerLength, byte[] markerLengthBytes, byte[] segmentData) throws ImageReadException, IOException {
                if (marker == 65497) {
                    return false;
                }
                if (marker == 65505 && BinaryFunctions.startsWith(segmentData, JpegConstants.EXIF_IDENTIFIER_CODE)) {
                    result[0] = true;
                    return false;
                }
                return true;
            }
        };
        new JpegUtils().traverseJFIF(byteSource, visitor);
        return result[0];
    }

    public boolean hasIptcSegment(ByteSource byteSource) throws ImageReadException, IOException {
        final boolean[] result = new boolean[]{false};
        JpegUtils.Visitor visitor = new JpegUtils.Visitor(){

            @Override
            public boolean beginSOS() {
                return false;
            }

            @Override
            public void visitSOS(int marker, byte[] markerBytes, byte[] imageData) {
            }

            @Override
            public boolean visitSegment(int marker, byte[] markerBytes, int markerLength, byte[] markerLengthBytes, byte[] segmentData) throws ImageReadException, IOException {
                if (marker == 65497) {
                    return false;
                }
                if (marker == 65517 && new IptcParser().isPhotoshopJpegSegment(segmentData)) {
                    result[0] = true;
                    return false;
                }
                return true;
            }
        };
        new JpegUtils().traverseJFIF(byteSource, visitor);
        return result[0];
    }

    public boolean hasXmpSegment(ByteSource byteSource) throws ImageReadException, IOException {
        final boolean[] result = new boolean[]{false};
        JpegUtils.Visitor visitor = new JpegUtils.Visitor(){

            @Override
            public boolean beginSOS() {
                return false;
            }

            @Override
            public void visitSOS(int marker, byte[] markerBytes, byte[] imageData) {
            }

            @Override
            public boolean visitSegment(int marker, byte[] markerBytes, int markerLength, byte[] markerLengthBytes, byte[] segmentData) throws ImageReadException, IOException {
                if (marker == 65497) {
                    return false;
                }
                if (marker == 65505 && new JpegXmpParser().isXmpJpegSegment(segmentData)) {
                    result[0] = true;
                    return false;
                }
                return true;
            }
        };
        new JpegUtils().traverseJFIF(byteSource, visitor);
        return result[0];
    }

    @Override
    public String getXmpXml(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        final ArrayList result = new ArrayList();
        JpegUtils.Visitor visitor = new JpegUtils.Visitor(){

            @Override
            public boolean beginSOS() {
                return false;
            }

            @Override
            public void visitSOS(int marker, byte[] markerBytes, byte[] imageData) {
            }

            @Override
            public boolean visitSegment(int marker, byte[] markerBytes, int markerLength, byte[] markerLengthBytes, byte[] segmentData) throws ImageReadException, IOException {
                if (marker == 65497) {
                    return false;
                }
                if (marker == 65505 && new JpegXmpParser().isXmpJpegSegment(segmentData)) {
                    result.add(new JpegXmpParser().parseXmpJpegSegment(segmentData));
                    return false;
                }
                return true;
            }
        };
        new JpegUtils().traverseJFIF(byteSource, visitor);
        if (result.isEmpty()) {
            return null;
        }
        if (result.size() > 1) {
            throw new ImageReadException("Jpeg file contains more than one XMP segment.");
        }
        return (String)result.get(0);
    }

    public JpegPhotoshopMetadata getPhotoshopMetadata(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        List<Segment> segments = this.readSegments(byteSource, new int[]{65517}, false);
        if (segments == null || segments.isEmpty()) {
            return null;
        }
        PhotoshopApp13Data photoshopApp13Data = null;
        for (Segment s : segments) {
            App13Segment segment = (App13Segment)s;
            PhotoshopApp13Data data = segment.parsePhotoshopSegment(params);
            if (data != null && photoshopApp13Data != null) {
                throw new ImageReadException("Jpeg contains more than one Photoshop App13 segment.");
            }
            photoshopApp13Data = data;
        }
        if (null == photoshopApp13Data) {
            return null;
        }
        return new JpegPhotoshopMetadata(photoshopApp13Data);
    }

    @Override
    public Dimension getImageSize(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        List<Segment> segments = this.readSegments(byteSource, new int[]{65472, 65473, 65474, 65475, 65477, 65478, 65479, 65481, 65482, 65483, 65485, 65486, 65487}, true);
        if (segments == null || segments.isEmpty()) {
            throw new ImageReadException("No JFIF Data Found.");
        }
        if (segments.size() > 1) {
            throw new ImageReadException("Redundant JFIF Data Found.");
        }
        SofnSegment fSOFNSegment = (SofnSegment)segments.get(0);
        return new Dimension(fSOFNSegment.width, fSOFNSegment.height);
    }

    @Override
    public ImageInfo getImageInfo(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        return null;
    }

    @Override
    public boolean dumpImageFile(PrintWriter pw, ByteSource byteSource) throws ImageReadException, IOException {
        pw.println("tiff.dumpImageFile");
        ImageInfo imageInfo = this.getImageInfo(byteSource);
        if (imageInfo == null) {
            return false;
        }
        imageInfo.toString(pw, "");
        pw.println("");
        List<Segment> segments = this.readSegments(byteSource, null, false);
        if (segments == null) {
            throw new ImageReadException("No Segments Found.");
        }
        for (int d = 0; d < segments.size(); ++d) {
            Segment segment = segments.get(d);
            NumberFormat nf = NumberFormat.getIntegerInstance();
            pw.println(d + ": marker: " + Integer.toHexString(segment.marker) + ", " + segment.getDescription() + " (length: " + nf.format(segment.length) + ")");
            segment.dump(pw);
        }
        pw.println("");
        return true;
    }

    @Override
    public IImageMetadata getMetadata(ByteSource byteSource, Map<String, Object> params) throws ImageReadException, IOException {
        return null;
    }
}

