/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.security.manager;

import java.io.FileDescriptor;
import java.security.AccessControlException;
import java.security.Permission;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.security.Sandbox;
import ro.sync.security.manager.SystemPropertyPermissionChecker;
import ro.sync.security.manager.URLPermission;

public final class SandboxSecurityManager
extends SecurityManager {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)SandboxSecurityManager.class.getName());
    private static final boolean DEBUG_ENABLED = LOGGER.isDebugEnabled();
    private final ThreadLocal<Boolean> checking = new ThreadLocal();
    private final SecurityManager delegate;
    private final SecurityManager original;
    private final SystemPropertyPermissionChecker propertyChecker;
    private final boolean alwaysAskURLConfirmation;
    private final Map<Thread, Boolean> checkedJFXThreadsMap = new WeakHashMap<Thread, Boolean>();
    private static final ThreadLocal<Integer> THREAD_DEPTH = ThreadLocal.withInitial(() -> 0);
    private static final int STACK_OVERFLOW_DEPTH_LIMIT = 1000;

    public SandboxSecurityManager(SecurityManager original, SystemPropertyPermissionChecker propertyChecker, boolean alwaysAskURLConfirmation) {
        this.propertyChecker = propertyChecker;
        this.alwaysAskURLConfirmation = alwaysAskURLConfirmation;
        this.delegate = original != null ? original : new SecurityManager();
        this.original = original;
    }

    @Override
    public void checkAccess(ThreadGroup group) {
        this.delegate.checkAccess(group);
        Sandbox.additionalCheckThread(group);
    }

    @Override
    public void checkRead(FileDescriptor fd) {
        if (this.original != null) {
            if (this.isAlreadyChecking()) {
                return;
            }
            try {
                this.original.checkRead(fd);
            }
            finally {
                this.clearCurrentThreadAsChecking();
            }
        }
    }

    @Override
    public void checkRead(String file) {
        if (this.original != null) {
            if (this.isAlreadyChecking()) {
                return;
            }
            try {
                this.original.checkRead(file);
            }
            finally {
                this.clearCurrentThreadAsChecking();
            }
        }
    }

    @Override
    public void checkRead(String file, Object context) {
        if (this.original != null) {
            if (this.isAlreadyChecking()) {
                return;
            }
            try {
                this.original.checkRead(file, context);
            }
            finally {
                this.clearCurrentThreadAsChecking();
            }
        }
    }

    @Override
    public void checkConnect(String host, int port, Object context) {
        this.delegate.checkConnect(host, port, context);
        Sandbox.additionalCheckConnect(host, port);
    }

    @Override
    public void checkConnect(String host, int port) {
        this.delegate.checkConnect(host, port);
        Sandbox.additionalCheckConnect(host, port);
    }

    @Override
    public void checkWrite(String file) {
        if (this.isAlreadyChecking()) {
            return;
        }
        try {
            this.delegate.checkWrite(file);
        }
        finally {
            this.clearCurrentThreadAsChecking();
        }
        Sandbox.additionalCheckWrite(file);
    }

    public void checkUrl(Permission perm) {
        boolean isJFX = false;
        Thread currentThread = Thread.currentThread();
        Boolean jfxThreadCheck = this.checkedJFXThreadsMap.get(currentThread);
        if (jfxThreadCheck != null) {
            isJFX = jfxThreadCheck;
        } else {
            isJFX = SandboxSecurityManager.isJFX(currentThread);
            this.checkedJFXThreadsMap.put(currentThread, isJFX);
        }
        if (!isJFX) {
            Sandbox.additionalCheckURL(perm.getName(), this.alwaysAskURLConfirmation);
        }
    }

    private static boolean isJFX(Thread thread) {
        boolean isJFX = false;
        StackTraceElement[] stackTrace = thread.getStackTrace();
        int noOfStacktraces = stackTrace.length;
        for (int i = noOfStacktraces - 1; i >= 0; --i) {
            if (!stackTrace[i].getClassName().contains("jfx") && !stackTrace[i].getClassName().contains("com.sun.webkit") && !stackTrace[i].getClassName().contains("javafx")) continue;
            isJFX = true;
            break;
        }
        return isJFX;
    }

    @Override
    public void checkPermission(Permission perm) {
        if (this.isAlreadyChecking()) {
            return;
        }
        try {
            this.checkPermissionInternal(perm);
        }
        finally {
            this.clearCurrentThreadAsChecking();
        }
    }

    private boolean isAlreadyChecking() {
        if (Boolean.TRUE.equals(this.checking.get())) {
            return true;
        }
        this.checking.set(Boolean.TRUE);
        return false;
    }

    private void clearCurrentThreadAsChecking() {
        this.checking.remove();
    }

    private void checkPermissionInternal(Permission perm) {
        int depth = 0;
        try {
            String clName;
            depth = SandboxSecurityManager.increaseCheckPermissionsThreadDepth(perm);
            if (this.delegatePermision(perm)) {
                this.delegate.checkPermission(perm);
            }
            if ((clName = perm.getClass().getName()).equals(URLPermission.class.getName()) || "java.net.URLPermission".equals(clName)) {
                this.checkUrl(perm);
            } else if (this.propertyChecker != null && clName.equals(PropertyPermission.class.getName())) {
                this.propertyChecker.checkProperty((PropertyPermission)perm);
            }
        }
        catch (AccessControlException ex) {
            LOGGER.debug("Security permission exception: " + ex.getMessage(), (Throwable)ex);
            throw ex;
        }
        finally {
            SandboxSecurityManager.decreaseCheckPermissionsThreadDepth(depth);
        }
    }

    private boolean delegatePermision(Permission perm) {
        return true;
    }

    private static int increaseCheckPermissionsThreadDepth(Permission perm) {
        int depth = 0;
        if (DEBUG_ENABLED) {
            depth = THREAD_DEPTH.get();
            THREAD_DEPTH.set(++depth);
            if (depth > 1000) {
                LOGGER.debug("Probably a future StackOverflowException will occurr. Requesting perm " + perm + ". Partial stack trace:", (Throwable)new Exception());
            }
        }
        return depth;
    }

    private static void decreaseCheckPermissionsThreadDepth(int depth) {
        if (DEBUG_ENABLED) {
            THREAD_DEPTH.set(--depth);
        }
    }

    public SecurityManager getOriginal() {
        return this.original;
    }
}

