/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.security;

import java.io.FilePermission;
import java.net.SocketPermission;
import java.security.AllPermission;
import java.security.Permission;
import java.security.Permissions;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.function.Supplier;
import ro.sync.basic.io.ProtocolUtil;
import ro.sync.security.PermissionFlags;
import ro.sync.security.permissions.URLPermissionFactory;

final class DefaultPermissionsFactory {
    private static final Map<Long, Supplier<List<? extends Permission>>> PERMISSION_BUILDERS;

    static Permissions getPermissionsFromFlags(long flags, long ... targetFlags) {
        Permissions perms = null;
        if (targetFlags != null && targetFlags.length > 0) {
            perms = new Permissions();
            for (long targetFlag : targetFlags) {
                if (!PermissionFlags.isPermissionFlagSet(flags, targetFlag)) continue;
                Collection<? extends Permission> permissions = DefaultPermissionsFactory.getDefaultPermissions(targetFlag);
                for (Permission permission : permissions) {
                    perms.add(permission);
                }
            }
        }
        return perms;
    }

    private static Collection<? extends Permission> getDefaultPermissions(long flag) {
        Supplier<List<? extends Permission>> permissionBuilder = PERMISSION_BUILDERS.get(flag);
        return permissionBuilder == null ? Collections.emptyList() : (Collection)permissionBuilder.get();
    }

    private DefaultPermissionsFactory() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    static {
        HashMap<Long, Supplier<List>> tempPermBuilders = new HashMap<Long, Supplier<List>>();
        tempPermBuilders.put(1L, () -> Collections.singletonList(new FilePermission("<<ALL FILES>>", "read")));
        tempPermBuilders.put(512L, () -> Collections.singletonList(new FilePermission("<<ALL FILES>>", "write,delete")));
        tempPermBuilders.put(1024L, () -> Collections.singletonList(new FilePermission("<<ALL FILES>>", "delete")));
        tempPermBuilders.put(2L, () -> Collections.singletonList(new PropertyPermission("*", "read")));
        tempPermBuilders.put(128L, () -> Collections.singletonList(new PropertyPermission("*", "write")));
        tempPermBuilders.put(4L, () -> Collections.singletonList(new RuntimePermission("getenv.*", "read")));
        tempPermBuilders.put(8L, () -> Collections.singletonList(new RuntimePermission("setContextClassLoader", null)));
        tempPermBuilders.put(16L, () -> Collections.singletonList(new RuntimePermission("createClassLoader", null)));
        tempPermBuilders.put(32L, () -> Collections.singletonList(new RuntimePermission("getClassLoader", null)));
        tempPermBuilders.put(256L, () -> Collections.singletonList(new SocketPermission("*", "resolve,connect")));
        tempPermBuilders.put(4096L, () -> Collections.singletonList(new RuntimePermission("modifyThread", null)));
        tempPermBuilders.put(64L, () -> Collections.singletonList(new AllPermission()));
        tempPermBuilders.put(2048L, () -> {
            LinkedList<Permission> perms = new LinkedList<Permission>();
            for (String protocol : ProtocolUtil.BUILT_IN_PROTOCOLS) {
                perms.add(URLPermissionFactory.newURLPermission(protocol + ":*", "*:*"));
            }
            return perms;
        });
        PERMISSION_BUILDERS = Collections.unmodifiableMap(tempPermBuilders);
    }
}

