/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.datatype.Datatype2;
import com.thaiopensource.relaxng.pattern.Alphabet;
import com.thaiopensource.relaxng.pattern.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.RestrictionViolationException;
import com.thaiopensource.relaxng.pattern.StringPattern;
import com.thaiopensource.xml.util.Name;
import java.util.Collections;
import java.util.List;
import org.relaxng.datatype.Datatype;

public class DataPattern
extends StringPattern {
    private final Datatype dt;
    private final Name dtName;
    private final List<String> params;

    DataPattern(Datatype dt, Name dtName, List<String> params) {
        super(DataPattern.combineHashCode(31, dt.hashCode()));
        this.dt = dt;
        this.dtName = dtName;
        this.params = params;
    }

    @Override
    boolean samePattern(Pattern other) {
        if (other.getClass() != this.getClass()) {
            return false;
        }
        return this.dt.equals(((DataPattern)other).dt);
    }

    @Override
    public <T> T apply(PatternFunction<T> f) {
        return f.caseData(this);
    }

    public Datatype getDatatype() {
        return this.dt;
    }

    Name getDatatypeName() {
        return this.dtName;
    }

    List<String> getParams() {
        return Collections.unmodifiableList(this.params);
    }

    boolean allowsAnyString() {
        return this.dt instanceof Datatype2 && ((Datatype2)this.dt).alwaysValid();
    }

    @Override
    void checkRestrictions(int context, DuplicateAttributeDetector dad, Alphabet alpha) throws RestrictionViolationException {
        switch (context) {
            case 0: {
                throw new RestrictionViolationException("start_contains_data");
            }
        }
    }
}

