/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.functions.sql;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.DataSource;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.functions.SystemFunction;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.ma.map.MapItem;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.s9api.XmlProcessingError;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.trans.XmlProcessingIncident;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class SQLConnectFn
extends SystemFunction {
    public ObjectValue<Connection> call(XPathContext context, Sequence[] arguments) throws XPathException {
        if (context.getConfiguration().getBooleanProperty(Feature.ALLOW_MULTITHREADING)) {
            context.getController().getErrorReporter().report((XmlProcessingError)new XmlProcessingIncident("SQL JDBC Connections are not thread-safe, so Saxon multithreading should be disabled by setting Feature.ALLOW_MULTITHREADING to false", "SXSQ0005").asWarning());
        }
        Connection connection = null;
        MapItem options = (MapItem)arguments[0].head();
        String dataSource = this.str((Sequence)options.get((AtomicValue)new StringValue("dataSource")));
        String dbString = this.str((Sequence)options.get((AtomicValue)new StringValue("database")));
        String dbDriverString = this.str((Sequence)options.get((AtomicValue)new StringValue("driver")));
        String userString = this.str((Sequence)options.get((AtomicValue)new StringValue("user")));
        String pwdString = this.str((Sequence)options.get((AtomicValue)new StringValue("password")));
        String autoCommitString = this.str((Sequence)options.get((AtomicValue)new StringValue("autoCommit")));
        try {
            if (context.getConfiguration().isTiming()) {
                DriverManager.setLogWriter(new PrintWriter(System.err));
            }
            if (dataSource != null) {
                InitialContext namingContext = new InitialContext();
                DataSource ds = (DataSource)namingContext.lookup(dataSource);
                connection = userString != null && pwdString != null ? ds.getConnection(userString, pwdString) : ds.getConnection();
            } else {
                connection = userString == null && pwdString == null ? DriverManager.getConnection(dbString) : DriverManager.getConnection(dbString, userString, pwdString);
            }
        }
        catch (NamingException nex) {
            if (context.getConfiguration().isTiming()) {
                nex.printStackTrace();
            }
            throw new XPathException("JDBC Connection Failure: failure from naming service", (Throwable)nex).withXPathContext(context).withErrorCode("SXSQ0003");
        }
        catch (SQLException ex) {
            if (context.getConfiguration().isTiming()) {
                ex.printStackTrace();
            }
            throw new XPathException("JDBC Connection Failure", (Throwable)ex).withXPathContext(context).withErrorCode("SXSQ0003");
        }
        try {
            if (!autoCommitString.isEmpty()) {
                connection.setAutoCommit("yes".equals(autoCommitString));
            }
        }
        catch (SQLException e) {
            throw new XPathException("Failed to set autoCommit on JDBC connection " + dbDriverString, (Throwable)e).withXPathContext(context).withErrorCode("SXSQ0003");
        }
        return new ObjectValue((Object)connection, Connection.class);
    }

    private String str(Sequence seq) throws XPathException {
        if (seq == null) {
            return null;
        }
        Item item = seq.head();
        return item == null ? "" : item.getStringValue();
    }
}

