/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.cssvalidator.properties.oxygen;

import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssValue;
import ro.sync.cssvalidator.properties.oxygen.OxyCssBase;

public class MultiValueExpressionValidator {
    static void validate(CssExpression expression, MultiValueExpressionValidatorCallback mveh) throws InvalidParamException {
        do {
            char op;
            mveh.checkFirstValue(expression.getValue());
            expression.next();
            if (expression.end()) {
                mveh.prematureExpressionEnd();
            }
            do {
                op = expression.getOperator();
                mveh.checkValue(expression.getValue());
                expression.next();
            } while (op == ' ' && !expression.end());
            if (op == ' ' || op == ',') continue;
            mveh.unexpectedOperator(op);
        } while (!expression.end());
    }

    public static interface MultiValueExpressionValidatorCallback {
        public void checkFirstValue(CssValue var1) throws InvalidParamException;

        public void checkValue(CssValue var1) throws InvalidParamException;

        public void unexpectedOperator(char var1) throws InvalidParamException;

        public void prematureExpressionEnd() throws InvalidParamException;
    }

    public static abstract class AbstractMultiValueExpressionValidatorCallback
    implements MultiValueExpressionValidatorCallback {
        private final OxyCssBase prop;
        private final ApplContext ac;

        protected AbstractMultiValueExpressionValidatorCallback(OxyCssBase prop, ApplContext ac) {
            this.prop = prop;
            this.ac = ac;
        }

        @Override
        public void unexpectedOperator(char operator) throws InvalidParamException {
            this.prop.signalInvalidValue(Character.toString(operator), this.ac);
        }

        @Override
        public void prematureExpressionEnd() throws InvalidParamException {
            this.prop.signalInvalidValue(this.ac);
        }
    }
}

