/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.cssvalidator.properties.generic;

import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;
import org.w3c.css.parser.AtRule;
import org.w3c.css.util.ApplContext;
import org.w3c.css.values.CssExpression;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import ro.sync.cssvalidator.properties.generic.CSSCustomProperty;

public abstract class CssCustomValidatorFactory {
    private final Map<String, CSSCustomProperty> properties = new HashMap<String, CSSCustomProperty>();
    private final Set<String> pseudoClasses = new HashSet<String>();
    private final Set<String> pseudoElements = new HashSet<String>();
    private final Set<String> atRules = new HashSet<String>();
    private final Map<String, String> aliasProperties = new HashMap<String, String>();

    public void initialize(URL validationXml) {
        InputSource is = new InputSource(validationXml.toString());
        this.initialize(is);
    }

    public void initialize(InputSource is) {
        try {
            DocumentBuilderFactoryImpl documentBuilderFactoryImpl = new DocumentBuilderFactoryImpl();
            documentBuilderFactoryImpl.setNamespaceAware(true);
            block12: for (Node propertyNode = documentBuilderFactoryImpl.newDocumentBuilder().parse(is).getDocumentElement().getFirstChild(); propertyNode != null; propertyNode = propertyNode.getNextSibling()) {
                String propName;
                if (propertyNode.getNodeType() != 1) continue;
                switch (propName = propertyNode.getLocalName()) {
                    case "property": {
                        this.processProperty(propertyNode);
                        continue block12;
                    }
                    case "pseudos": {
                        CssCustomValidatorFactory.iterateChildrenForSpecificOnes(propertyNode, "pseudo", attrs -> {
                            Node name = attrs.getNamedItem("name");
                            Node type = attrs.getNamedItem("type");
                            if (name != null && type != null) {
                                Set<String> whereToAdd = "class".equals(type.getNodeValue()) ? this.pseudoClasses : this.pseudoElements;
                                whereToAdd.add(name.getNodeValue());
                            }
                        });
                        continue block12;
                    }
                    case "at-rules": {
                        CssCustomValidatorFactory.iterateChildrenForSpecificOnes(propertyNode, "at-rule", attrs -> {
                            Node name = attrs.getNamedItem("name");
                            if (name != null) {
                                this.atRules.add(name.getNodeValue());
                            }
                        });
                        continue block12;
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processProperty(Node propertyNode) {
        NamedNodeMap attributes = propertyNode.getAttributes();
        String propName = CssCustomValidatorFactory.getPropertyName(attributes);
        if (propName == null) {
            return;
        }
        Node aliasFor = attributes.getNamedItem("alias_for");
        if (aliasFor != null) {
            String aliasForName = aliasFor.getNodeValue().trim();
            if (aliasForName.length() > 0) {
                this.aliasProperties.put(propName, aliasForName);
            }
        } else {
            Node valuesTypesNode = attributes.getNamedItem("values_types");
            String valuesTypes = null;
            if (valuesTypesNode != null) {
                valuesTypes = valuesTypesNode.getNodeValue();
            }
            ArrayList<String> possibleValues = new ArrayList<String>();
            CssCustomValidatorFactory.iterateChildrenForSpecificOnes(propertyNode, "value", attrs -> {
                String value;
                Node name = attrs.getNamedItem("name");
                if (name != null && (value = name.getNodeValue().trim()).length() > 0) {
                    possibleValues.add(value);
                }
            });
            CSSCustomProperty existingProp = this.properties.get(propName);
            if (existingProp == null) {
                this.properties.put(propName, new CSSCustomProperty(propName, possibleValues, valuesTypes != null ? valuesTypes.split(" ") : null));
            } else {
                existingProp.mergeValues(possibleValues, valuesTypes != null ? valuesTypes.split(" ") : null);
            }
        }
    }

    private static String getPropertyName(NamedNodeMap attributes) {
        String propName;
        Node propNameNode = attributes.getNamedItem("name");
        if (propNameNode != null && !(propName = propNameNode.getNodeValue().trim()).isEmpty()) {
            return propName;
        }
        return null;
    }

    private static void iterateChildrenForSpecificOnes(Node propertyNode, String childNodeLocalName, Consumer<NamedNodeMap> consumer) {
        NodeList childNodes = propertyNode.getChildNodes();
        if (childNodes != null) {
            int length = childNodes.getLength();
            for (int i = 0; i < length; ++i) {
                NamedNodeMap attrs;
                Node item = childNodes.item(i);
                if (!childNodeLocalName.equals(item.getLocalName()) || (attrs = item.getAttributes()) == null) continue;
                consumer.accept(attrs);
            }
        }
    }

    public boolean supportsProperty(String propertyName) {
        return this.properties.containsKey(propertyName);
    }

    public String getPropertyForAlias(String alias) {
        return this.aliasProperties.get(alias);
    }

    public synchronized CSSCustomProperty createProperty(ApplContext ac, AtRule atRule, String property, CssExpression expression) throws Exception {
        return this.properties.get(property);
    }

    public boolean containsPseudoClass(String profile, String pseudoClass) {
        return this.pseudoClasses.contains(pseudoClass);
    }

    public boolean containsPseudoElement(String profile, String pseudoElement) {
        return this.pseudoElements.contains(pseudoElement);
    }

    public Set<String> getAtRules() {
        return this.atRules;
    }

    public abstract boolean propertyIsIgnored(String var1);

    public Map<String, CSSCustomProperty> getProperties() {
        return this.properties;
    }

    public abstract boolean containsPseudoFunction(String var1, String var2, String var3);
}

