/*
 * Copyright (c) 2000 World Wide Web Consortium,
 * (Massachusetts Institute of Technology, Institut National de
 * Recherche en Informatique et en Automatique, Keio University). All
 * Rights Reserved. This program is distributed under the W3C's Software
 * Intellectual Property License. This program is distributed in the
 * hope that it will be useful, but WITHOUT ANY WARRANTY; without even
 * the implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE.
 * See W3C License http://www.w3.org/Consortium/Legal/ for more details.
 *
 * $Id$
 */
package org.w3c.flute.parser.selectors;

import java.util.Map;

import org.w3c.flute.css.sac.AttributeCondition;
import org.w3c.flute.css.sac.Condition;

/**
 * A class condition.
 * 
 * @version $Revision$
 * @author  Philippe Le Hegaret, Dan
 */
public class ClassConditionImpl implements AttributeCondition {

  /**
   * The value represents the class name.
   */
  String value;

  /**
   * Creates a new AttributeConditionImpl
   * @param value The class name.
   */
  public ClassConditionImpl(String value) {
    this.value = value;
  }

  /**
   * An integer indicating the type of <code>Condition</code>.
   */
  @Override
  public short getConditionType() {
    return Condition.SAC_CLASS_CONDITION;
  }

  /**
   * Returns the
   * <a href="http://www.w3.org/TR/REC-xml-names/#dt-NSName">namespace
   * URI</a> of this attribute condition.
   * <p><code>NULL</code> if :
   * <ul>
   * <li>this attribute condition can match any namespace.
   * <li>this attribute is an id attribute.
   * </ul>
   */
  @Override
  public String getNamespaceURI() {
    return null;
  }

  /**
   * Returns the
   * <a href="http://www.w3.org/TR/REC-xml-names/#NT-LocalPart">local part</a>
   * of the
   * <a href="http://www.w3.org/TR/REC-xml-names/#ns-qualnames">qualified
   * name</a> of this attribute.
   * <p><code>NULL</code> if :
   * <ul>
   * <li><p>this attribute condition can match any attribute.
   * <li><p>this attribute is a class attribute.
   * <li><p>this attribute is an id attribute.
   * <li><p>this attribute is a pseudo-class attribute.
   * </ul>
   */
  @Override
  public String getLocalName() {
    return null;
  }

  /**
   * Returns <code>true</code> if the attribute must have an explicit value
   * in the original document, <code>false</code> otherwise.
   */
  @Override
  public boolean getSpecified() {
    return false;
  }

  /**
   * Returns the value of the attribute.
   * If this attribute is a class or a pseudo class attribute, you'll get
   * the class name (or psedo class name) without the '.' or ':'.
   */
  @Override
  public String getValue() {
    return value;
  }
  
  /**
   * @see org.w3c.flute.css.sac.Condition#getSerialization(java.util.Map)
   */
  @Override
  public String getSerialization(Map<String, String> proxyNamespaceMapping) {
    return "." + value;
  }
}
