<?xml version="1.0" encoding="UTF-8"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="3.0">
    <xsl:output indent="yes"/>
    <xsl:template match="/">
        <xsl:element name="imagemap">
            <xsl:variable name="id" select="svg/@data-id"/>
            <xsl:if test="boolean($id)">
                <xsl:attribute name="id" select="$id"/>
            </xsl:if>
            <xsl:apply-templates/>
        </xsl:element>
    </xsl:template>
    
    <xsl:template match="image">
        <xsl:element name="image">
            <xsl:variable name="href" select="@href"/>
            <xsl:if test="boolean($href)">
                <xsl:attribute name="href" select="$href"/>
            </xsl:if>
            <xsl:variable name="xref" select="@xref"/>
            <xsl:if test="boolean($xref)">
                <xsl:attribute name="xref" select="$xref"/>
            </xsl:if>
            <xsl:variable name="id" select="@data-id"/>
            <xsl:if test="boolean($id)">
                <xsl:attribute name="id" select="$id"/>
            </xsl:if>
            <xsl:variable name="alt" select="@data-alt"/>
            <xsl:if test="boolean($alt)">
                <xsl:element name="alt">
                    <xsl:value-of select="$alt"/>
                </xsl:element>
            </xsl:if>
        </xsl:element>
    </xsl:template>
    
    <xsl:template match="*[@class='shape']" expand-text="yes">
        <xsl:element name="area">
            <xsl:variable name="original_layer" select="@data-original-layer"/>
            <xsl:if test="boolean($original_layer)">
                <xsl:attribute name="original-layer" select="$original_layer"/>
            </xsl:if>
            <xsl:variable name="elementName" select="local-name()"/>
            <xsl:element name="shape">
                <xsl:choose>
                    <xsl:when test="$elementName='circle'">
                        <xsl:value-of select="'circle'"/>
                    </xsl:when>
                    <xsl:when test="$elementName='polygon'">
                        <xsl:value-of select="'poly'"/>
                    </xsl:when>
                    <xsl:when test="$elementName='rect'">
                        <xsl:value-of select="'rect'"/>
                    </xsl:when>
                </xsl:choose>
            </xsl:element>
            <xsl:element name="coords">
                <xsl:choose>
                    <xsl:when test="$elementName='circle'">
                        <xsl:value-of select="concat(@cx, ', ', @cy, ', ', @r)"/>
                    </xsl:when>
                    <xsl:when test="$elementName='polygon'">
                        <xsl:value-of select="replace(@points, ' ', ', ')"/>
                    </xsl:when>
                    <xsl:when test="$elementName='rect'">
                        <xsl:value-of select="concat(@x, ', ', @y, ', ', @x + @width, ', ', @y + @height)"/>
                    </xsl:when>
                </xsl:choose>
            </xsl:element>
            <xsl:element name="xref">
                <xsl:variable name="href" select="@data-href"/>
                <xsl:if test="boolean($href)">
                    <xsl:attribute name="href" select="$href"/>
                </xsl:if>
                <xsl:variable name="keyref" select="@data-keyref"/>
                <xsl:if test="boolean($keyref)">
                    <xsl:attribute name="href" select="$keyref"/>
                </xsl:if>
                <xsl:variable name="format" select="@data-format"/>
                <xsl:if test="boolean($format)">
                    <xsl:attribute name="format" select="$format"/>
                </xsl:if>
                <xsl:variable name="type" select="@data-type"/>
                <xsl:if test="boolean($type)">
                    <xsl:attribute name="format" select="$type"/>
                </xsl:if>
                <xsl:variable name="scope" select="@data-scope"/>
                <xsl:if test="boolean($scope)">
                    <xsl:attribute name="format" select="$scope"/>
                </xsl:if>
                <xsl:value-of select="@data-description"/>
            </xsl:element>
        </xsl:element>
    </xsl:template>
    
    <!-- Do not copy texts. -->
    <xsl:template match="text()"/>
</xsl:stylesheet>

<!-- 
<imagemap id="gear_pump_map">
    <image href="../images/Gear_pump_exploded.png" id="gear_pump_exploded">
        <alt>Gear Pump</alt>
    </image>
    <area>
        <shape>circle</shape>
        <coords>172, 265, 14</coords>
        <xref href="parts/bushings.dita#bushings_topic/bushings" format="dita"
            >Bushings</xref>
    </area>
    <area>
        <shape>circle</shape>
        <coords>171, 331, 13</coords>
        <xref href="parts/bushings.dita#bushings_topic/bushings" format="dita"
            >Bushings</xref>
    </area>
    <area>
        <shape>circle</shape>
        <coords>327, 198, 14</coords>
        <xref href="parts/bushings.dita#bushings_topic/bushings" format="dita"
            >Bushings</xref>
    </area>
    <area>
        <shape>circle</shape>
        <coords>326, 263, 14</coords>
        <xref href="parts/bushings.dita#bushings_topic/bushings" format="dita"
            >Bushings</xref>
    </area>
    <area>
        <shape>circle</shape>
        <coords>232, 242, 47</coords>
        <xref href="parts/gears.dita#gears_topic/drive_gear" format="dita">Drive
            Gear</xref>
    </area>
    <area>
        <shape>circle</shape>
        <coords>238, 306, 49</coords>
        <xref href="parts/gears.dita#gears_topic/idler_gear" format="dita">Idler
            Gear</xref>
    </area>
    <area>
        <shape>circle</shape>
        <coords>324, 210, 14</coords>
        <xref href="parts/ports.dita#ports_topic/sucction_port" format="dita"
            >Suction Port</xref>
    </area>
    <area>
        <shape>circle</shape>
        <coords>391, 250, 16</coords>
        <xref href="parts/ports.dita#ports_topic/presure_port" format="dita"
            >Pressure Port</xref>
    </area>
    <area>
        <shape>poly</shape>
        <coords>422, 145, 459, 179, 462, 221, 423, 221</coords>
        <xref
            href="parts/mounting-flange.dita#mounting_flange_topic/mounting_flange"
            format="dita">Mounting Flange</xref>
    </area>
    <area>
        <shape>circle</shape>
        <coords>448, 147, 19</coords>
        <xref href="parts/seals.dita#seals_topic/shaft_seal" format="dita">Shaft
            Seal</xref>
    </area>
    <area>
        <shape>poly</shape>
        <coords>135, 208, 183, 247, 184, 393, 160, 397, 158, 383, 172, 380, 174,
            347, 174, 282, 161, 243, 134, 222, 113, 226</coords>
        <xref href="parts/seals.dita#seals_topic/case_seal" format="dita">Case
            Seal</xref>
    </area>
    <area>
        <shape>poly</shape>
        <coords>568, 81, 576, 103, 468, 152, 455, 130</coords>
        <xref href="parts/drive-shaft.dita#drive_shaft_topic/drive_shaft"
            format="dita">Drive Shaft</xref>
    </area>
</imagemap>
-->