/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.xml;

import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;
import ro.sync.textsearch.xml.FilterRules;

public class ElementsFilter
extends DefaultHandler
implements LexicalHandler {
    protected final Deque<State> statesStack = new LinkedList<State>();
    private LexicalHandler delegateLexicalHandler;
    private ContentHandler delegateContentHandler;
    private FilterRules filterRules;

    public ElementsFilter(ContentHandler delegateContentHandler, LexicalHandler delegateLexicalHandler, List<String> tagsAndClasesToIgnore) {
        this.delegateLexicalHandler = delegateLexicalHandler;
        this.delegateContentHandler = delegateContentHandler;
        this.filterRules = new FilterRules(tagsAndClasesToIgnore);
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (!this.isInIgnorableContext()) {
            this.delegateContentHandler.endElement(namespaceURI, localName, qName);
        }
        this.statesStack.removeLast();
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String classNameValue = atts.getValue("class");
        State state = State.NORMAL;
        if (this.filterRules.shouldIgnore(localName, classNameValue) || this.isInIgnorableContext()) {
            state = State.IGNORING;
        } else {
            this.delegateContentHandler.startElement(namespaceURI, localName, qName, atts);
        }
        this.statesStack.addLast(state);
    }

    private boolean isInIgnorableContext() {
        return State.IGNORING == this.statesStack.peekLast();
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        if (!this.isInIgnorableContext()) {
            this.delegateContentHandler.startPrefixMapping(prefix, uri);
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (!this.isInIgnorableContext()) {
            this.delegateContentHandler.characters(ch, start, length);
        }
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (!this.isInIgnorableContext()) {
            this.delegateContentHandler.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
        if (!this.isInIgnorableContext()) {
            this.delegateContentHandler.skippedEntity(name);
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        this.delegateLexicalHandler.startDTD(name, publicId, systemId);
    }

    @Override
    public void endDTD() throws SAXException {
        this.delegateLexicalHandler.endDTD();
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (!this.isInIgnorableContext()) {
            this.delegateLexicalHandler.startEntity(name);
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (!this.isInIgnorableContext()) {
            this.delegateLexicalHandler.endEntity(name);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (!this.isInIgnorableContext()) {
            this.delegateLexicalHandler.startCDATA();
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (!this.isInIgnorableContext()) {
            this.delegateLexicalHandler.endCDATA();
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (!this.isInIgnorableContext()) {
            this.delegateLexicalHandler.comment(ch, start, length);
        }
    }

    @Override
    public void setDocumentLocator(Locator locator) {
        if (!this.isInIgnorableContext()) {
            this.delegateContentHandler.setDocumentLocator(locator);
        }
    }

    @Override
    public void startDocument() throws SAXException {
        if (!this.isInIgnorableContext()) {
            this.delegateContentHandler.startDocument();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        if (!this.isInIgnorableContext()) {
            this.delegateContentHandler.endDocument();
        }
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
        if (!this.isInIgnorableContext()) {
            this.delegateContentHandler.endPrefixMapping(prefix);
        }
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        if (!this.isInIgnorableContext()) {
            this.delegateContentHandler.processingInstruction(target, data);
        }
    }

    private static enum State {
        NORMAL,
        IGNORING;

    }
}

