/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.xml;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.textsearch.xml.XMLElementStorageProvider;

public class ContentAccumulator {
    private static final Logger logger = LoggerFactory.getLogger(ContentAccumulator.class);
    StringBuilder content;
    private List<ContentRange> list = new ArrayList<ContentRange>(1);
    private XMLElementStorageProvider.StorageType storageType;

    public ContentAccumulator(StringBuilder content) {
        this.content = content;
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public void add(int startOffset, int endOffset) {
        ContentRange range = new ContentRange(startOffset, endOffset);
        logger.debug("Adding range {} to {} {}", new Object[]{range, this.list, this.hashCode()});
        this.list.add(range);
    }

    public Reader createReader() {
        ContentReader reader = new ContentReader();
        if (logger.isDebugEnabled()) {
            logger.debug("Created reader {}, for {} {}", new Object[]{reader, this.list, this});
        }
        return reader;
    }

    public void setStorageType(XMLElementStorageProvider.StorageType storageType) {
        this.storageType = storageType;
    }

    public XMLElementStorageProvider.StorageType getStorageType() {
        return this.storageType;
    }

    public String getFirstRangeContent() {
        String ret = null;
        if (!this.list.isEmpty()) {
            ContentRange contentRange = this.list.get(0);
            ret = this.content.substring(contentRange.startOffset, contentRange.endOffset);
        }
        return ret;
    }

    public String getAllContent() {
        StringBuilder ret = new StringBuilder();
        if (!this.list.isEmpty()) {
            for (ContentRange range : this.list) {
                ret.append(this.content.substring(range.startOffset, range.endOffset)).append(" ");
            }
        }
        return ret.toString();
    }

    private class ContentRange {
        private int startOffset;
        private int endOffset;

        private ContentRange(int startOffset, int endOffset) {
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        public int getLength() {
            return this.endOffset - this.startOffset;
        }

        public String toString() {
            return "[" + this.startOffset + ", " + this.endOffset + "]";
        }
    }

    private class ContentReader
    extends Reader {
        private int cRangeIndex = -1;
        private int cCharIndex = 0;
        private ContentRange cRange;

        private ContentReader() {
        }

        @Override
        public int read(char[] cbuf, int off, int len) throws IOException {
            int rd;
            if (logger.isDebugEnabled()) {
                logger.debug("Reading. Current range {}, list is {}", (Object)this.cRange, ContentAccumulator.this.list);
            }
            if (this.cRange == null || this.cCharIndex >= this.cRange.getLength()) {
                this.nextRange();
            }
            if (this.cRange == null) {
                rd = -1;
            } else {
                int n = Math.min(this.cRange.getLength() - this.cCharIndex, len);
                ContentAccumulator.this.content.getChars(this.cRange.startOffset + this.cCharIndex, this.cRange.startOffset + this.cCharIndex + n, cbuf, off);
                this.cCharIndex += n;
                rd = n;
            }
            return rd;
        }

        private void nextRange() {
            ++this.cRangeIndex;
            if (this.cRangeIndex < ContentAccumulator.this.list.size()) {
                this.cRange = ContentAccumulator.this.list.get(this.cRangeIndex);
                this.cCharIndex = 0;
            } else {
                this.cRange = null;
            }
        }

        @Override
        public void close() throws IOException {
        }
    }
}

