/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.xhtml;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.TextField;
import org.apache.lucene.facet.FacetField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import ro.sync.textsearch.fields.TextWithTermVectorsAndPositionsField;
import ro.sync.textsearch.io.TextSearchURIUtil;
import ro.sync.textsearch.xml.IShredder;

public class LightXHTMLMetaShredder
extends DefaultHandler
implements IShredder {
    private static final Logger logger = LoggerFactory.getLogger(LightXHTMLMetaShredder.class);
    private HashMap<String, StringBuilder> attributesAccumulators = new HashMap();
    private static final Map<String, String> META_FIELDS = new HashMap<String, String>(3);
    private Set<String> facetsCollection = new HashSet<String>();

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (logger.isDebugEnabled()) {
            logger.debug("Starting element {} # {} {}", new Object[]{localName, TextSearchURIUtil.maskPasswords(uri), qName});
        }
        if ("meta".equals(localName)) {
            String nameAttributeValue = atts.getValue("name");
            if ("keywords".equals(nameAttributeValue) || "indexterms".equals(nameAttributeValue) || "description".equals(nameAttributeValue) || "wh-search-title".equals(nameAttributeValue) || "topic-facet".equals(nameAttributeValue)) {
                String metaFieldName = META_FIELDS.get(nameAttributeValue);
                StringBuilder attrBuilder = this.attributesAccumulators.computeIfAbsent(metaFieldName, k -> new StringBuilder());
                attrBuilder.append(atts.getValue("content"));
            }
            if ("topic-facet".equals(nameAttributeValue)) {
                StringBuilder attrBuilder = this.attributesAccumulators.computeIfAbsent(META_FIELDS.get(nameAttributeValue), k -> new StringBuilder());
                attrBuilder.append(';');
            }
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void startDocument() throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void startEntity(String name) throws SAXException {
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
    }

    @Override
    public void endCDATA() throws SAXException {
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
    }

    public List<Field> getDocumentFields() {
        ArrayList<Field> documentFields = new ArrayList<Field>();
        if (this.attributesAccumulators.containsKey("topic-facet")) {
            List<Map.Entry<String, List<String>>> facets = this.getFacets(this.attributesAccumulators.remove("topic-facet").toString());
            for (Map.Entry entry : facets) {
                documentFields.add((Field)new FacetField((String)entry.getKey(), ((List)entry.getValue()).toArray(new String[0])));
            }
        }
        Set<String> attrs = this.attributesAccumulators.keySet();
        for (String string : attrs) {
            StringBuilder value = this.attributesAccumulators.get(string);
            boolean store = "__meta_wh_search_title__".equals(string);
            documentFields.add((Field)new TextField(string, value.toString(), store ? Field.Store.YES : Field.Store.NO));
            if (!"keywords".equals(string)) continue;
            documentFields.add(new TextWithTermVectorsAndPositionsField("__lc_keywords_completion_terms__", value.toString().toLowerCase()));
        }
        return documentFields;
    }

    public Set<String> getFacetsCollection() {
        return this.facetsCollection;
    }

    private List<Map.Entry<String, List<String>>> getFacets(String facetsRaw) {
        String[] facetsAndPaths;
        ArrayList<Map.Entry<String, List<String>>> facets = new ArrayList<Map.Entry<String, List<String>>>();
        if (facetsRaw.isEmpty()) {
            return facets;
        }
        for (String facetAndPath : facetsAndPaths = facetsRaw.split(";")) {
            String[] facetAndPathArr = facetAndPath.split("/");
            String facetName = facetAndPathArr[0];
            ArrayList<String> facetPath = new ArrayList<String>();
            for (int i = 1; i < facetAndPathArr.length; ++i) {
                facetPath.add(facetAndPathArr[i]);
            }
            facets.add(new AbstractMap.SimpleEntry(facetName, facetPath));
            this.facetsCollection.add(facetName);
        }
        return facets;
    }

    static {
        META_FIELDS.put("keywords", "keywords");
        META_FIELDS.put("indexterms", "__meta_indexterms__");
        META_FIELDS.put("description", "description");
        META_FIELDS.put("wh-search-title", "__meta_wh_search_title__");
        META_FIELDS.put("topic-facet", "topic-facet");
    }
}

