/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.webhelp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.Term;
import org.apache.lucene.queries.spans.SpanOrQuery;
import org.apache.lucene.queries.spans.SpanQuery;
import org.apache.lucene.queries.spans.SpanTermQuery;
import org.apache.lucene.search.CollectorManager;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.spell.Dictionary;
import org.apache.lucene.search.spell.LuceneDictionary;
import org.apache.lucene.search.suggest.Lookup;
import org.apache.lucene.search.suggest.analyzing.AnalyzingInfixSuggester;
import org.apache.lucene.store.ByteBuffersDirectory;
import org.apache.lucene.store.Directory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.textsearch.completion.Completion;
import ro.sync.textsearch.completion.CompletionEngineUtil;
import ro.sync.textsearch.completion.CompletionExtractor;
import ro.sync.textsearch.completion.CompletionOptions;
import ro.sync.textsearch.completion.CompletionWhitespaceAnalyzer;
import ro.sync.textsearch.completion.SpanPositionsCollectorManager;
import ro.sync.textsearch.webhelp.KeywordsSuggestionsExtractor;
import ro.sync.textsearch.webhelp.SearchSuggestion;

public class KeywordsSuggestionsEngine {
    private static final int MAXIMUM_COMPLETION_SIZE = 20;
    protected static final char[] SPECIAL_END_STOP_TOKEN_CHARS = new char[]{'.', '?', '!', ';', ':', ','};
    private static final Logger logger = LoggerFactory.getLogger(KeywordsSuggestionsEngine.class);
    private IndexSearcher searcher;
    private Analyzer searchingAnalyzer;
    private String searchFieldName = "__lc_keywords_completion_terms__";

    public KeywordsSuggestionsEngine(IndexSearcher searcher, Analyzer searchingAnalyzer) {
        this.searcher = searcher;
        this.searchingAnalyzer = searchingAnalyzer;
    }

    public List<SearchSuggestion> getCompletions(String text, CompletionOptions completionOptions) throws IOException {
        ArrayList<SearchSuggestion> completions = new ArrayList<SearchSuggestion>();
        List<String> searchTokens = this.getTokens(text, completionOptions);
        if (searchTokens.size() >= completionOptions.getMinimumPrefixSize()) {
            logger.debug("Search {} ", searchTokens);
            completions.addAll(this.getCompletions(searchTokens, completionOptions));
        }
        return completions;
    }

    private List<SearchSuggestion> getCompletions(List<String> tokens, CompletionOptions completionOptions) throws IOException {
        ArrayList<SearchSuggestion> completions = new ArrayList<SearchSuggestion>();
        if (tokens != null) {
            List<String> tokensToSearch = this.computeBestMatchesForPartialTokens(tokens, completionOptions);
            CompletionExtractor completionExtractor = this.getCompletionExtractor();
            ArrayList<Completion> keywordsCompletions = new ArrayList<Completion>();
            SpanQuery query = this.getQuery(tokensToSearch, completionOptions);
            if (query != null) {
                logger.debug("Query {}", (Object)query);
                LinkedHashMap docIdsToSpans = (LinkedHashMap)this.searcher.search((Query)query, (CollectorManager)new SpanPositionsCollectorManager());
                logger.debug("Found {} documents.", (Object)docIdsToSpans.size());
                Set entries = docIdsToSpans.entrySet();
                for (Map.Entry docIdToSpan : entries) {
                    keywordsCompletions.addAll(completionExtractor.getCompletionsFromDocument((Integer)docIdToSpan.getKey(), (List)docIdToSpan.getValue()));
                }
                keywordsCompletions.forEach(keywordsComp -> completions.add(new SearchSuggestion(String.join((CharSequence)" ", keywordsComp.getTokens()), 1.0f)));
            }
        }
        return completions;
    }

    private CompletionExtractor getCompletionExtractor() {
        return new KeywordsSuggestionsExtractor(this.searchFieldName, this.searcher, 20);
    }

    private List<String> computeBestMatchesForPartialTokens(List<String> searchTokens, CompletionOptions completionOptions) throws IOException {
        LinkedHashSet<String> finalSearchTokens = new LinkedHashSet<String>();
        try (AnalyzingInfixSuggester infixSuggester = new AnalyzingInfixSuggester((Directory)new ByteBuffersDirectory(), (Analyzer)new CompletionWhitespaceAnalyzer());){
            LuceneDictionary dictionary = new LuceneDictionary(this.searcher.getIndexReader(), this.searchFieldName);
            infixSuggester.build((Dictionary)dictionary);
            for (String searchToken : searchTokens) {
                List lookup = infixSuggester.lookup((CharSequence)searchToken, true, completionOptions.getMaximumNumberOfCompletions());
                for (Lookup.LookupResult lookupResult : lookup) {
                    String result = lookupResult.key.toString().trim();
                    if (!result.equals(searchToken.trim())) {
                        List<String> tokens = CompletionEngineUtil.tokenizeString(result, this.searchingAnalyzer, this.searchFieldName, false, null);
                        if (tokens.isEmpty()) continue;
                        finalSearchTokens.addAll(tokens);
                        continue;
                    }
                    finalSearchTokens.add(searchToken);
                }
            }
        }
        return new ArrayList<String>(finalSearchTokens);
    }

    private SpanQuery getQuery(List<String> tokens, CompletionOptions completionOptions) {
        int size = tokens.size();
        ArrayList<SpanTermQuery> list = new ArrayList<SpanTermQuery>();
        if (size >= completionOptions.getMinimumPrefixSize()) {
            for (int i = 0; i < size; ++i) {
                SpanTermQuery termQuery = new SpanTermQuery(new Term(this.searchFieldName, tokens.get(i)));
                list.add(termQuery);
            }
        }
        if (list.size() == 1) {
            return (SpanQuery)list.get(0);
        }
        return new SpanOrQuery(list.toArray(new SpanQuery[list.size()]));
    }

    public List<String> getTokens(String text, CompletionOptions completionOptions) throws IOException {
        LinkedList<String> result = new LinkedList<String>();
        if (text != null) {
            List<String> tokens = CompletionEngineUtil.tokenizeString(text, this.searchingAnalyzer, this.searchFieldName, false, null);
            int count = 0;
            for (int i = tokens.size() - 1; i >= 0; --i) {
                String tk = tokens.get(i);
                result.addFirst(tk);
                if (count >= completionOptions.getMaximumPrefixSize()) break;
            }
        }
        return result;
    }
}

