/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.shredder;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.xml.sax.helpers.DefaultHandler;
import ro.sync.textsearch.fields.StoredTextField;
import ro.sync.textsearch.fields.TextWithTermVectorsAndPositionsField;
import ro.sync.textsearch.util.Normalizer;
import ro.sync.textsearch.util.TrimUtil;
import ro.sync.textsearch.xml.ContentAccumulator;
import ro.sync.textsearch.xml.IShredder;
import ro.sync.textsearch.xml.IgnorableChunksFilterStringBuilderReader;
import ro.sync.textsearch.xml.QName;
import ro.sync.textsearch.xml.XMLElementStorageProvider;
import ro.sync.textsearch.xml.XMLShredderConfiguration;
import ro.sync.textsearch.xml.XMLShredderConfigurationProvider;

public abstract class AbstractShredderBase
extends DefaultHandler
implements IShredder {
    public static final String EMPTY_STRING = "";
    public static final char IGNORABLE_MARKER = '\u0000';
    public static final char END_OF_TEXT = '\u0003';
    protected StringBuilder rawContent = new StringBuilder();
    protected StringBuilder longDesc = new StringBuilder();
    protected Normalizer normalizer = new Normalizer();
    protected boolean collectDescriptionFromText = true;
    protected boolean collectedDescription;
    protected boolean isContentAfterDescription = false;
    protected int maxDescLength;
    protected String systemId;
    protected XMLShredderConfigurationProvider shredderConfigurationProvider;
    protected XMLElementStorageProvider storageTypeProvider;
    protected ArrayDeque<QName> qNameStack = new ArrayDeque();
    protected ArrayDeque<XMLElementStorageProvider.StorageType> storageStack = new ArrayDeque();
    protected ArrayDeque<Integer> stIndexStack = new ArrayDeque();
    protected String detectedRootNamespace;
    protected String detectedRootLocalName;
    protected String detectedDTDPublicId;
    protected String detectedDTDSystemId;
    protected HashMap<QName, ContentAccumulator> elementsAccumulators = new HashMap();

    protected abstract void setConfiguration(XMLShredderConfiguration var1);

    protected void addSpaceBreak(StringBuilder content) {
        int len = content.length();
        if (len > 0 && content.charAt(len - 1) != ' ') {
            content.append(' ');
        }
    }

    public String trimToWordBoundary(String in, int limit, boolean addDots) {
        String ret;
        if (in.length() != 0) {
            char[] buff = in.toCharArray();
            int wbSize = this.trimToWordBoundary(buff, limit, buff.length);
            if (addDots) {
                int delta = buff.length - wbSize;
                if (delta == 0) {
                    buff = Arrays.copyOf(buff, wbSize);
                } else {
                    if (delta < 3) {
                        buff = Arrays.copyOf(buff, wbSize + 3);
                    }
                    buff[wbSize] = 46;
                    buff[++wbSize] = 46;
                    buff[++wbSize] = 46;
                    ++wbSize;
                }
            }
            ret = new String(buff, 0, wbSize);
        } else {
            ret = in;
        }
        return ret;
    }

    public int trimToWordBoundary(char[] buffer, int maxLen, int bufferLen) {
        if (bufferLen > maxLen) {
            this.setCollectedDescription(true);
        }
        bufferLen = TrimUtil.trimToWordBoundary(buffer, maxLen, bufferLen);
        return bufferLen;
    }

    protected void appendDescription(char[] ch, int start, int length) {
        int cLen = this.longDesc.length();
        if (!this.isCollectedDescription()) {
            if (cLen < this.maxDescLength) {
                boolean rws = cLen == 0 || Character.isWhitespace(this.longDesc.charAt(cLen - 1));
                int l = this.normalizer.normalizeArray(ch, start, length, rws);
                char[] buff = this.normalizer.getBuffer();
                l = this.trimToWordBoundary(buff, this.maxDescLength - cLen, l);
                if (l > 0) {
                    this.longDesc.append(buff, 0, l);
                }
            } else {
                this.setCollectedDescription(true);
            }
        } else {
            this.isContentAfterDescription = true;
        }
    }

    protected Field computeDescriptionField(String title) {
        StringBuilder desc;
        StringField toRet = null;
        String longDescStr = this.longDesc.toString().replaceAll("\\s+", " ").trim();
        if (title != null && longDescStr.startsWith(title)) {
            longDescStr = longDescStr.substring(title.length());
        }
        if ((desc = new StringBuilder(this.trimToWordBoundary(longDescStr, 256, false))).length() > 0) {
            desc.append(this.isContentAfterDescription ? "..." : EMPTY_STRING);
            toRet = new StringField("__desc__", desc.toString(), Field.Store.YES);
        }
        return toRet;
    }

    protected List<Field> getTextAndTermsFieldsForTitle(String title, boolean trimTitle) {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (trimTitle) {
            title = this.trimToWordBoundary(title, 128, true);
        }
        fields.add(new StoredTextField("__xml_title__", title));
        if (this.generatesCompletionFields()) {
            fields.add(new TextWithTermVectorsAndPositionsField("__lc_title_completion_terms__", new IgnorableChunksFilterStringBuilderReader(new StringBuilder(title.toLowerCase()))));
        }
        return fields;
    }

    protected List<Field> getTextAndTermsFields(String rawTextFieldName) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new StoredTextField(rawTextFieldName, this.processRawContentBeforeStore(this.rawContent.toString())));
        if (this.generatesCompletionFields()) {
            fields.add(new TextWithTermVectorsAndPositionsField("__completion_terms__", new IgnorableChunksFilterStringBuilderReader(this.rawContent)));
            fields.add(new TextWithTermVectorsAndPositionsField("__lc_completion_terms__", new IgnorableChunksFilterStringBuilderReader(new StringBuilder(this.rawContent.toString().toLowerCase()))));
        }
        return fields;
    }

    protected String processRawContentBeforeStore(String rawContent) {
        return rawContent;
    }

    public boolean isCollectedDescription() {
        return this.collectedDescription;
    }

    public void setCollectedDescription(boolean collectedDescription) {
        this.collectedDescription = collectedDescription;
    }

    protected boolean generatesCompletionFields() {
        return false;
    }
}

