/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.completion;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompletionOptions {
    private Builder builder;

    private CompletionOptions(Builder builder) {
        this.builder = new Builder(builder);
    }

    public int getMaximumNumberOfCompletions() {
        return this.builder.maximumNumberOfCompletions;
    }

    public int getMaximumNumberOfCompletionsWithSameLength() {
        return this.builder.maximumNumberOfCompletionsWithSameLength;
    }

    public int getMinimumScoreForValidCompletion() {
        return this.builder.minimumScoreForValidCompletion;
    }

    public boolean isUseTrie() {
        return this.builder.useTrie;
    }

    public int getMaximumCompletionSize() {
        return this.builder.maximumCompletionSize;
    }

    public int getMinimumPrefixSize() {
        return this.builder.minimumPrefixSize;
    }

    public int getMaximumPrefixSize() {
        return this.builder.maximumPrefixSize;
    }

    public boolean isUseAccumulators() {
        return this.builder.isUseAccumulators;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nmaximumNumberOfCompletions ").append(this.builder.maximumNumberOfCompletions).append("\nmaximumNumberOfCompletionsWithSameLength ").append(this.builder.maximumNumberOfCompletionsWithSameLength).append("\nminimumScoreForValidCompletion ").append(this.builder.minimumScoreForValidCompletion).append("\nuseTrie ").append(this.builder.useTrie).append("\nmaximumCompletionSize ").append(this.builder.maximumCompletionSize).append("\nminimumPrefixSize ").append(this.builder.minimumPrefixSize).append("\nmaximumPrefixSize ").append(this.builder.maximumPrefixSize).append("\nisUseAccumulators ").append(this.builder.isUseAccumulators);
        return sb.toString();
    }

    public static class Builder {
        private static final Logger logger = LoggerFactory.getLogger((String)Builder.class.getName());
        private int maximumNumberOfCompletions = 16;
        private int maximumNumberOfCompletionsWithSameLength = 2;
        private int minimumScoreForValidCompletion = 1;
        private boolean useTrie = true;
        private int maximumCompletionSize = 12;
        private int minimumPrefixSize = 2;
        private int maximumPrefixSize = 6;
        private boolean isUseAccumulators = true;

        public Builder() {
        }

        private Builder(Builder other) {
            this.maximumNumberOfCompletions = other.maximumNumberOfCompletions;
            this.maximumNumberOfCompletionsWithSameLength = other.maximumNumberOfCompletionsWithSameLength;
            this.minimumScoreForValidCompletion = other.minimumScoreForValidCompletion;
            this.useTrie = other.useTrie;
            this.maximumCompletionSize = other.maximumCompletionSize;
            this.minimumPrefixSize = other.minimumPrefixSize;
            this.maximumPrefixSize = other.maximumPrefixSize;
            this.isUseAccumulators = other.isUseAccumulators;
        }

        public Builder withMaximumNumberOfCompletions(int maximumNumberOfCompletions) {
            if (maximumNumberOfCompletions > 0) {
                this.maximumNumberOfCompletions = maximumNumberOfCompletions;
            } else if (logger.isErrorEnabled()) {
                logger.error("Maximum number of completions should be greater than 0, but was {}", (Object)maximumNumberOfCompletions);
            }
            return this;
        }

        public Builder withMaximumNumberOfCompletionsWithSameLength(int maximumNumberOfCompletionsWithSameLength) {
            if (maximumNumberOfCompletionsWithSameLength > 0) {
                this.maximumNumberOfCompletionsWithSameLength = maximumNumberOfCompletionsWithSameLength;
            } else {
                logger.error("Maximum number of completions with same name should be greater than 0, but was {}", (Object)this.maximumNumberOfCompletions);
            }
            return this;
        }

        public Builder withMinimumScoreForValidCompletion(int minimumScoreForValidCompletion) {
            this.minimumScoreForValidCompletion = minimumScoreForValidCompletion;
            return this;
        }

        public Builder withTrie(boolean useTrie) {
            this.useTrie = useTrie;
            return this;
        }

        public Builder withMaximumCompletionSize(int maximumCompletionSize) {
            if (maximumCompletionSize > 0) {
                this.maximumCompletionSize = maximumCompletionSize;
            } else {
                logger.error("Maximum number of completions size should be greater than 0, but was {}", (Object)this.maximumNumberOfCompletions);
            }
            return this;
        }

        public Builder withMinimumPrefixSize(int minimumPrefixSize) {
            if (minimumPrefixSize > 0) {
                this.minimumPrefixSize = minimumPrefixSize;
            } else {
                logger.error("Minimum prefix size should be greater than 0, but was {}", (Object)this.maximumNumberOfCompletions);
            }
            return this;
        }

        public Builder withMaximumPrefixSize(int maximumPrefixSize) {
            if (maximumPrefixSize > 0) {
                this.maximumPrefixSize = maximumPrefixSize;
            } else {
                logger.error("Maximum prefix size should be greater than 0, but was {}", (Object)this.maximumNumberOfCompletions);
            }
            return this;
        }

        public Builder withAccumulators(boolean useAccumulators) {
            this.isUseAccumulators = useAccumulators;
            return this;
        }

        public CompletionOptions build() {
            return new CompletionOptions(this);
        }
    }
}

