/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch.completion;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.TermVectors;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.store.AlreadyClosedException;
import org.apache.lucene.util.BytesRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.textsearch.completion.Completion;
import ro.sync.textsearch.completion.CompletionExtractor;
import ro.sync.textsearch.completion.ContentReconstructor;
import ro.sync.textsearch.completion.RawCompletion;

public class CompletionExtractorUsingAccumulators
extends CompletionExtractor {
    private static final Logger logger = LoggerFactory.getLogger(CompletionExtractorUsingAccumulators.class);
    private String searchFieldName;
    private int overallAccumulatorsRangeStart;
    private int overallAccumulatorsRangeEnd;

    public CompletionExtractorUsingAccumulators(String searchFieldName, IndexSearcher searcher, int maximumCompletionSize) {
        super(searcher, maximumCompletionSize);
        this.searchFieldName = searchFieldName;
    }

    public CompletionExtractorUsingAccumulators(IndexSearcher searcher, int maximumCompletionSize) {
        super(searcher, maximumCompletionSize);
    }

    @Override
    protected List<Completion> getCompletionsFromDocumentInternal(int docId, List<Integer> endsOfSpans) throws IOException {
        try {
            String documentUri = this.getURI(docId);
            ArrayList<Completion> completions = new ArrayList<Completion>(endsOfSpans.size());
            TermVectors termVectors = this.searcher.getIndexReader().termVectors();
            Terms termVector = termVectors.get(docId, this.searchFieldName);
            List<Accumulator> accumulators = this.initializeAccumulators(endsOfSpans, termVector);
            List<List<Accumulator>> orderedAccumulatorsLists = this.getAccumulatorsListsWithoutOverlapping(accumulators);
            for (List<Accumulator> list : orderedAccumulatorsLists) {
                for (Accumulator accumulator : list) {
                    completions.add(new RawCompletion(documentUri, accumulator.buffer));
                }
            }
            this.populateCompletions(termVector, orderedAccumulatorsLists);
            return completions;
        }
        catch (AlreadyClosedException ex) {
            throw new IOException(ex.getMessage(), ex);
        }
    }

    private List<Accumulator> initializeAccumulators(List<Integer> endsOfSpans, Terms termVector) throws IOException {
        ArrayList<Accumulator> accumulators = new ArrayList<Accumulator>();
        int docSize = ContentReconstructor.getDocSize(termVector);
        this.overallAccumulatorsRangeStart = Integer.MAX_VALUE;
        this.overallAccumulatorsRangeEnd = Integer.MIN_VALUE;
        for (Integer endIndex : endsOfSpans) {
            int accumulatorStart = endIndex;
            int accumulatorEnd = this.getCompletionEndIndex(docSize, accumulatorStart);
            this.updateOverallAccumulatorsRange(accumulatorStart, accumulatorEnd);
            int accumulatorSize = accumulatorEnd - accumulatorStart;
            if (accumulatorSize <= 0) continue;
            Accumulator accumulator = new Accumulator(accumulatorStart, accumulatorSize);
            accumulators.add(accumulator);
        }
        accumulators.sort((o1, o2) -> {
            if (o1.startOffset != o2.startOffset) {
                return o1.startOffset < o2.startOffset ? 1 : 0;
            }
            return o1.completionLength < o2.completionLength ? 0 : 1;
        });
        return accumulators;
    }

    private void updateOverallAccumulatorsRange(int accumulatorStart, int accumulatorEnd) {
        if (accumulatorStart < this.overallAccumulatorsRangeStart) {
            this.overallAccumulatorsRangeStart = accumulatorStart;
        }
        if (accumulatorEnd > this.overallAccumulatorsRangeEnd) {
            this.overallAccumulatorsRangeEnd = accumulatorEnd;
        }
    }

    private List<List<Accumulator>> getAccumulatorsListsWithoutOverlapping(List<Accumulator> accumulators) {
        ArrayList<List<Accumulator>> result = new ArrayList<List<Accumulator>>();
        if (accumulators != null) {
            for (Accumulator accumulator : accumulators) {
                boolean addedInExistingList = false;
                for (List list : result) {
                    if (accumulator.startOffset <= ((Accumulator)list.get((int)(list.size() - 1))).endOffset) continue;
                    list.add(accumulator);
                    addedInExistingList = true;
                    break;
                }
                if (addedInExistingList) continue;
                ArrayList<Accumulator> newList = new ArrayList<Accumulator>();
                newList.add(accumulator);
                result.add(newList);
            }
        }
        return result;
    }

    private void populateCompletions(Terms termVector, List<List<Accumulator>> orderedAccumulatorLists) throws IOException {
        BytesRef bytesRef;
        PostingsEnum postingsEnum = null;
        TermsEnum iterator = termVector.iterator();
        while ((bytesRef = iterator.next()) != null) {
            String termString = bytesRef.utf8ToString();
            logger.debug("Current term {}", (Object)termString);
            postingsEnum = iterator.postings(postingsEnum, 120);
            this.populateCompletionsByTerm(postingsEnum, termString, orderedAccumulatorLists);
            if (!orderedAccumulatorLists.isEmpty()) continue;
            break;
        }
    }

    private void populateCompletionsByTerm(PostingsEnum postingsEnum, String termString, List<List<Accumulator>> orderedAccumulatorLists) throws IOException {
        postingsEnum.nextDoc();
        int fr = postingsEnum.freq();
        for (int j = 0; j < fr; ++j) {
            int p = postingsEnum.nextPosition();
            if (!this.isInOveralAccumulatorsRange(p)) continue;
            Iterator<List<Accumulator>> iterator = orderedAccumulatorLists.iterator();
            while (iterator.hasNext()) {
                List<Accumulator> accumulators = iterator.next();
                this.fillAllAccumulatorsCoveringPosition(termString, p, accumulators);
                if (!accumulators.isEmpty()) continue;
                iterator.remove();
            }
            if (orderedAccumulatorLists.isEmpty()) break;
        }
    }

    private boolean isInOveralAccumulatorsRange(int offset) {
        return offset >= this.overallAccumulatorsRangeStart && offset < this.overallAccumulatorsRangeEnd;
    }

    private void fillAllAccumulatorsCoveringPosition(String termString, int p, List<Accumulator> accumulators) {
        int firstAccumulator = this.getFirstAccumulator(p, accumulators);
        if (firstAccumulator != -1) {
            Accumulator accumulator = accumulators.get(firstAccumulator);
            if (p >= accumulator.startOffset && p < accumulator.endOffset) {
                accumulator.set(p, termString);
            }
            if (accumulator.isFilled()) {
                accumulators.remove(accumulator);
            }
        }
    }

    private int getFirstAccumulator(int offset, List<Accumulator> accumulators) {
        int size = accumulators.size();
        int st = 0;
        int dr = size - 1;
        while (st <= dr) {
            int mid = (st + dr) / 2;
            Accumulator accumulator = accumulators.get(mid);
            if (accumulator.startOffset <= offset) {
                st = mid + 1;
                continue;
            }
            dr = mid - 1;
        }
        int idx = dr >= 0 ? dr : -1;
        return idx;
    }

    private static final class Accumulator {
        private final int startOffset;
        private final int completionLength;
        private final String[] buffer;
        private final int endOffset;
        private int filled = 0;

        private Accumulator(int startOffset, int completionLength) {
            this.startOffset = startOffset;
            this.endOffset = startOffset + completionLength;
            this.completionLength = completionLength;
            this.buffer = new String[completionLength];
        }

        private final void set(int positionInDocument, String token) {
            this.buffer[positionInDocument - this.startOffset] = token;
            ++this.filled;
        }

        private final boolean isFilled() {
            return this.filled == this.completionLength;
        }

        public String toString() {
            return this.startOffset + "-" + this.endOffset;
        }
    }
}

