/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;

public class SearchResult {
    private final int totalHits;
    private final Document[] docs;
    private Set<String> nonExistingURIs = new HashSet<String>();
    private List<String> cleanSearchQueryTokens;
    private Map<String, Integer> facetsToMatchingDocuments;
    private String termMatchingPattern;

    public SearchResult(Document[] docs, int totalHits, String termMatchingPattern, Set<String> nonExistingURIs) {
        this.termMatchingPattern = termMatchingPattern;
        this.docs = docs;
        this.totalHits = totalHits;
        if (nonExistingURIs != null) {
            this.nonExistingURIs.addAll(nonExistingURIs);
        }
    }

    public int getTotalHits() {
        return this.totalHits;
    }

    public Document[] getDocs() {
        return this.docs;
    }

    public String getTermMatchingPattern() {
        return this.termMatchingPattern;
    }

    public Set<String> getNonExistingURIs() {
        return this.nonExistingURIs;
    }

    public List<String> getCleanSearchQueryTokens() {
        return this.cleanSearchQueryTokens;
    }

    public void setCleanSearchQueryTokens(List<String> cleanSearchQueryTokens) {
        this.cleanSearchQueryTokens = cleanSearchQueryTokens;
    }

    public Map<String, Integer> getFacetsToMatchingDocuments() {
        return this.facetsToMatchingDocuments;
    }

    public void setFacetsToMatchingDocuments(Map<String, Integer> facetsToMatchingDocuments) {
        this.facetsToMatchingDocuments = facetsToMatchingDocuments;
    }
}

