/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.textsearch;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.document.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import ro.sync.textsearch.DocumentCreator;
import ro.sync.textsearch.IContentType;
import ro.sync.textsearch.IgnoreHandler;
import ro.sync.textsearch.IndexingOptions;
import ro.sync.textsearch.html.HTMLDocumentCreator;
import ro.sync.textsearch.html.LightXHTMLDocumentCreator;
import ro.sync.textsearch.io.TextSearchURIUtil;
import ro.sync.textsearch.pdf.PDFDocumentCreator;
import ro.sync.textsearch.props.InputSourceWithProperties;
import ro.sync.textsearch.props.ResourceProperties;
import ro.sync.textsearch.txt.PlainTextDocumentCreator;
import ro.sync.textsearch.webhelp.converter.IContentConverter;
import ro.sync.textsearch.webhelp.embeddings.IEmbeddingProvider;
import ro.sync.textsearch.xml.XMLDocumentCreator;
import ro.sync.textsearch.xml.XMLOptions;

public class DocumentFactory
implements IContentType {
    private Map<String, DocumentCreator> ct2dc = new HashMap<String, DocumentCreator>();
    private Map<String, String> ext2ct;
    private static final Logger logger = LoggerFactory.getLogger((String)DocumentFactory.class.getName());
    private IgnoreHandler ignoreHandler;

    public DocumentFactory(XMLOptions xmlOptions, IndexingOptions indexingOptions) {
        this.ignoreHandler = new IgnoreHandler(indexingOptions.getIgnorePatterns());
        HashMap<String, String> map = indexingOptions.getExtToCT();
        if (map != null) {
            this.ext2ct = (Map)map.clone();
            this.ext2ct.put("pdf", "application/pdf");
        } else {
            this.ext2ct = new HashMap<String, String>(0);
            this.ext2ct.put("txt", "text/plain");
            this.ext2ct.put("xml", "text/xml");
            this.ext2ct.put("ditamap", "text/xml");
            this.ext2ct.put("xhtml", "text/xml");
            this.ext2ct.put("dita", "text/dita");
            this.ext2ct.put("html", "text/html");
            this.ext2ct.put("htm", "text/html");
            this.ext2ct.put("pdf", "application/pdf");
            this.ext2ct.put("md", "text/markdown");
        }
        boolean bindAllElementsToFields = indexingOptions.bindAllElementsToFields();
        PlainTextDocumentCreator ptdc = new PlainTextDocumentCreator(indexingOptions.getEncodingForNonXMLFiles(), 256);
        PDFDocumentCreator pdfdc = new PDFDocumentCreator(256);
        if (!indexingOptions.isXmlAware()) {
            logger.debug("Not XML Aware, using skimming mode.");
        }
        XMLDocumentCreator xdc = new XMLDocumentCreator(xmlOptions, !indexingOptions.isXmlAware(), bindAllElementsToFields, indexingOptions.getXmlAwareContentSizeLimit());
        HTMLDocumentCreator hdc = new HTMLDocumentCreator(xmlOptions, !indexingOptions.isXmlAware(), bindAllElementsToFields, indexingOptions.getXmlAwareContentSizeLimit());
        LightXHTMLDocumentCreator lightXhtmlDocumentCreator = new LightXHTMLDocumentCreator(xmlOptions, indexingOptions.getFacetsConfig());
        this.ct2dc.put("text/xml", xdc);
        this.ct2dc.put("text/wsdl", xdc);
        this.ct2dc.put("text/xproc", xdc);
        this.ct2dc.put("text/rng", xdc);
        this.ct2dc.put("text/sch", xdc);
        this.ct2dc.put("text/nvdl", xdc);
        this.ct2dc.put("text/batch", ptdc);
        this.ct2dc.put("text/c", ptdc);
        this.ct2dc.put("text/cc", ptdc);
        this.ct2dc.put("text/css", ptdc);
        this.ct2dc.put("text/dtd", ptdc);
        this.ct2dc.put("text/html", hdc);
        this.ct2dc.put("text/java", ptdc);
        this.ct2dc.put("text/javascript", ptdc);
        this.ct2dc.put("text/json", ptdc);
        this.ct2dc.put("text/php", ptdc);
        this.ct2dc.put("text/perl", ptdc);
        this.ct2dc.put("text/properties", ptdc);
        this.ct2dc.put("text/python", ptdc);
        this.ct2dc.put("text/rnc", ptdc);
        this.ct2dc.put("text/shell", ptdc);
        this.ct2dc.put("text/sql", ptdc);
        this.ct2dc.put("text/xquery", ptdc);
        this.ct2dc.put("text/markdown", ptdc);
        this.ct2dc.put("text/xsd", xdc);
        this.ct2dc.put("text/xsl", xdc);
        this.ct2dc.put("text/dita", xdc);
        this.ct2dc.put("text/plain", ptdc);
        this.ct2dc.put("application/pdf", pdfdc);
        this.ct2dc.put("text/xhtml", lightXhtmlDocumentCreator);
    }

    public Document[] buildDocumentsFor(InputSource is, long contentLength, List<String> tagsAndClasesToIgnore, IContentConverter contentConverter, IEmbeddingProvider embeddingProvider, boolean generatesCompletionFields) throws DocumentCreator.ParseException {
        String systemId = is.getSystemId();
        Document[] docs = null;
        if (this.ignoreHandler.isIgnored(systemId)) {
            logger.debug("Resource is ignored: {}", (Object)systemId);
            docs = new Document[]{new Document()};
        } else {
            DocumentCreator documentCreator;
            ResourceProperties properties = null;
            if (is instanceof InputSourceWithProperties) {
                properties = ((InputSourceWithProperties)is).getProperties();
            }
            if ((documentCreator = this.getDocumentCreator(systemId, properties)) == null) {
                docs = new Document[]{new Document()};
            } else {
                try {
                    logger.debug("Using creator {} for {} ", (Object)documentCreator, (Object)TextSearchURIUtil.maskPasswords(systemId));
                    docs = documentCreator.createDocuments(is, contentLength, tagsAndClasesToIgnore, contentConverter, embeddingProvider, generatesCompletionFields);
                    logger.debug("Parsing complete.");
                }
                catch (IOException e) {
                    logger.debug("Parsing failed for {} due to {}", (Object)TextSearchURIUtil.maskPasswords(systemId), (Object)e.getMessage());
                    docs = new Document[]{new Document()};
                }
            }
        }
        return docs;
    }

    DocumentCreator getDocumentCreator(String systemId, ResourceProperties properties) {
        DocumentCreator documentCreator = null;
        String name = systemId;
        String contentType = this.getContentType(properties, name);
        if (contentType != null) {
            documentCreator = this.ct2dc.get(contentType);
        }
        return documentCreator;
    }

    private String getContentType(ResourceProperties properties, String name) {
        String contentType = null;
        if (properties != null && properties.isReusableTopic()) {
            contentType = "text/dita";
        } else {
            String extension = null;
            int idx = name.lastIndexOf(46);
            if (idx != -1 && (extension = name.substring(idx + 1)).indexOf(47) != -1) {
                extension = null;
            }
            logger.debug("Detected extension {}", extension);
            contentType = this.ext2ct.get(extension);
        }
        logger.debug("Detected content type:  {}", (Object)contentType);
        return contentType;
    }

    public Document buildPlainTextDocumentFor(InputSource is) throws IOException {
        return new PlainTextDocumentCreator("UTF-8", 256).createDocuments(is, -1L, null, null, null, false)[0];
    }
}

