/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.jfx.media.player;

import java.io.InputStream;
import javafx.scene.image.Image;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.jfx.JFXUtil;

public final class JFXMediaPlayerIcons {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)JFXMediaPlayerIcons.class.getName());
    public static final int ICON_SIZE = 24;
    public static final String PLAY = "/images/Play24.png";
    public static final String PAUSE = "/images/Pause24.png";
    public static final String UNMUTE = "/images/Audio_on.png";
    public static final String MUTE = "/images/Audio_off.png";
    public static final String AUDIO_FAILED = "/images/Audio_Failed.png";
    public static final String VIDEO_FAILED = "/images/Video_Failed.png";
    public static final String FAILED = "/images/Embed_Failed.png";

    private JFXMediaPlayerIcons() {
        throw new UnsupportedOperationException("Instantiation of this utility class is not allowed!");
    }

    public static Image getImage(String imagePath) {
        LOGGER.debug("Load image {}", (Object)imagePath);
        int retinaType = JFXUtil.getRetinaInfo().getRetinaType();
        InputStream imageStream = JFXMediaPlayerIcons.getRetinaImageStream(imagePath, retinaType);
        int width = 24;
        if (imageStream == null) {
            imageStream = JFXMediaPlayerIcons.class.getResourceAsStream(imagePath);
        }
        LOGGER.debug("Create image, requested width {}", (Object)width);
        return new Image(imageStream, (double)width, (double)width, true, true);
    }

    private static InputStream getRetinaImageStream(String imagePath, int retinaType) {
        InputStream imageStream = null;
        if (retinaType != 0) {
            String toLoadRetina;
            int lastIndexOf = imagePath.lastIndexOf(46);
            imageStream = JFXMediaPlayerIcons.class.getResourceAsStream(toLoadRetina = imagePath.subSequence(0, lastIndexOf) + "@2x" + imagePath.substring(lastIndexOf, imagePath.length()));
            LOGGER.debug("Retina icon {} exists? {}", (Object)toLoadRetina, (Object)(imageStream != null ? 1 : 0));
        }
        return imageStream;
    }
}

