/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.charcode.CharacterSet;
import com.icl.saxon.charcode.CharacterSetFactory;
import com.icl.saxon.charcode.PluggableCharacterSet;
import com.icl.saxon.charcode.UnicodeCharacterSet;
import com.icl.saxon.om.Builder;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.CDATAFilter;
import com.icl.saxon.output.ContentHandlerProxy;
import com.icl.saxon.output.DOMEmitter;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.HTMLEmitter;
import com.icl.saxon.output.HTMLIndenter;
import com.icl.saxon.output.NamespaceEmitter;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.output.TEXTEmitter;
import com.icl.saxon.output.UncommittedEmitter;
import com.icl.saxon.output.XHTMLEmitter;
import com.icl.saxon.output.XMLEmitter;
import com.icl.saxon.output.XMLIndenter;
import com.icl.saxon.tinytree.TinyBuilder;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.DocumentImpl;
import com.icl.saxon.tree.TreeBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class GeneralOutputterSaxon
extends Outputter {
    private NamePool namePool;
    private Properties outputProperties;
    private Writer writer;
    private OutputStream outputStream;
    private boolean closeAfterUse = false;
    private int pendingStartTag = -1;
    private AttributeCollection pendingAttList;
    private int[] pendingNSList = new int[20];
    private int pendingNSListSize = 0;
    private boolean suppressAttributes = false;
    char[] charbuffer = new char[1024];

    public GeneralOutputterSaxon(NamePool pool) {
        this.namePool = pool;
        this.pendingAttList = new AttributeCollection(this.namePool, 10);
    }

    public void setOutputDestination(Properties props, Result result) throws TransformerException {
        this.setOutputProperties(props);
        Emitter emitter = this.makeEmitter(props, result);
        emitter.setNamePool(this.namePool);
        emitter.setOutputProperties(props);
        this.setEmitter(emitter);
        this.open();
    }

    public static String urlToFileName(String base) {
        if (null != base) {
            if (base.startsWith("file:////")) {
                base = base.substring(7);
            } else if (base.startsWith("file:///")) {
                base = base.substring(6);
            } else if (base.startsWith("file://")) {
                base = base.substring(5);
            } else if (base.startsWith("file:/")) {
                base = base.substring(5);
            } else if (base.startsWith("file:")) {
                base = base.substring(4);
            }
            if (base.startsWith("file:\\\\\\\\")) {
                base = base.substring(7);
            } else if (base.startsWith("file:\\\\\\")) {
                base = base.substring(6);
            } else if (base.startsWith("file:\\\\")) {
                base = base.substring(5);
            } else if (base.startsWith("file:\\")) {
                base = base.substring(5);
            }
        }
        if (base != null) {
            if (File.separatorChar != '/') {
                base = base.replace('/', File.separatorChar);
            }
            base = GeneralOutputterSaxon.uncorrect(base);
        }
        return base;
    }

    public static String uncorrect(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(37) == -1) {
            return s;
        }
        StringBuilder sbuf = new StringBuilder();
        int l = s.length();
        int ch = -1;
        int b = 0;
        int sumb = 0;
        boolean applyUTF8dec = false;
        int more = -1;
        for (int i = 0; i < l; ++i) {
            char current = s.charAt(i);
            ch = current;
            switch (ch) {
                case 37: {
                    if (i + 2 >= s.length()) break;
                    int hb = (Character.isDigit((char)(ch = (int)s.charAt(++i))) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    ch = s.charAt(++i);
                    int lb = (Character.isDigit((char)ch) ? ch - 48 : 10 + Character.toLowerCase((char)ch) - 97) & 0xF;
                    b = hb << 4 | lb;
                    applyUTF8dec = true;
                    break;
                }
                default: {
                    b = ch;
                    applyUTF8dec = false;
                }
            }
            if (applyUTF8dec) {
                if ((b & 0xC0) == 128) {
                    sumb = sumb << 6 | b & 0x3F;
                    if (--more != 0) continue;
                    sbuf.append((char)sumb);
                    continue;
                }
                if ((b & 0x80) == 0) {
                    sbuf.append((char)b);
                    continue;
                }
                if ((b & 0xE0) == 192) {
                    sumb = b & 0x1F;
                    more = 1;
                    continue;
                }
                if ((b & 0xF0) == 224) {
                    sumb = b & 0xF;
                    more = 2;
                    continue;
                }
                if ((b & 0xF8) == 240) {
                    sumb = b & 7;
                    more = 3;
                    continue;
                }
                if ((b & 0xFC) == 248) {
                    sumb = b & 3;
                    more = 4;
                    continue;
                }
                sumb = b & 1;
                more = 5;
                continue;
            }
            sbuf.append(current);
            more = -1;
        }
        return sbuf.toString();
    }

    public static FileOutputStream makeFileOutputStream(String baseURI, String fileName, boolean mkdirs) throws TransformerException {
        try {
            String dirStr;
            String base;
            File file = new File(fileName);
            if (!file.isAbsolute() && null != (base = GeneralOutputterSaxon.urlToFileName(baseURI))) {
                File baseFile = new File(base);
                file = new File(baseFile.getParent(), fileName);
            }
            if (mkdirs && null != (dirStr = file.getParent()) && dirStr.length() > 0) {
                File dir = new File(dirStr);
                dir.mkdirs();
            }
            FileOutputStream ostream = new FileOutputStream(file);
            return ostream;
        }
        catch (Exception err) {
            throw new TransformerException("Failed to create output file", err);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Emitter makeEmitter(Properties props, Result result) throws TransformerException {
        Emitter emitter;
        if (result instanceof DOMResult) {
            Node resultNode = ((DOMResult)result).getNode();
            if (resultNode != null) {
                if (resultNode instanceof NodeInfo) {
                    if (!(resultNode instanceof DocumentInfo)) throw new TransformerException("Cannot add to an existing Saxon document");
                    DocumentInfo doc = (DocumentInfo)((Object)resultNode);
                    if (resultNode.getFirstChild() != null) {
                        throw new TransformerException("Target document must be empty");
                    }
                    Builder builder = doc instanceof DocumentImpl ? new TreeBuilder() : new TinyBuilder();
                    builder.setRootNode(doc);
                    builder.setSystemId(result.getSystemId());
                    builder.setNamePool(this.namePool);
                    emitter = builder;
                } else {
                    emitter = new DOMEmitter();
                    ((DOMEmitter)emitter).setNode(resultNode);
                }
            } else {
                TinyBuilder builder = new TinyBuilder();
                builder.setSystemId(result.getSystemId());
                builder.setNamePool(this.namePool);
                builder.createDocument();
                Document resultDoc = (Document)((Object)builder.getCurrentDocument());
                ((DOMResult)result).setNode(resultDoc);
                emitter = builder;
            }
        } else if (result instanceof SAXResult) {
            SAXResult sr = (SAXResult)result;
            ContentHandlerProxy proxy = new ContentHandlerProxy();
            proxy.setUnderlyingContentHandler(sr.getHandler());
            if (sr.getLexicalHandler() != null) {
                proxy.setLexicalHandler(sr.getLexicalHandler());
            }
            emitter = proxy;
        } else if (result instanceof Emitter) {
            emitter = (Emitter)result;
        } else {
            if (!(result instanceof StreamResult)) throw new IllegalArgumentException("Unknown type of Result: " + result.getClass());
            String method = props.getProperty("method");
            if (method == null) {
                emitter = new UncommittedEmitter();
            } else if (method.equals("html")) {
                emitter = new HTMLEmitter();
                if (!"no".equals(props.getProperty("indent"))) {
                    HTMLIndenter in = new HTMLIndenter();
                    in.setUnderlyingEmitter(emitter);
                    emitter = in;
                }
            } else if (method.equals("xml")) {
                String cdataElements;
                emitter = new XMLEmitter();
                if ("yes".equals(props.getProperty("indent"))) {
                    XMLIndenter in = new XMLIndenter();
                    in.setUnderlyingEmitter(emitter);
                    emitter = in;
                }
                if ((cdataElements = props.getProperty("cdata-section-elements")) != null && cdataElements.length() > 0) {
                    CDATAFilter filter = new CDATAFilter();
                    filter.setUnderlyingEmitter(emitter);
                    emitter = filter;
                }
            } else if (method.equals("text")) {
                emitter = new TEXTEmitter();
            } else {
                int brace = method.indexOf(125);
                String localName = method.substring(brace + 1);
                int colon = localName.indexOf(58);
                if ((localName = localName.substring(colon + 1)).equals("fop")) {
                    emitter = Emitter.makeEmitter("com.icl.saxon.fop.FOPEmitter");
                } else if (localName.equals("xhtml")) {
                    String cdataElements;
                    emitter = new XHTMLEmitter();
                    if ("yes".equals(props.getProperty("indent"))) {
                        HTMLIndenter in = new HTMLIndenter();
                        in.setUnderlyingEmitter(emitter);
                        emitter = in;
                    }
                    if ((cdataElements = props.getProperty("cdata-section-elements")) != null && cdataElements.length() > 0) {
                        CDATAFilter filter = new CDATAFilter();
                        filter.setUnderlyingEmitter(emitter);
                        emitter = filter;
                    }
                } else {
                    emitter = Emitter.makeEmitter(localName);
                }
            }
            if (emitter.usesWriter()) {
                this.writer = this.getStreamWriter((StreamResult)result, props);
                emitter.setWriter(this.writer);
            } else {
                this.outputStream = this.getOutputStream((StreamResult)result, props);
                emitter.setOutputStream(this.outputStream);
            }
        }
        NamespaceEmitter ne = new NamespaceEmitter();
        ne.setUnderlyingEmitter(emitter);
        return ne;
    }

    private Writer getStreamWriter(StreamResult result, Properties props) throws TransformerException {
        Writer writer;
        block12: {
            this.closeAfterUse = false;
            writer = result.getWriter();
            if (writer == null) {
                OutputStream outputStream = result.getOutputStream();
                if (outputStream == null) {
                    String systemId = result.getSystemId();
                    if (systemId == null) {
                        outputStream = System.out;
                    } else {
                        outputStream = GeneralOutputterSaxon.makeFileOutputStream("", GeneralOutputterSaxon.urlToFileName(systemId), true);
                        this.closeAfterUse = true;
                    }
                }
                CharacterSet charSet = CharacterSetFactory.getCharacterSet(props);
                String encoding = props.getProperty("encoding");
                if (encoding == null) {
                    encoding = "UTF8";
                }
                if (encoding.equalsIgnoreCase("utf-8")) {
                    encoding = "UTF8";
                }
                if (charSet instanceof PluggableCharacterSet) {
                    encoding = ((PluggableCharacterSet)charSet).getEncodingName();
                }
                while (true) {
                    try {
                        writer = new BufferedWriter(new OutputStreamWriter(outputStream, encoding));
                        break block12;
                    }
                    catch (Exception err) {
                        if (encoding.equalsIgnoreCase("UTF8")) {
                            throw new TransformerException("Failed to create a UTF8 output writer");
                        }
                        encoding = "UTF8";
                        charSet = new UnicodeCharacterSet();
                        props.put("encoding", "utf-8");
                        continue;
                    }
                    break;
                }
            }
            if (writer instanceof OutputStreamWriter) {
                String enc = ((OutputStreamWriter)writer).getEncoding();
                props.put("encoding", enc);
            }
        }
        return writer;
    }

    private OutputStream getOutputStream(StreamResult result, Properties props) throws TransformerException {
        this.closeAfterUse = false;
        OutputStream outputStream = result.getOutputStream();
        if (outputStream == null) {
            String systemId = result.getSystemId();
            if (systemId == null) {
                outputStream = System.out;
            } else {
                outputStream = GeneralOutputterSaxon.makeFileOutputStream("", GeneralOutputterSaxon.urlToFileName(systemId), true);
                this.closeAfterUse = true;
            }
        }
        if (outputStream == null) {
            throw new TransformerException("This output method requires a binary output destination");
        }
        return outputStream;
    }

    private void setEmitter(Emitter handler) {
        this.emitter = handler;
    }

    @Override
    public void reset() throws TransformerException {
        if (this.pendingStartTag != -1) {
            this.flushStartTag();
        }
    }

    private void setOutputProperties(Properties details) throws TransformerException {
        this.outputProperties = details;
    }

    @Override
    public Properties getOutputProperties() {
        return this.outputProperties;
    }

    @Override
    public void write(String s) throws TransformerException {
        if (this.pendingStartTag != -1) {
            this.flushStartTag();
        }
        this.emitter.setEscaping(false);
        int len = s.length();
        if (len > this.charbuffer.length) {
            this.charbuffer = new char[len];
        }
        s.getChars(0, len, this.charbuffer, 0);
        this.emitter.characters(this.charbuffer, 0, len);
        this.emitter.setEscaping(true);
    }

    @Override
    public void writeContent(String s) throws TransformerException {
        if (s == null) {
            return;
        }
        int len = s.length();
        if (len > this.charbuffer.length) {
            this.charbuffer = new char[len];
        }
        s.getChars(0, len, this.charbuffer, 0);
        this.writeContent(this.charbuffer, 0, len);
    }

    @Override
    public void writeContent(char[] chars, int start, int length) throws TransformerException {
        if (length == 0) {
            return;
        }
        if (this.pendingStartTag != -1) {
            this.flushStartTag();
        }
        this.emitter.characters(chars, start, length);
    }

    public void writeContent(StringBuffer chars, int start, int len) throws TransformerException {
        if (len == 0) {
            return;
        }
        if (this.pendingStartTag != -1) {
            this.flushStartTag();
        }
        if (len > this.charbuffer.length) {
            this.charbuffer = new char[len];
        }
        chars.getChars(start, start + len, this.charbuffer, 0);
        this.emitter.characters(this.charbuffer, 0, len);
    }

    @Override
    public void writeStartTag(int nameCode) throws TransformerException {
        if (nameCode == -1) {
            this.suppressAttributes = true;
            return;
        }
        this.suppressAttributes = false;
        if (this.pendingStartTag != -1) {
            this.flushStartTag();
        }
        this.pendingAttList.clear();
        this.pendingNSListSize = 0;
        this.pendingStartTag = nameCode;
    }

    @Override
    public int checkAttributePrefix(int nameCode) throws TransformerException {
        int nscode = this.namePool.allocateNamespaceCode(nameCode);
        for (int i = 0; i < this.pendingNSListSize; ++i) {
            if (nscode >> 16 != this.pendingNSList[i] >> 16) continue;
            if ((nscode & 0xFFFF) == (this.pendingNSList[i] & 0xFFFF)) {
                return nameCode;
            }
            String prefix = this.getSubstitutePrefix(nscode);
            int newCode = this.namePool.allocate(prefix, this.namePool.getURI(nameCode), this.namePool.getLocalName(nameCode));
            this.writeNamespaceDeclaration(this.namePool.allocateNamespaceCode(newCode));
            return newCode;
        }
        this.writeNamespaceDeclaration(nscode);
        return nameCode;
    }

    @Override
    public void writeNamespaceDeclaration(int nscode) throws TransformerException {
        if (this.suppressAttributes) {
            return;
        }
        if (this.pendingStartTag == -1) {
            throw new TransformerException("Cannot write a namespace declaration when there is no open start tag");
        }
        for (int i = 0; i < this.pendingNSListSize; ++i) {
            if (nscode >> 16 != this.pendingNSList[i] >> 16) continue;
            return;
        }
        if (this.pendingNSListSize + 1 > this.pendingNSList.length) {
            int[] newlist = new int[this.pendingNSListSize * 2];
            System.arraycopy(this.pendingNSList, 0, newlist, 0, this.pendingNSListSize);
            this.pendingNSList = newlist;
        }
        this.pendingNSList[this.pendingNSListSize++] = nscode;
    }

    @Override
    public void copyNamespaceNode(int nscode) throws TransformerException {
        if (this.pendingStartTag == -1) {
            throw new TransformerException("Cannot copy a namespace node when there is no containing element node");
        }
        if (this.pendingAttList.getLength() > 0) {
            throw new TransformerException("Cannot copy a namespace node to an element after attributes have been added");
        }
        for (int i = 0; i < this.pendingNSListSize; ++i) {
            if (nscode >> 16 != this.pendingNSList[i] >> 16) continue;
            if (nscode == this.pendingNSList[i]) {
                return;
            }
            throw new TransformerException("Cannot create two namespace nodes with the same name");
        }
        this.writeNamespaceDeclaration(nscode);
    }

    private String getSubstitutePrefix(int nscode) {
        String prefix = this.namePool.getPrefixFromNamespaceCode(nscode);
        return prefix + "." + (nscode & 0xFFFF);
    }

    @Override
    public boolean thereIsAnOpenStartTag() {
        return this.pendingStartTag != -1;
    }

    @Override
    public void writeAttribute(int nameCode, String value) throws TransformerException {
        this.writeAttribute(nameCode, value, false);
    }

    @Override
    public void writeAttribute(int nameCode, String value, boolean noEscape) throws TransformerException {
        if (this.suppressAttributes) {
            return;
        }
        if (this.pendingStartTag == -1) {
            throw new TransformerException("Cannot write an attribute when there is no open start tag");
        }
        this.pendingAttList.setAttribute(nameCode, noEscape ? "NO-ESC" : "CDATA", value);
    }

    @Override
    public void writeEndTag(int nameCode) throws TransformerException {
        if (this.pendingStartTag != -1) {
            this.flushStartTag();
        }
        this.emitter.endElement(nameCode);
    }

    @Override
    public void writeComment(String comment) throws TransformerException {
        if (this.pendingStartTag != -1) {
            this.flushStartTag();
        }
        this.emitter.comment(comment.toCharArray(), 0, comment.length());
    }

    @Override
    public void writePI(String target, String data) throws TransformerException {
        if (this.pendingStartTag != -1) {
            this.flushStartTag();
        }
        this.emitter.processingInstruction(target, data);
    }

    @Override
    public void close() throws TransformerException {
        this.emitter.endDocument();
        if (this.closeAfterUse) {
            try {
                if (this.writer != null) {
                    this.writer.close();
                }
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
            }
            catch (IOException err) {
                throw new TransformerException(err);
            }
        }
    }

    protected void flushStartTag() throws TransformerException {
        this.emitter.startElement(this.pendingStartTag, this.pendingAttList, this.pendingNSList, this.pendingNSListSize);
        this.pendingNSListSize = 0;
        this.pendingStartTag = -1;
    }
}

