/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.pattern;

import com.thaiopensource.relaxng.pattern.Alphabet;
import com.thaiopensource.relaxng.pattern.BinaryPattern;
import com.thaiopensource.relaxng.pattern.DuplicateAttributeDetector;
import com.thaiopensource.relaxng.pattern.Pattern;
import com.thaiopensource.relaxng.pattern.PatternFunction;
import com.thaiopensource.relaxng.pattern.RestrictionViolationException;
import com.thaiopensource.relaxng.pattern.SchemaPatternBuilder;

public class ChoicePattern
extends BinaryPattern {
    ChoicePattern(Pattern p1, Pattern p2) {
        super(p1.isNullable() || p2.isNullable(), ChoicePattern.combineHashCode(11, p1.hashCode(), p2.hashCode()), p1, p2);
    }

    @Override
    Pattern expand(SchemaPatternBuilder b) {
        Pattern ep1 = this.p1.expand(b);
        Pattern ep2 = this.p2.expand(b);
        if (ep1 != this.p1 || ep2 != this.p2) {
            return b.makeChoice(ep1, ep2);
        }
        return this;
    }

    @Override
    boolean containsChoice(Pattern p) {
        return this.p1.containsChoice(p) || this.p2.containsChoice(p);
    }

    @Override
    public <T> T apply(PatternFunction<T> f) {
        return f.caseChoice(this);
    }

    @Override
    void checkRestrictions(int context, DuplicateAttributeDetector dad, Alphabet alpha) throws RestrictionViolationException {
        if (dad != null) {
            dad.startChoice();
        }
        this.p1.checkRestrictions(context, dad, alpha);
        if (dad != null) {
            dad.alternative();
        }
        this.p2.checkRestrictions(context, dad, alpha);
        if (dad != null) {
            dad.endChoice();
        }
    }
}

