/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.licensemanager.base;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Optional;
import ro.sync.annotations.obfuscate.SkipObfuscate;
import ro.sync.basic.util.Crypto;
import ro.sync.basic.util.NumberFormatException;
import ro.sync.basic.util.NumberParserUtil;
import ro.sync.licensemanager.base.A.B;
import ro.sync.licensemanager.base.A.D;

public abstract class LicenseCheckerWithOxygenParent {
    static final int A = 31;
    protected static final String SEED = "1200734";
    protected LicenseValidationHandler validationHandler;
    public static final String OXYGEN_LICENSED_ENV = "OXYGEN_LICENSED_ENV";

    protected String getenv(String string) {
        return System.getenv(string);
    }

    private Optional<String[]> A() {
        String string = Crypto.crypt((String)SEED, (String)OXYGEN_LICENSED_ENV);
        String string2 = this.getenv(string);
        if (string2 == null) {
            string2 = this.getenv(OXYGEN_LICENSED_ENV);
        }
        if (string2 != null) {
            string2 = Crypto.decrypt((String)SEED, (String)string2, (boolean)false);
        }
        if (string2 != null) {
            return Optional.of(string2.split(":"));
        }
        return Optional.empty();
    }

    protected Optional<String> getRunFromOxygenCategory() {
        String[] stringArray;
        Optional<String[]> optional = this.A();
        if (optional.isPresent() && (stringArray = optional.get()).length > 4) {
            return Optional.of(stringArray[4]);
        }
        return Optional.empty();
    }

    protected boolean isRunFromOxygenOrOtherRelatedProduct() {
        Optional<String[]> optional = this.A();
        boolean bl = false;
        if (optional.isPresent()) {
            String[] stringArray = optional.get();
            if (stringArray.length > 0) {
                String string = this.getMajorVersion(stringArray[0]);
                String string2 = "27";
                if (stringArray.length >= 6 && this.A(stringArray[5])) {
                    bl = true;
                    this.validationHandler.info("Started from " + stringArray[5] + ", with a license version: " + string + ".");
                } else if (LicenseCheckerWithOxygenParent.A(string2, string)) {
                    bl = true;
                    this.validationHandler.info("Started from a standalone Oxygen installation, with a license version: " + string + ".");
                } else if (stringArray.length > 3) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd");
                    try {
                        Date date = simpleDateFormat.parse(stringArray[2]);
                        int n = Integer.parseInt(stringArray[3]);
                        Calendar calendar = Calendar.getInstance();
                        calendar.setTime(date);
                        calendar.add(5, n);
                        calendar.add(5, 31);
                        calendar.add(5, 1);
                        Date date2 = calendar.getTime();
                        Date date3 = this.getMajorReleaseDate();
                        if (date3.before(date2)) {
                            this.validationHandler.info("Started from a standalone Oxygen installation having maintenance pack up to " + simpleDateFormat.format(date2) + ".");
                            bl = true;
                        }
                    }
                    catch (ParseException parseException) {
                        this.validationHandler.error("Unrecognized date. Unable to determine the maintenance period of the parent oXygen installation.");
                    }
                } else {
                    this.validationHandler.error("Unable to determine the maintenance period of the parent oXygen installation.");
                }
            } else {
                this.validationHandler.error("Cannot extract lincensing data for the parent oXygen installation.");
            }
        }
        return bl;
    }

    private boolean A(String string) {
        return "Oxygen Publishing Service".equals(string) || "Oxygen Styles Basket".equals(string) || "Oxygen Validation Service".equals(string);
    }

    private static boolean A(String string, String string2) {
        boolean bl = false;
        if (string.equals(string2)) {
            bl = true;
        } else {
            try {
                bl = NumberParserUtil.parseInt((String)string) < NumberParserUtil.parseInt((String)string2);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
        }
        return bl;
    }

    protected String getMajorVersion(String string) {
        if (string.contains(".")) {
            int n = string.indexOf(46);
            string = string.substring(0, n);
        }
        return string;
    }

    protected Date getMajorReleaseDate() {
        return new B(){

            @Override
            public String L() {
                return null;
            }

            @Override
            public int R() {
                return 0;
            }

            @Override
            public String U() {
                return null;
            }

            @Override
            public String[] Q() {
                return null;
            }

            @Override
            public String A() {
                return null;
            }

            @Override
            public boolean A(D d) {
                return false;
            }

            @Override
            public String G() {
                return null;
            }
        }.T();
    }

    public void setValidationHandler(LicenseValidationHandler licenseValidationHandler) {
        this.validationHandler = licenseValidationHandler;
    }

    protected String getMajorVersion() {
        return "27";
    }

    @SkipObfuscate
    public static interface LicenseValidationHandler {
        public void error(String var1);

        public void warn(String var1);

        public void info(String var1);

        public void validationStarted();

        public void validationEnded();

        public boolean hasErrors();
    }
}

