/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.xml;

import io.mola.galimatias.GalimatiasParseException;
import io.mola.galimatias.URL;
import java.net.URI;
import java.util.LinkedList;
import nu.validator.datatype.Language;
import nu.validator.xml.UriLangContext;
import org.relaxng.datatype.DatatypeException;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class BaseUriTracker
implements ContentHandler,
UriLangContext {
    private LinkedList<Node> stack = new LinkedList();
    private boolean baseSeen = false;
    private boolean contentLanguageSeen = false;
    private int inHeadDepth = -1;
    private int inCruftDepth = 0;

    private boolean equalsIgnoreAsciiCase(CharSequence one, CharSequence other) {
        if (other == null && one == null) {
            return true;
        }
        if (other == null || one == null) {
            return false;
        }
        if (one.length() != other.length()) {
            return false;
        }
        for (int i = 0; i < other.length(); ++i) {
            char c1;
            char c0 = one.charAt(i);
            if (c0 >= 'A' && c0 <= 'Z') {
                c0 = (char)(c0 + 32);
            }
            if ((c1 = other.charAt(i)) >= 'A' && c1 <= 'Z') {
                c1 = (char)(c1 + 32);
            }
            if (c0 == c1) continue;
            return false;
        }
        return true;
    }

    public BaseUriTracker(String systemId, String contentLanguage) {
        URL url = null;
        try {
            url = URL.parse((String)systemId);
        }
        catch (Exception e) {
            url = null;
        }
        String lang = "";
        boolean langSpecified = false;
        if (contentLanguage != null) {
            try {
                if (!"".equals(contentLanguage)) {
                    Language.THE_INSTANCE.checkValid(contentLanguage);
                }
                lang = contentLanguage;
                langSpecified = true;
            }
            catch (DatatypeException datatypeException) {
                // empty catch block
            }
        }
        this.stack.add(new Node(url, null, lang, langSpecified, false));
        this.stack.add(new Node(url, null, lang, false, false));
    }

    private Node peek() {
        return this.stack.getLast();
    }

    private void pop() {
        this.stack.removeLast();
    }

    private void push(String relative, String language, Direction dir) {
        boolean rtl;
        String lang = "";
        boolean langSpecified = false;
        if (language != null) {
            try {
                if (!"".equals(language)) {
                    Language.THE_INSTANCE.checkValid(language);
                }
                lang = language;
                langSpecified = true;
            }
            catch (DatatypeException datatypeException) {
                // empty catch block
            }
        }
        Node curr = this.peek();
        URL base = curr.currentAbsolute;
        if (!langSpecified) {
            lang = curr.lang;
        }
        switch (dir) {
            case RTL: {
                rtl = true;
                break;
            }
            case LTR: {
                rtl = false;
                break;
            }
            default: {
                rtl = curr.rtl;
            }
        }
        if (relative == null) {
            this.stack.addLast(new Node(base, null, lang, langSpecified, rtl));
        } else {
            URL newBase;
            String ascii = null;
            try {
                if (base != null) {
                    try {
                        newBase = base.resolve(relative);
                    }
                    catch (GalimatiasParseException e) {
                        newBase = base;
                    }
                } else {
                    try {
                        newBase = URL.parse((String)new URI(ascii).toString());
                    }
                    catch (GalimatiasParseException e) {
                        newBase = null;
                    }
                }
            }
            catch (Exception e) {
                newBase = base;
            }
            this.stack.addLast(new Node(newBase, ascii, lang, langSpecified, rtl));
        }
    }

    private void installBase(String href) {
        if (this.baseSeen) {
            return;
        }
        this.baseSeen = true;
        LinkedList<Node> oldStack = this.stack;
        this.stack = new LinkedList();
        int i = 0;
        for (Node node : oldStack) {
            if (i == 0) {
                this.stack.addLast(node);
            } else if (i == 1) {
                this.push(href, node.langSpeficied ? node.lang : null, node.rtl ? Direction.RTL : Direction.LTR);
            } else {
                this.push(node.originalRelative, node.langSpeficied ? node.lang : null, node.rtl ? Direction.RTL : Direction.LTR);
            }
            ++i;
        }
    }

    private void installContentLanguage(String language) {
        if (this.contentLanguageSeen) {
            return;
        }
        this.contentLanguageSeen = true;
        String lang = "";
        boolean langSpecified = false;
        if (language != null) {
            try {
                if (!"".equals(language)) {
                    Language.THE_INSTANCE.checkValid(language);
                }
                lang = language;
                langSpecified = true;
            }
            catch (DatatypeException datatypeException) {
                // empty catch block
            }
        }
        if (!langSpecified) {
            return;
        }
        int i = 0;
        for (Node node : this.stack) {
            if (i != 0) {
                if (i == 1) {
                    node.lang = lang;
                    node.langSpeficied = true;
                } else {
                    if (node.langSpeficied) {
                        return;
                    }
                    node.lang = lang;
                }
            }
            ++i;
        }
    }

    @Override
    public String currentLanguage() {
        return this.stack.getLast().lang;
    }

    @Override
    public boolean isCurrentRtl() {
        return this.stack.getLast().rtl;
    }

    @Override
    public String toAbsoluteUriWithCurrentBase(String uri) {
        try {
            URL base = this.stack.getLast().currentAbsolute;
            return URL.parse((URL)base, (String)uri).toString();
        }
        catch (GalimatiasParseException e) {
            return null;
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void endDocument() throws SAXException {
    }

    @Override
    public void endElement(String uri, String localName, String name) throws SAXException {
        if (this.inHeadDepth > 0) {
            --this.inHeadDepth;
            if (this.inHeadDepth == 0) {
                this.inHeadDepth = -2;
            }
        }
        if (this.inCruftDepth > 0) {
            --this.inCruftDepth;
        }
        this.pop();
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void startDocument() throws SAXException {
        this.inHeadDepth = -1;
        this.inCruftDepth = 0;
    }

    @Override
    public void startElement(String uri, String localName, String n, Attributes atts) throws SAXException {
        if (this.inHeadDepth >= 1) {
            ++this.inHeadDepth;
            if ("http://www.w3.org/1999/xhtml" == uri) {
                String httpEquiv;
                if ("base" == localName) {
                    String href = atts.getValue("", "href");
                    if (href != null) {
                        this.installBase(href);
                    }
                } else if ("meta" == localName && this.equalsIgnoreAsciiCase("content-language", httpEquiv = atts.getValue("", "http-equiv"))) {
                    String content = atts.getValue("", "content");
                    if (content == null) {
                        content = "";
                    }
                    this.installContentLanguage(content);
                }
            }
        } else if (this.inHeadDepth == -1) {
            this.inHeadDepth = "html" == localName && "http://www.w3.org/1999/xhtml" == uri ? 0 : -2;
        } else if (this.inHeadDepth == 0 && this.inCruftDepth == 0) {
            if ("head" == localName && "http://www.w3.org/1999/xhtml" == uri) {
                this.inHeadDepth = 1;
            } else {
                this.inCruftDepth = 1;
            }
        }
        String base = null;
        String lang = null;
        Direction dir = Direction.INHERIT;
        int len = atts.getLength();
        for (int i = 0; i < len; ++i) {
            String name;
            String ns = atts.getURI(i);
            if ("http://www.w3.org/XML/1998/namespace" == ns) {
                name = atts.getLocalName(i);
                if ("lang" == name) {
                    lang = atts.getValue(i);
                    continue;
                }
                if ("base" != name) continue;
                base = atts.getValue(i);
                continue;
            }
            if ("" != ns || ("dir" != (name = atts.getLocalName(i)) || "http://www.w3.org/1999/xhtml" != uri) && ("direction" != name || "http://www.w3.org/2000/svg" != uri)) continue;
            String value = atts.getValue(i);
            if (this.equalsIgnoreAsciiCase("ltr", value)) {
                dir = Direction.LTR;
                continue;
            }
            if (!this.equalsIgnoreAsciiCase("rtl", value)) continue;
            dir = Direction.RTL;
        }
        this.push(base, lang, dir);
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    private class Node {
        public URL currentAbsolute;
        public String originalRelative;
        public String lang;
        private boolean langSpeficied;
        private boolean rtl;

        public Node(URL currentAbsolute, String originalRelative, String lang, boolean langSpecified, boolean rtl) {
            this.currentAbsolute = currentAbsolute;
            this.originalRelative = originalRelative;
            this.lang = lang;
            this.langSpeficied = langSpecified;
            this.rtl = rtl;
        }
    }

    private static enum Direction {
        LTR,
        RTL,
        INHERIT;

    }
}

