/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.properties;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.table.properties.GuiElements;
import ro.sync.ecss.extensions.commons.table.properties.PropertySelectionController;
import ro.sync.ecss.extensions.commons.table.properties.TableProperty;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class ECPropertyComposite {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)ECPropertyComposite.class.getName());
    private ComboViewer propertyValuesCombo = null;
    List<Button> radioButtons = null;
    private TableProperty tableProperty;
    private String currentlySelectedValue;
    private PropertySelectionController controller;

    public ECPropertyComposite(Composite parent, TableProperty tableProperty, AuthorResourceBundle authorResourceBundle, PropertySelectionController controller, boolean firstChild) {
        this.tableProperty = tableProperty;
        this.controller = controller;
        this.currentlySelectedValue = tableProperty.getCurrentValue();
        String propertyName = tableProperty.getAttributeName();
        String propertyRenderString = tableProperty.getAttributeRenderString();
        List<String> values = tableProperty.getValues();
        Object propertyLabelName = propertyRenderString != null ? authorResourceBundle.getMessage(propertyRenderString) : propertyName;
        GuiElements guiElement = tableProperty.getGuiType();
        if (GuiElements.COMBOBOX == guiElement) {
            propertyLabelName = (String)propertyLabelName + ":";
            Label label = new Label(parent, 16384);
            label.setText((String)propertyLabelName);
            this.propertyValuesCombo = new ComboViewer(parent);
            this.propertyValuesCombo.setContentProvider((IContentProvider)new IStructuredContentProvider(){

                public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
                }

                public void dispose() {
                }

                public Object[] getElements(Object inputElement) {
                    return (Object[])inputElement;
                }
            });
            this.propertyValuesCombo.setLabelProvider((IBaseLabelProvider)new FontLabelProvider());
            this.propertyValuesCombo.setInput((Object)values.toArray(new String[0]));
            GridData gd = new GridData(4, 0, true, false);
            gd.grabExcessHorizontalSpace = true;
            this.propertyValuesCombo.getCombo().setLayoutData((Object)gd);
            this.propertyValuesCombo.getCombo().addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    ECPropertyComposite.this.comboSelectionChanged();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    ECPropertyComposite.this.comboSelectionChanged();
                }
            });
            if (tableProperty.getCurrentValue() != null) {
                int index = values.indexOf(tableProperty.getCurrentValue());
                this.propertyValuesCombo.getCombo().select(index);
                this.comboSelectionChanged();
            }
            this.propertyValuesCombo.getCombo().setEnabled(this.tableProperty.isActive());
        } else if (GuiElements.RADIO_BUTTONS == guiElement) {
            this.radioButtons = new ArrayList<Button>();
            for (int i = 0; i < values.size(); ++i) {
                final Button button = new Button(parent, 16400);
                String currentValue = values.get(i);
                button.setText(currentValue);
                if ("<not set>".equals(currentValue) || "<preserve>".equals(currentValue)) {
                    FontData fd = button.getFont().getFontData()[0];
                    fd.setStyle(2);
                    final Font italicFont = new Font((Device)parent.getDisplay(), fd);
                    button.setFont(italicFont);
                    button.addDisposeListener(new DisposeListener(){

                        public void widgetDisposed(DisposeEvent e) {
                            italicFont.dispose();
                        }
                    });
                }
                button.addSelectionListener(new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        ECPropertyComposite.this.radioSelectionChanged(button);
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                        ECPropertyComposite.this.radioSelectionChanged(button);
                    }
                });
                if (this.tableProperty.getCurrentValue() != null && currentValue.equals(this.tableProperty.getCurrentValue())) {
                    button.setSelection(true);
                    this.radioSelectionChanged(button);
                } else {
                    button.setSelection(false);
                }
                button.setEnabled(this.tableProperty.isActive());
                this.radioButtons.add(button);
            }
        }
    }

    public TableProperty getModifiedProperty() {
        TableProperty modifiedProperty = null;
        String currentSelectedValue = this.tableProperty.getCurrentValue();
        if (this.tableProperty.getGuiType() == GuiElements.COMBOBOX) {
            int selIndex = this.propertyValuesCombo.getCombo().getSelectionIndex();
            currentSelectedValue = this.propertyValuesCombo.getCombo().getItem(selIndex);
        } else if (this.tableProperty.getGuiType() == GuiElements.RADIO_BUTTONS) {
            for (int i = 0; i < this.radioButtons.size(); ++i) {
                Button radioButton = this.radioButtons.get(i);
                boolean isSelected = radioButton.getSelection();
                if (!isSelected) continue;
                currentSelectedValue = radioButton.getText();
                break;
            }
        }
        if (this.tableProperty.getCurrentValue() == null || this.tableProperty.getCurrentValue() != null && !this.tableProperty.getCurrentValue().equals(currentSelectedValue)) {
            modifiedProperty = new TableProperty(this.tableProperty.getAttributeName(), this.tableProperty.getAttributeRenderString(), this.tableProperty.getValues(), currentSelectedValue, this.tableProperty.isAttribute());
            modifiedProperty.setOldValue(this.tableProperty.getCurrentValue());
        }
        return modifiedProperty;
    }

    public TableProperty getTableProperty() {
        return this.tableProperty;
    }

    public String getCurrentlySelectedValue() {
        return this.currentlySelectedValue;
    }

    private void comboSelectionChanged() {
        this.currentlySelectedValue = this.propertyValuesCombo.getCombo().getItem(this.propertyValuesCombo.getCombo().getSelectionIndex());
        if (this.currentlySelectedValue != null) {
            try {
                this.controller.selectionChanged(this.tableProperty, this.currentlySelectedValue);
            }
            catch (AuthorOperationException e) {
                LOGGER.debug(e.getMessage(), (Throwable)e);
            }
        }
    }

    private void radioSelectionChanged(Button currentRadioButton) {
        this.currentlySelectedValue = currentRadioButton.getText();
        try {
            this.controller.selectionChanged(this.tableProperty, this.currentlySelectedValue);
        }
        catch (AuthorOperationException e1) {
            LOGGER.debug(e1.getMessage(), (Throwable)e1);
        }
    }

    private class FontLabelProvider
    extends LabelProvider
    implements IFontProvider {
        private Font italicFont = null;
        private Font normalFont = null;

        public FontLabelProvider() {
            FontData fd = ECPropertyComposite.this.propertyValuesCombo.getControl().getFont().getFontData()[0];
            fd.setStyle(2);
            this.italicFont = new Font((Device)Display.getDefault(), fd);
            fd.setStyle(0);
            this.normalFont = new Font((Device)Display.getDefault(), fd);
        }

        public Font getFont(Object element) {
            if ("<preserve>".equals(this.getText(element)) || "<not set>".equals(this.getText(element))) {
                return this.italicFont;
            }
            return this.normalFont;
        }

        public void dispose() {
            this.italicFont.dispose();
            this.normalFont.dispose();
            super.dispose();
        }
    }
}

