/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.io.Serializable;
import java.util.Map;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.basic.util.TypedMaps;
import ro.sync.ecss.extensions.commons.table.operations.TableCustomizerConstants;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public class TableInfo
implements Serializable {
    private static final long serialVersionUID = 616939850L;
    private final String title;
    private final int rowsNumber;
    private final int columnsNumber;
    private final boolean generateHeader;
    private final boolean generateFooter;
    private final String frame;
    private final String rowsep;
    private final String colsep;
    private final String align;
    private final int tableModel;
    public static final int TABLE_MODEL_NONE = -1;
    public static final int TABLE_MODEL_HTML = 0;
    public static final int TABLE_MODEL_CALS = 1;
    public static final int TABLE_MODEL_CUSTOM = 2;
    public static final int TABLE_MODEL_DITA_SIMPLE = 3;
    public static final int TABLE_MODEL_DITA_CHOICE = 4;
    public static final int TABLE_MODEL_DITA_PROPERTIES = 5;
    private final TableCustomizerConstants.ColumnWidthsType columnsWidthsType;
    public static final int MIN_ROWS_COUNT = 1;
    public static final int DEFAULT_ROWS_COUNT = 3;
    public static final int DEFAULT_COLUMNS_COUNT_CHOICE_TABLE = 2;
    public static final int DEFAULT_COLUMNS_COUNT = 2;
    public static final int DEFAULT_COLUMNS_COUNT_PROPERTIES_TABLE = 3;
    public static final int MIN_COLUMNS_COUNT = 1;
    public static final int MIN_COLUMNS_COUNT_PROPERTIES_TABLE = 2;
    public static final int MAX_COLUMNS_COUNT = 100;
    public static final int MAX_COLUMNS_COUNT_PROPERTIES_TABLE = 3;

    public TableInfo(String title, int rowsNumber, int columnsNumber, boolean generateHeader, boolean generateFooter, String frame, int tableModel) {
        this(title, rowsNumber, columnsNumber, generateHeader, generateFooter, frame, tableModel, null, null, null, null);
    }

    public TableInfo(String title, int rowsNumber, int columnsNumber, boolean generateHeader, boolean generateFooter, String frame, int tableModel, TableCustomizerConstants.ColumnWidthsType columnsWidthsType, String rowsep, String colsep, String align) {
        this.title = title;
        this.rowsNumber = rowsNumber;
        this.columnsNumber = columnsNumber;
        this.generateHeader = generateHeader;
        this.generateFooter = generateFooter;
        this.frame = frame;
        this.tableModel = tableModel;
        this.columnsWidthsType = columnsWidthsType;
        this.rowsep = rowsep;
        this.colsep = colsep;
        this.align = align;
    }

    public TableInfo(Map<String, Object> fieldValues, int rows) {
        this.title = TypedMaps.getString(fieldValues, (Object)"title", (String)"");
        this.rowsNumber = rows > 0 ? rows : TypedMaps.getInt(fieldValues, (Object)"rowsNumber", (int)3);
        this.columnsNumber = TypedMaps.getInt(fieldValues, (Object)"columnsNumber", (int)2);
        this.generateHeader = TypedMaps.getBoolean(fieldValues, (Object)"generateHeader", (boolean)true);
        this.generateFooter = TypedMaps.getBoolean(fieldValues, (Object)"generateFooter", (boolean)false);
        this.frame = TypedMaps.getString(fieldValues, (Object)"frame", null);
        this.tableModel = TypedMaps.getInt(fieldValues, (Object)"tableModel", (int)2);
        this.columnsWidthsType = TableCustomizerConstants.ColumnWidthsType.valueOf(TypedMaps.getString(fieldValues, (Object)"columnsWidthsType", null));
        this.rowsep = TypedMaps.getString(fieldValues, (Object)"rowsep", null);
        this.colsep = TypedMaps.getString(fieldValues, (Object)"colsep", null);
        this.align = TypedMaps.getString(fieldValues, (Object)"align", null);
    }

    @Deprecated
    public TableInfo(Map<String, Object> fieldValues) {
        this(fieldValues, 0);
    }

    public String getTitle() {
        return this.title;
    }

    public int getRowsNumber() {
        return this.rowsNumber;
    }

    public int getColumnsNumber() {
        return this.columnsNumber;
    }

    public boolean isGenerateHeader() {
        return this.generateHeader;
    }

    public boolean isGenerateFooter() {
        return this.generateFooter;
    }

    public String getFrame() {
        return this.frame;
    }

    public String getRowsep() {
        return this.rowsep;
    }

    public String getColsep() {
        return this.colsep;
    }

    public String getAlign() {
        return this.align;
    }

    public int getTableModel() {
        return this.tableModel;
    }

    public TableCustomizerConstants.ColumnWidthsType getColumnsWidthsType() {
        return this.columnsWidthsType;
    }

    public String toString() {
        return "title: " + this.title + ", rows: " + this.rowsNumber + ", cols: " + this.columnsNumber + ", generateHeader: " + this.generateHeader + ", generateFooter: " + this.generateFooter + ", frame" + this.frame + ", rowsep: " + this.rowsep + ", colsep: " + this.colsep + ", align: " + this.align + ", tableModel: " + this.tableModel;
    }
}

