/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.table.operations;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorResourceBundle;
import ro.sync.ecss.extensions.commons.table.operations.ListContentProvider;
import ro.sync.ecss.extensions.commons.table.operations.TableCustomizerConstants;
import ro.sync.ecss.extensions.commons.table.operations.TableInfo;
import ro.sync.ecss.extensions.commons.ui.EclipseHelpUtils;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class ECTableCustomizerDialog
extends TrayDialog
implements TableCustomizerConstants {
    private static final String HELP_PAGE_ID = "adding-tables-author";
    private String title;
    private boolean createTitle;
    private int rows;
    private int columns;
    private boolean createHeader;
    private boolean createFooter;
    private boolean makeCalsTable;
    private boolean makePropertiesTable = false;
    private boolean makeSimpleOrHtmlTable = false;
    private String selectedFrame;
    private String selectedRowsep;
    private String selectedColsep;
    private String selectedAlign;
    private final boolean hasFooter;
    private final boolean hasFrameAttribute;
    private final boolean showModelChooser;
    private Text titleTextField;
    private ComboViewer colWidthsCombobox;
    private ComboViewer framesCombo;
    private ComboViewer rowsepCombo;
    private ComboViewer colsepCombo;
    private ComboViewer alignCombo;
    private final boolean simpleTableModel;
    private Button titleCheckbox;
    protected TableCustomizerConstants.ColumnWidthsType selectedColWidthsType;
    private Button calsModelRadio;
    private Button simpleOrHtmlModelRadio;
    private Button propertiesModelRadio;
    private Spinner rowsSpinner;
    private Spinner columnsSpinner;
    private Button headerCheckbox;
    private Button footerCheckbox;
    private TableInfo tableInfo;
    private final boolean innerCalsTable;
    protected final AuthorResourceBundle authorResourceBundle;
    private final int predefinedRowsCount;
    private final int predefinedColumnsCount;
    private final boolean showChoiceTable;
    private boolean hasRowSep;
    private boolean hasColsep;
    private boolean hasAlign;
    private boolean isCalsTable;
    private boolean isPropertiesTableAccepted;
    private boolean isPropertiesTableModel;
    private boolean isSimpleOrHtmlTable;

    public ECTableCustomizerDialog(AuthorAccess authorAccess, Shell parentShell, boolean hasFooter, boolean hasFrameAttribute, boolean showModelChooser, AuthorResourceBundle authorResourceBundle, int predefinedRowsCount, int predefinedColumnsCount) {
        this(authorAccess, parentShell, hasFooter, hasFrameAttribute, showModelChooser, false, false, false, false, false, authorResourceBundle, predefinedRowsCount, predefinedColumnsCount);
    }

    public ECTableCustomizerDialog(AuthorAccess authorAccess, Shell parentShell, boolean hasFooter, boolean hasFrameAttribute, boolean showModelChooser, boolean showSimpleModelRadio, boolean innerCalsTable, boolean hasRowsep, boolean hasColsep, boolean hasAlign, AuthorResourceBundle authorResourceBundle, int predefinedRowsCount, int predefinedColumnsCount) {
        this(authorAccess, parentShell, hasFooter, hasFrameAttribute, showModelChooser, showSimpleModelRadio, false, innerCalsTable, hasRowsep, hasColsep, hasAlign, authorResourceBundle, predefinedRowsCount, predefinedColumnsCount);
    }

    public ECTableCustomizerDialog(AuthorAccess authorAccess, Shell parentShell, boolean hasFooter, boolean hasFrameAttribute, boolean showModelChooser, boolean showSimpleModelRadio, boolean showChoiceTableDialog, boolean innerCalsTable, boolean hasRowsep, boolean hasColsep, boolean hasAlign, AuthorResourceBundle authorResourceBundle, int predefinedRowsCount, int predefinedColumnsCount) {
        this(authorAccess, parentShell, hasFooter, hasFrameAttribute, showModelChooser, showSimpleModelRadio, showChoiceTableDialog, true, innerCalsTable, hasRowsep, hasColsep, hasAlign, authorResourceBundle, predefinedRowsCount, predefinedColumnsCount);
    }

    public ECTableCustomizerDialog(AuthorAccess authorAccess, Shell parentShell, boolean hasFooter, boolean hasFrameAttribute, boolean showModelChooser, boolean showSimpleModelRadio, boolean showChoiceTableDialog, boolean isCalsTable, boolean innerCalsTable, boolean hasRowsep, boolean hasColsep, boolean hasAlign, AuthorResourceBundle authorResourceBundle, int predefinedRowsCount, int predefinedColumnsCount) {
        this(authorAccess, parentShell, hasFooter, hasFrameAttribute, showModelChooser, showSimpleModelRadio, showChoiceTableDialog, isCalsTable, innerCalsTable, false, false, false, hasRowsep, hasColsep, hasAlign, authorResourceBundle, predefinedRowsCount, predefinedColumnsCount);
    }

    public ECTableCustomizerDialog(AuthorAccess authorAccess, Shell parentShell, boolean hasFooter, boolean hasFrameAttribute, boolean showModelChooser, boolean showSimpleModelRadio, boolean showChoiceTableDialog, boolean isCalsTable, boolean isSimpleOrHtmlTable, boolean innerCalsTable, boolean isPropertiesTableAccepted, boolean isPropertiesTableModel, boolean hasRowsep, boolean hasColsep, boolean hasAlign, AuthorResourceBundle authorResourceBundle, int predefinedRowsCount, int predefinedColumnsCount) {
        super(parentShell);
        this.hasFooter = hasFooter;
        this.hasFrameAttribute = hasFrameAttribute;
        this.showModelChooser = showModelChooser;
        this.simpleTableModel = showSimpleModelRadio;
        this.showChoiceTable = showChoiceTableDialog;
        this.isCalsTable = isCalsTable;
        this.isSimpleOrHtmlTable = isSimpleOrHtmlTable;
        this.innerCalsTable = innerCalsTable;
        this.isPropertiesTableAccepted = isPropertiesTableAccepted;
        this.isPropertiesTableModel = isPropertiesTableModel;
        this.authorResourceBundle = authorResourceBundle;
        this.predefinedRowsCount = predefinedRowsCount;
        this.predefinedColumnsCount = predefinedColumnsCount;
        this.hasRowSep = hasRowsep;
        this.hasColsep = hasColsep;
        this.hasAlign = hasAlign;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        EclipseHelpUtils.installHelp(newShell, HELP_PAGE_ID);
        newShell.setText(this.authorResourceBundle.getMessage(this.showChoiceTable ? "Insert_choice_table" : "Insert_table"));
    }

    protected Control createDialogArea(Composite parent) {
        List<TableCustomizerConstants.ColumnWidthsType> columnsWidths;
        GridData data;
        int tableModel;
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        if (this.showModelChooser) {
            tableModel = 1;
            Group modelChooser = new Group(composite, 4);
            modelChooser.setText(this.authorResourceBundle.getMessage("Model"));
            modelChooser.setLayout((Layout)new GridLayout(3, true));
            GridData data2 = new GridData(4, 0, true, false);
            data2.horizontalSpan = 2;
            modelChooser.setLayoutData((Object)data2);
            this.calsModelRadio = new Button((Composite)modelChooser, 16400);
            this.calsModelRadio.setText("CALS");
            this.calsModelRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ECTableCustomizerDialog.this.makeCalsTable = ECTableCustomizerDialog.this.calsModelRadio.getSelection();
                    ECTableCustomizerDialog.this.makeSimpleOrHtmlTable = ECTableCustomizerDialog.this.simpleOrHtmlModelRadio.getSelection();
                    if (ECTableCustomizerDialog.this.propertiesModelRadio != null) {
                        ECTableCustomizerDialog.this.makePropertiesTable = ECTableCustomizerDialog.this.propertiesModelRadio.getSelection();
                    }
                    ECTableCustomizerDialog.this.tableModelChanged(1);
                    ECTableCustomizerDialog.this.columnsSpinner.setMinimum(1);
                    ECTableCustomizerDialog.this.columnsSpinner.setMaximum(100);
                }
            });
            if (!this.showChoiceTable) {
                this.simpleOrHtmlModelRadio = new Button((Composite)modelChooser, 16400);
                if (!this.isPropertiesTableAccepted) {
                    GridData gridData = new GridData();
                    gridData.horizontalSpan = 2;
                    this.simpleOrHtmlModelRadio.setLayoutData((Object)gridData);
                }
                if (this.simpleTableModel) {
                    this.simpleOrHtmlModelRadio.setText(this.authorResourceBundle.getMessage("Simple"));
                    this.simpleOrHtmlModelRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ECTableCustomizerDialog.this.makeCalsTable = ECTableCustomizerDialog.this.calsModelRadio.getSelection();
                            ECTableCustomizerDialog.this.makeSimpleOrHtmlTable = ECTableCustomizerDialog.this.simpleOrHtmlModelRadio.getSelection();
                            if (ECTableCustomizerDialog.this.propertiesModelRadio != null) {
                                ECTableCustomizerDialog.this.makePropertiesTable = ECTableCustomizerDialog.this.propertiesModelRadio.getSelection();
                            }
                            ECTableCustomizerDialog.this.tableModelChanged(3);
                            ECTableCustomizerDialog.this.columnsSpinner.setMinimum(1);
                            ECTableCustomizerDialog.this.columnsSpinner.setMaximum(100);
                        }
                    });
                    this.updateRadioButtonsSelection();
                    tableModel = this.makeCalsTable ? 1 : (this.makePropertiesTable ? 5 : 3);
                    this.tableModelChanged(tableModel);
                } else {
                    this.simpleOrHtmlModelRadio.setText("HTML");
                    this.simpleOrHtmlModelRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ECTableCustomizerDialog.this.makeCalsTable = ECTableCustomizerDialog.this.calsModelRadio.getSelection();
                            ECTableCustomizerDialog.this.makeSimpleOrHtmlTable = ECTableCustomizerDialog.this.simpleOrHtmlModelRadio.getSelection();
                            if (ECTableCustomizerDialog.this.propertiesModelRadio != null) {
                                ECTableCustomizerDialog.this.makePropertiesTable = ECTableCustomizerDialog.this.propertiesModelRadio.getSelection();
                            }
                            ECTableCustomizerDialog.this.tableModelChanged(0);
                            ECTableCustomizerDialog.this.columnsSpinner.setMinimum(1);
                            ECTableCustomizerDialog.this.columnsSpinner.setMaximum(100);
                        }
                    });
                    this.updateRadioButtonsSelection();
                    tableModel = this.makeCalsTable ? 1 : (this.makePropertiesTable ? 5 : 0);
                    this.tableModelChanged(tableModel);
                }
                if (this.isPropertiesTableAccepted) {
                    this.propertiesModelRadio = new Button((Composite)modelChooser, 16400);
                    this.propertiesModelRadio.setText(this.authorResourceBundle.getMessage("Properties"));
                    this.propertiesModelRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            ECTableCustomizerDialog.this.makeCalsTable = ECTableCustomizerDialog.this.calsModelRadio.getSelection();
                            ECTableCustomizerDialog.this.makeSimpleOrHtmlTable = ECTableCustomizerDialog.this.simpleOrHtmlModelRadio.getSelection();
                            if (ECTableCustomizerDialog.this.propertiesModelRadio != null) {
                                ECTableCustomizerDialog.this.makePropertiesTable = ECTableCustomizerDialog.this.propertiesModelRadio.getSelection();
                            }
                            ECTableCustomizerDialog.this.tableModelChanged(5);
                            ECTableCustomizerDialog.this.columnsSpinner.setMinimum(2);
                            ECTableCustomizerDialog.this.columnsSpinner.setMaximum(3);
                            if (ECTableCustomizerDialog.this.columns < 2 || ECTableCustomizerDialog.this.columns > 3) {
                                ECTableCustomizerDialog.this.columns = 3;
                            }
                            ECTableCustomizerDialog.this.columnsSpinner.setSelection(ECTableCustomizerDialog.this.columns);
                        }
                    });
                    this.updateRadioButtonsSelection();
                    tableModel = this.makeCalsTable ? 1 : (this.makePropertiesTable ? 5 : 3);
                    this.tableModelChanged(tableModel);
                }
            }
        } else {
            tableModel = 4;
        }
        if (!this.innerCalsTable && !this.showChoiceTable) {
            this.titleCheckbox = this.createTitleCheckbox(composite);
            this.titleCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ECTableCustomizerDialog.this.titleTextField.setEditable(ECTableCustomizerDialog.this.titleCheckbox.getSelection());
                    ECTableCustomizerDialog.this.createTitle = ECTableCustomizerDialog.this.titleCheckbox.getSelection();
                    if (ECTableCustomizerDialog.this.titleCheckbox.getSelection()) {
                        ECTableCustomizerDialog.this.titleTextField.setFocus();
                    }
                }
            });
            this.createTitle = true;
            this.titleCheckbox.setSelection(this.createTitle);
            this.titleTextField = new Text(composite, 2052);
            this.titleTextField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    ECTableCustomizerDialog.this.title = ECTableCustomizerDialog.this.titleTextField.getText();
                }
            });
            data = new GridData(4, 0, true, false);
            this.titleTextField.setLayoutData((Object)data);
        }
        this.title = "";
        data = new GridData(4, 0, true, false);
        Group sizeGroup = new Group(composite, 4);
        sizeGroup.setText(this.authorResourceBundle.getMessage("Table_size"));
        sizeGroup.setLayout((Layout)new GridLayout(4, false));
        data.horizontalSpan = 2;
        sizeGroup.setLayoutData((Object)data);
        Label label = new Label((Composite)sizeGroup, 16384);
        label.setText(this.authorResourceBundle.getMessage("Rows"));
        this.rowsSpinner = new Spinner((Composite)sizeGroup, 2048);
        this.rowsSpinner.setMinimum(1);
        this.rowsSpinner.setMaximum(1000);
        this.rowsSpinner.setSelection(3);
        this.rowsSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ECTableCustomizerDialog.this.rows = ECTableCustomizerDialog.this.rowsSpinner.getSelection();
            }
        });
        this.rowsSpinner.setLayoutData((Object)new GridData(4, 0, true, false));
        this.rows = 3;
        label = new Label((Composite)sizeGroup, 16384);
        label.setText(this.authorResourceBundle.getMessage("Columns"));
        this.columnsSpinner = new Spinner((Composite)sizeGroup, 2048);
        this.columnsSpinner.setMinimum(this.isPropertiesTableModel ? 2 : 1);
        this.columnsSpinner.setMaximum(this.isPropertiesTableModel ? 3 : 100);
        this.columnsSpinner.setSelection(this.isPropertiesTableModel ? 3 : 2);
        this.columnsSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ECTableCustomizerDialog.this.columns = ECTableCustomizerDialog.this.columnsSpinner.getSelection();
            }
        });
        this.columnsSpinner.setLayoutData((Object)new GridData(4, 0, true, false));
        int n = this.columns = this.isPropertiesTableModel ? 3 : 2;
        if (this.showChoiceTable) {
            this.columnsSpinner.setEnabled(false);
        }
        Composite headerAndFooterComposite = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        headerAndFooterComposite.setLayout((Layout)layout);
        data = new GridData(4, 4, true, true);
        data.horizontalSpan = 2;
        headerAndFooterComposite.setLayoutData((Object)data);
        this.headerCheckbox = new Button(headerAndFooterComposite, 16416);
        this.headerCheckbox.setText(this.authorResourceBundle.getMessage("Generate_table_header"));
        this.headerCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ECTableCustomizerDialog.this.createHeader = ECTableCustomizerDialog.this.headerCheckbox.getSelection();
            }
        });
        this.headerCheckbox.setSelection(true);
        this.createHeader = true;
        if (this.hasFooter) {
            this.footerCheckbox = new Button(headerAndFooterComposite, 16416);
            this.footerCheckbox.setText(this.authorResourceBundle.getMessage("Generate_table_footer"));
            this.footerCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ECTableCustomizerDialog.this.createFooter = ECTableCustomizerDialog.this.footerCheckbox.getSelection();
                }
            });
            this.footerCheckbox.setSelection(false);
            this.createFooter = false;
        }
        if ((columnsWidths = this.getColumnWidthsSpecifications(tableModel)) != null) {
            Label colsLabel = new Label(composite, 16384);
            colsLabel.setText(this.authorResourceBundle.getMessage("Column_widths") + ": ");
            this.colWidthsCombobox = new ComboViewer(composite, 12);
            this.colWidthsCombobox.getCombo().setLayoutData((Object)new GridData(4, 0, true, false));
            LabelProvider labelProvider = new LabelProvider(){

                public String getText(Object element) {
                    String render = String.valueOf(element);
                    if (element instanceof TableCustomizerConstants.ColumnWidthsType) {
                        if (TableCustomizerConstants.ColumnWidthsType.DYNAMIC_COL_WIDTHS == element) {
                            render = "dynamic";
                        } else if (TableCustomizerConstants.ColumnWidthsType.PROPORTIONAL_COL_WIDTHS == element) {
                            render = "proportional";
                        } else if (TableCustomizerConstants.ColumnWidthsType.FIXED_COL_WIDTHS == element) {
                            render = "fixed";
                        }
                    }
                    return render;
                }
            };
            this.colWidthsCombobox.setLabelProvider((IBaseLabelProvider)labelProvider);
            this.colWidthsCombobox.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ECTableCustomizerDialog.this.selectedColWidthsType = (TableCustomizerConstants.ColumnWidthsType)((Object)((StructuredSelection)event.getSelection()).getFirstElement());
                }
            });
            this.colWidthsCombobox.setContentProvider((IContentProvider)new ListContentProvider());
            this.setColWidthsComboInput(columnsWidths);
        }
        if (this.hasFrameAttribute) {
            Label frameLabel = new Label(composite, 16384);
            frameLabel.setText(this.authorResourceBundle.getMessage("Frame") + ": ");
            this.framesCombo = new ComboViewer(composite, 12);
            this.framesCombo.getCombo().setLayoutData((Object)new GridData(4, 0, true, false));
            this.framesCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ECTableCustomizerDialog.this.selectedFrame = (String)((StructuredSelection)event.getSelection()).getFirstElement();
                }
            });
            this.framesCombo.setContentProvider((IContentProvider)new ListContentProvider());
            this.setFrameComboInput(this.getFrameValues(this.getTableModel()));
        }
        if (this.hasRowSep) {
            Label rowsepLabel = new Label(composite, 16384);
            rowsepLabel.setText(this.authorResourceBundle.getMessage("Row_separator") + ": ");
            this.rowsepCombo = new ComboViewer(composite, 12);
            this.rowsepCombo.getCombo().setLayoutData((Object)new GridData(4, 0, true, false));
            this.rowsepCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ECTableCustomizerDialog.this.selectedRowsep = (String)((StructuredSelection)event.getSelection()).getFirstElement();
                }
            });
            this.rowsepCombo.setContentProvider((IContentProvider)new ListContentProvider());
            this.setRowsepComboInput(this.getRowsepValues(this.getTableModel()));
        }
        if (this.hasColsep) {
            Label colsepLabel = new Label(composite, 16384);
            colsepLabel.setText(this.authorResourceBundle.getMessage("Column_separator") + ": ");
            this.colsepCombo = new ComboViewer(composite, 12);
            this.colsepCombo.getCombo().setLayoutData((Object)new GridData(4, 0, true, false));
            this.colsepCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ECTableCustomizerDialog.this.selectedColsep = (String)((StructuredSelection)event.getSelection()).getFirstElement();
                }
            });
            this.colsepCombo.setContentProvider((IContentProvider)new ListContentProvider());
            this.setColsepComboInput(this.getColsepValues(this.getTableModel()));
        }
        if (this.hasAlign) {
            Label alignLabel = new Label(composite, 16384);
            alignLabel.setText(this.authorResourceBundle.getMessage("Alignment") + ": ");
            this.alignCombo = new ComboViewer(composite, 12);
            this.alignCombo.getCombo().setLayoutData((Object)new GridData(4, 0, true, false));
            this.alignCombo.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    ECTableCustomizerDialog.this.selectedAlign = (String)((StructuredSelection)event.getSelection()).getFirstElement();
                }
            });
            this.alignCombo.setContentProvider((IContentProvider)new ListContentProvider());
            this.setAlignComboInput(this.getAlignValues(this.getTableModel()));
        }
        this.initialize();
        return composite;
    }

    private void updateRadioButtonsSelection() {
        this.makeCalsTable = this.isCalsTable && this.innerCalsTable || !this.isCalsTable && !this.isSimpleOrHtmlTable && !this.isPropertiesTableModel;
        this.calsModelRadio.setSelection(this.makeCalsTable);
        this.simpleOrHtmlModelRadio.setSelection(this.isSimpleOrHtmlTable);
        if (this.propertiesModelRadio != null) {
            this.propertiesModelRadio.setSelection(this.isPropertiesTableModel);
        }
    }

    private void setFrameComboInput(String[] frames) {
        if (this.framesCombo != null) {
            Object lastSelected = null;
            if (!this.framesCombo.getSelection().isEmpty()) {
                lastSelected = ((IStructuredSelection)this.framesCombo.getSelection()).getFirstElement();
            }
            List<String> framesList = Arrays.asList(frames);
            this.framesCombo.setInput(framesList);
            int indexOfSel = framesList.indexOf(lastSelected);
            if (indexOfSel != -1) {
                this.framesCombo.setSelection((ISelection)new StructuredSelection((Object)framesList.get(indexOfSel)), true);
            } else {
                this.framesCombo.setSelection((ISelection)new StructuredSelection((Object)this.getDefaultFrameValue(this.getTableModel())), true);
            }
        }
    }

    private void setRowsepComboInput(String[] values) {
        if (this.rowsepCombo != null) {
            this.rowsepCombo.setInput(Arrays.asList(values));
            this.rowsepCombo.setSelection((ISelection)new StructuredSelection((Object)this.getDefaultRowsepValue(this.getTableModel())), true);
        }
    }

    private void setColsepComboInput(String[] values) {
        if (this.colsepCombo != null) {
            this.colsepCombo.setInput(Arrays.asList(values));
            this.colsepCombo.setSelection((ISelection)new StructuredSelection((Object)this.getDefaultColsepValue(this.getTableModel())), true);
        }
    }

    private void setAlignComboInput(String[] values) {
        if (this.alignCombo != null) {
            this.alignCombo.setInput(Arrays.asList(values));
            this.alignCombo.setSelection((ISelection)new StructuredSelection((Object)this.getDefaultAlignValue(this.getTableModel())), true);
        }
    }

    private void setColWidthsComboInput(List<TableCustomizerConstants.ColumnWidthsType> columnsWidths) {
        Object lastSelected = null;
        if (this.colWidthsCombobox != null && columnsWidths != null) {
            if (!this.colWidthsCombobox.getSelection().isEmpty()) {
                lastSelected = ((IStructuredSelection)this.colWidthsCombobox.getSelection()).getFirstElement();
            }
            this.colWidthsCombobox.setInput(columnsWidths);
            int indexOfSel = columnsWidths.indexOf(lastSelected);
            if (indexOfSel == -1) {
                indexOfSel = 0;
            }
            if (indexOfSel != -1) {
                this.colWidthsCombobox.setSelection((ISelection)new StructuredSelection((Object)columnsWidths.get(indexOfSel)), true);
            }
        }
    }

    protected abstract String[] getFrameValues(int var1);

    protected abstract String[] getRowsepValues(int var1);

    protected abstract String[] getColsepValues(int var1);

    protected abstract String[] getAlignValues(int var1);

    protected abstract String getDefaultFrameValue(int var1);

    protected abstract String getDefaultRowsepValue(int var1);

    protected abstract String getDefaultColsepValue(int var1);

    protected abstract String getDefaultAlignValue(int var1);

    protected abstract List<TableCustomizerConstants.ColumnWidthsType> getColumnWidthsSpecifications(int var1);

    protected abstract Button createTitleCheckbox(Composite var1);

    public TableInfo showDialog(TableInfo tableInfo) {
        this.tableInfo = tableInfo;
        if (0 == this.open()) {
            int rowsNumber = this.rows;
            int columnsNumber = this.columns;
            int tableModel = this.getTableModel();
            return new TableInfo(this.createTitle ? this.title : null, rowsNumber, columnsNumber, this.createHeader, this.hasFooter && this.createFooter, this.hasFrameAttribute && !"<unspecified>".equals(this.selectedFrame) ? this.selectedFrame : null, tableModel, this.selectedColWidthsType, this.hasRowSep && !"<unspecified>".equals(this.selectedRowsep) ? this.selectedRowsep : null, this.hasColsep && !"<unspecified>".equals(this.selectedColsep) ? this.selectedColsep : null, this.hasAlign && !"<unspecified>".equals(this.selectedAlign) ? this.selectedAlign : null);
        }
        return null;
    }

    private void initialize() {
        if (this.titleTextField != null) {
            this.titleTextField.setEditable(true);
            this.title = "";
            this.titleTextField.setText(this.title);
        }
        if (this.showChoiceTable) {
            this.tableModelChanged(4);
        }
        if (this.tableInfo != null) {
            if (this.showModelChooser) {
                if (this.isCalsTable || this.tableInfo.getTableModel() == 1 && !this.isPropertiesTableModel && !this.isSimpleOrHtmlTable) {
                    this.makeCalsTable = true;
                    this.makeSimpleOrHtmlTable = false;
                    this.makePropertiesTable = false;
                } else if (this.isSimpleOrHtmlTable || this.tableInfo.getTableModel() != 1 && this.tableInfo.getTableModel() != 5 && !this.isCalsTable && !this.isPropertiesTableModel) {
                    this.makeCalsTable = false;
                    this.makeSimpleOrHtmlTable = true;
                    this.makePropertiesTable = false;
                } else if (this.propertiesModelRadio != null && (this.isPropertiesTableModel || this.tableInfo.getTableModel() == 5 && !this.isCalsTable && !this.isSimpleOrHtmlTable)) {
                    this.makeCalsTable = false;
                    this.makeSimpleOrHtmlTable = false;
                    this.makePropertiesTable = true;
                } else {
                    this.makeCalsTable = true;
                    this.makeSimpleOrHtmlTable = false;
                    this.makePropertiesTable = false;
                }
                this.calsModelRadio.setSelection(this.makeCalsTable);
                this.simpleOrHtmlModelRadio.setSelection(this.makeSimpleOrHtmlTable);
                if (this.propertiesModelRadio != null) {
                    this.propertiesModelRadio.setSelection(this.makePropertiesTable);
                }
                int tableModel = this.makeCalsTable ? 1 : (this.makePropertiesTable ? 5 : (this.simpleTableModel ? 3 : 0));
                this.tableModelChanged(tableModel);
            }
            if (this.titleTextField != null) {
                if (this.tableInfo.getTitle() != null) {
                    this.createTitle = true;
                    this.titleCheckbox.setSelection(this.createTitle);
                    this.titleTextField.setFocus();
                } else {
                    this.createTitle = false;
                    this.titleCheckbox.setSelection(this.createTitle);
                }
            }
            if (this.predefinedRowsCount < 0 || this.predefinedColumnsCount < 0) {
                this.rows = this.tableInfo.getRowsNumber();
                this.rowsSpinner.setSelection(this.rows);
                if (!this.showChoiceTable) {
                    this.columns = this.tableInfo.getColumnsNumber();
                    if (this.makePropertiesTable) {
                        this.columnsSpinner.setMinimum(2);
                        this.columnsSpinner.setMaximum(3);
                        if (this.columns < 2 || this.columns > 3) {
                            this.columns = 3;
                        }
                    } else {
                        this.columnsSpinner.setMinimum(1);
                        this.columnsSpinner.setMaximum(100);
                    }
                    this.columnsSpinner.setSelection(this.columns);
                }
            } else {
                this.rowsSpinner.setSelection(this.predefinedRowsCount);
                this.columnsSpinner.setSelection(this.predefinedColumnsCount);
            }
            this.createHeader = this.tableInfo.isGenerateHeader();
            this.headerCheckbox.setSelection(this.createHeader);
            if (this.hasFooter) {
                this.createFooter = this.tableInfo.isGenerateFooter();
                this.footerCheckbox.setSelection(this.createFooter);
            }
            if (this.colWidthsCombobox != null && this.tableInfo.getColumnsWidthsType() != null) {
                this.colWidthsCombobox.setSelection((ISelection)new StructuredSelection((Object)this.tableInfo.getColumnsWidthsType()));
            }
            if (this.framesCombo != null) {
                if (this.tableInfo.getFrame() != null) {
                    this.selectedFrame = this.tableInfo.getFrame();
                    this.framesCombo.setSelection((ISelection)new StructuredSelection((Object)this.selectedFrame));
                } else {
                    this.selectedFrame = "<unspecified>";
                    this.framesCombo.setSelection((ISelection)new StructuredSelection((Object)this.selectedFrame));
                }
            }
            if (this.rowsepCombo != null) {
                if (this.tableInfo.getRowsep() != null) {
                    this.selectedRowsep = this.tableInfo.getRowsep();
                    this.rowsepCombo.setSelection((ISelection)new StructuredSelection((Object)this.selectedRowsep));
                } else {
                    this.selectedRowsep = "<unspecified>";
                    this.rowsepCombo.setSelection((ISelection)new StructuredSelection((Object)this.selectedRowsep));
                }
            }
            if (this.colsepCombo != null) {
                if (this.tableInfo.getColsep() != null) {
                    this.selectedColsep = this.tableInfo.getColsep();
                    this.colsepCombo.setSelection((ISelection)new StructuredSelection((Object)this.selectedColsep));
                } else {
                    this.selectedColsep = "<unspecified>";
                    this.colsepCombo.setSelection((ISelection)new StructuredSelection((Object)this.selectedColsep));
                }
            }
            if (this.alignCombo != null) {
                if (this.tableInfo.getAlign() != null) {
                    this.selectedAlign = this.tableInfo.getAlign();
                    this.alignCombo.setSelection((ISelection)new StructuredSelection((Object)this.selectedAlign));
                } else {
                    this.selectedAlign = "<unspecified>";
                    this.alignCombo.setSelection((ISelection)new StructuredSelection((Object)this.selectedAlign));
                }
            }
        } else {
            if (this.titleTextField != null) {
                this.titleCheckbox.setSelection(true);
                this.titleTextField.setFocus();
            }
            if (this.showModelChooser) {
                this.makeCalsTable = this.isCalsTable || !this.isSimpleOrHtmlTable && !this.isPropertiesTableModel;
                this.makeSimpleOrHtmlTable = this.isSimpleOrHtmlTable;
                this.makePropertiesTable = this.isPropertiesTableModel;
                this.calsModelRadio.setSelection(this.makeCalsTable);
                this.simpleOrHtmlModelRadio.setSelection(this.makeSimpleOrHtmlTable);
                if (this.propertiesModelRadio != null) {
                    this.propertiesModelRadio.setSelection(this.makePropertiesTable);
                }
                if (this.isPropertiesTableModel) {
                    this.tableModelChanged(5);
                } else if (this.simpleTableModel) {
                    this.tableModelChanged(this.makeCalsTable ? 1 : 3);
                } else {
                    this.tableModelChanged(this.makeCalsTable ? 1 : 0);
                }
            }
            if (this.predefinedRowsCount < 0 || this.predefinedColumnsCount < 0) {
                this.rows = 3;
                this.rowsSpinner.setSelection(this.rows);
                this.columns = this.isPropertiesTableModel ? 3 : 2;
                this.columnsSpinner.setSelection(this.columns);
            } else {
                this.rowsSpinner.setSelection(this.predefinedRowsCount);
                this.columnsSpinner.setSelection(this.predefinedColumnsCount);
            }
            this.createHeader = true;
            this.headerCheckbox.setSelection(this.createHeader);
            if (this.hasFooter) {
                this.createFooter = false;
                this.footerCheckbox.setSelection(this.createFooter);
            }
        }
        if (this.titleTextField != null) {
            this.titleTextField.setEditable(this.titleCheckbox.isEnabled() && this.titleCheckbox.getSelection());
        }
    }

    private int getTableModel() {
        int tableModelType = 2;
        if (this.showModelChooser) {
            tableModelType = this.makeCalsTable ? 1 : (this.makePropertiesTable ? 5 : (this.simpleTableModel ? 3 : 0));
        } else if (this.showChoiceTable) {
            tableModelType = 4;
        }
        return tableModelType;
    }

    private void updateTitleState(boolean enabled) {
        if (this.titleTextField != null) {
            this.titleCheckbox.setEnabled(enabled);
            this.titleCheckbox.setSelection(enabled);
            this.titleTextField.setEditable(enabled && this.titleCheckbox.getSelection());
        }
    }

    private void updateSeparatorsState(boolean enabled) {
        if (this.rowsepCombo != null) {
            this.rowsepCombo.getCombo().setEnabled(enabled);
        }
        if (this.colsepCombo != null) {
            this.colsepCombo.getCombo().setEnabled(enabled);
        }
    }

    private void updateAlignState(boolean enabled) {
        if (this.alignCombo != null) {
            this.alignCombo.getCombo().setEnabled(enabled);
        }
    }

    private void updateColWidthsCombo(boolean enabled) {
        if (this.colWidthsCombobox != null) {
            this.colWidthsCombobox.getCombo().setEnabled(enabled);
        }
    }

    private void tableModelChanged(int model) {
        this.updateColWidthsCombo(model != 5);
        if (this.colWidthsCombobox != null && this.colWidthsCombobox.getCombo().isEnabled()) {
            this.setColWidthsComboInput(this.getColumnWidthsSpecifications(model));
        }
        this.setFrameComboInput(this.getFrameValues(model));
        this.updateTitleState(model != 3 && model != 4 && model != 5);
        this.updateSeparatorsState(model == 1);
        this.updateAlignState(model == 1 || model == 0);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getButton(0).setText(this.authorResourceBundle.getMessage("Insert"));
    }

    protected String getHelpPageID() {
        return HELP_PAGE_ID;
    }
}

