/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.sort;

import java.util.List;
import java.util.TreeSet;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.ecss.extensions.commons.sort.SortOperation;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
public abstract class TableSortOperation
extends SortOperation {
    public TableSortOperation() {
        super("Selected_rows", "All_rows");
    }

    @Override
    public void canBeSorted(AuthorElement parent, int[] selectedNonIgnoredChildrenInterval) throws AuthorOperationException {
        List<AuthorNode> nonIgnoredChildren = this.getNonIgnoredChildren(parent);
        if (selectedNonIgnoredChildrenInterval == null || selectedNonIgnoredChildrenInterval[1] < 0) {
            selectedNonIgnoredChildrenInterval = new int[]{0, nonIgnoredChildren.size() - 1};
        }
        TreeSet<Integer> notSortableRows = new TreeSet<Integer>();
        for (int i = 0; i <= selectedNonIgnoredChildrenInterval[1]; ++i) {
            AuthorNode node = nonIgnoredChildren.get(i);
            if (node.getType() != 0) continue;
            List<AuthorNode> children = this.getNonIgnoredChildren((AuthorElement)node);
            int size = children.size();
            for (int k = 0; k < size; ++k) {
                int[] tableRowSpanIndices;
                AuthorNode child = children.get(k);
                if (child.getType() != 0 || (tableRowSpanIndices = this.authorAccess.getTableAccess().getTableRowSpanIndices((AuthorElement)child)) == null || tableRowSpanIndices[1] - tableRowSpanIndices[0] <= 0) continue;
                for (int j = tableRowSpanIndices[0]; j <= tableRowSpanIndices[1]; ++j) {
                    notSortableRows.add(j);
                }
            }
        }
        int tBodyRowIndex = this.getRowIndexForTableBody((AuthorNode)parent);
        for (int i = selectedNonIgnoredChildrenInterval[0]; i <= selectedNonIgnoredChildrenInterval[1] && i >= 0 && i < nonIgnoredChildren.size(); ++i) {
            if (!notSortableRows.contains(i + tBodyRowIndex)) continue;
            throw new AuthorOperationException("The 'Sort' operation is unavailable for tables with multiple rowspan cells.");
        }
    }

    protected abstract int getRowIndexForTableBody(AuthorNode var1);

    @Override
    protected String getHelpPageID() {
        return "sort-entire-table";
    }
}

