/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorDocumentType;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.AuthorSchemaManager;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.access.AuthorWorkspaceAccess;
import ro.sync.exml.workspace.api.Platform;
import ro.sync.exml.workspace.api.images.handlers.CannotEditException;
import ro.sync.exml.workspace.api.images.handlers.EditImageHandler;
import ro.sync.exml.workspace.api.images.handlers.ImageHandler;
import ro.sync.exml.workspace.api.images.handlers.providers.EmbeddedImageContentProvider;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible
public class InsertEquationOperation
implements AuthorOperation {
    private static final String ARGUMENT_FRAGMENT_WITH_MATHML = "fragment";
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[1];
    public static final String MATH_ML_NAMESPACE = "\"http://www.w3.org/1998/Math/MathML\"";
    public static final String MATH_ML = "<mml:math xmlns:mml=" + "\"http://www.w3.org/1998/Math/MathML\"" + ">" + "</mml:math>";
    public static final String MATH_ML_FOR_HTML_DOC_TYPE = "<math xmlns=" + "\"http://www.w3.org/1998/Math/MathML\"" + ">\n" + "</math>";
    public static final String WEBAPP_MATH_ML = "<m:math xmlns:m=" + "\"http://www.w3.org/1998/Math/MathML\"" + ">" + "<m:mrow>" + "<m:msup><m:mi>a</m:mi><m:mn>2</m:mn></m:msup>" + "<m:mo>=</m:mo>" + "<m:msup><m:mi>b</m:mi><m:mn>2</m:mn></m:msup>" + "<m:mo>+</m:mo>" + "<m:msup><m:mi>c</m:mi><m:mn>2</m:mn>" + "</m:msup></m:mrow>" + "</m:math>";

    public InsertEquationOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(ARGUMENT_FRAGMENT_WITH_MATHML, 1, "The fragment of XML containing the default MathML content which should be inserted");
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        try {
            boolean shouldInsert;
            AuthorWorkspaceAccess workspace = authorAccess.getWorkspaceAccess();
            ImageHandler imageHandler = null;
            if (workspace.getPlatform() == Platform.WEBAPP) {
                shouldInsert = true;
            } else {
                imageHandler = workspace.getImageUtilities().getImageHandlerFor("mathml");
                shouldInsert = imageHandler instanceof EditImageHandler;
            }
            if (shouldInsert) {
                String serializedDoctype = null;
                AuthorDocumentController controller = authorAccess.getDocumentController();
                AuthorDocumentType dt = controller.getDoctype();
                if (dt != null) {
                    serializedDoctype = dt.getContent();
                }
                AuthorSchemaManager asm = controller.getAuthorSchemaManager();
                String xmlFragment = this.createDefaultFragmentToEdit(authorAccess, asm);
                Object fragment = args.getArgumentValue(ARGUMENT_FRAGMENT_WITH_MATHML);
                if (fragment instanceof String && !((String)fragment).isEmpty()) {
                    xmlFragment = (String)fragment;
                }
                String detectedMathMLContent = InsertEquationOperation.extractMathMLFragment(xmlFragment);
                String mml = null;
                if (detectedMathMLContent != null) {
                    EmbeddedImageContentProvider cp = new EmbeddedImageContentProvider(authorAccess.getEditorAccess().getEditorLocation(), detectedMathMLContent, serializedDoctype);
                    mml = InsertEquationOperation.editImage(imageHandler, cp);
                }
                if (mml != null) {
                    xmlFragment = xmlFragment.replace(detectedMathMLContent, mml);
                }
                if (mml != null || detectedMathMLContent == null) {
                    int caretOffset = authorAccess.getEditorAccess().getCaretOffset();
                    authorAccess.getDocumentController().insertXMLFragmentSchemaAware(xmlFragment, caretOffset);
                }
            } else {
                workspace.showInformationMessage("MathML editing is not supported.");
            }
        }
        catch (CannotEditException e) {
            throw new AuthorOperationException(e.getMessage(), (Throwable)e);
        }
    }

    private static String editImage(ImageHandler handler, EmbeddedImageContentProvider cp) throws CannotEditException {
        if (handler instanceof EditImageHandler) {
            return ((EditImageHandler)handler).editImage(cp);
        }
        String webappContent = WEBAPP_MATH_ML;
        String imageSerializedContent = cp.getImageSerializedContent();
        if (imageSerializedContent.contains("mml:")) {
            webappContent = webappContent.replace("<m:", "<mml:");
            webappContent = webappContent.replace("</m:", "</mml:");
            webappContent = webappContent.replace("xmlns:m", "xmlns:mml");
        }
        return webappContent;
    }

    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    public String getDescription() {
        return "Insert a MathML equation.";
    }

    protected String createDefaultFragmentToEdit(AuthorAccess authorAccess, AuthorSchemaManager asm) {
        return MATH_ML;
    }

    private static String extractMathMLFragment(String xmlFragment) {
        String stringBeforeNamespace;
        int lastIndexOfLT;
        String mathMLToEdit = null;
        int namespaceIndex = xmlFragment.indexOf(MATH_ML_NAMESPACE.substring(1, MATH_ML_NAMESPACE.length() - 1));
        if (namespaceIndex != -1 && (lastIndexOfLT = (stringBeforeNamespace = xmlFragment.substring(0, namespaceIndex)).lastIndexOf(60)) != -1) {
            String mathMLEndTag;
            String stringAfterNamespace;
            int endMathML;
            String mathmlElemName = null;
            for (int i = lastIndexOfLT + 1; i <= namespaceIndex; ++i) {
                char ch = xmlFragment.charAt(i);
                if (!Character.isWhitespace(ch)) continue;
                mathmlElemName = xmlFragment.substring(lastIndexOfLT + 1, i);
                break;
            }
            if (mathmlElemName != null && (endMathML = (stringAfterNamespace = xmlFragment.substring(namespaceIndex, xmlFragment.length())).indexOf(mathMLEndTag = "</" + mathmlElemName + ">")) != -1) {
                mathMLToEdit = xmlFragment.substring(lastIndexOfLT, namespaceIndex + endMathML + mathMLEndTag.length());
            }
        }
        return mathMLToEdit;
    }
}

