/*
 * Decompiled with CFR 0.152.
 */
package ro.sync.ecss.extensions.commons.operations;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import ro.sync.annotations.api.API;
import ro.sync.annotations.api.APIType;
import ro.sync.annotations.api.SourceType;
import ro.sync.ecss.common.CommonAccess;
import ro.sync.ecss.extensions.api.ArgumentDescriptor;
import ro.sync.ecss.extensions.api.ArgumentsMap;
import ro.sync.ecss.extensions.api.AuthorAccess;
import ro.sync.ecss.extensions.api.AuthorDocumentController;
import ro.sync.ecss.extensions.api.AuthorOperation;
import ro.sync.ecss.extensions.api.AuthorOperationException;
import ro.sync.ecss.extensions.api.WebappCompatible;
import ro.sync.ecss.extensions.api.XPathVersion;
import ro.sync.ecss.extensions.api.node.AuthorElement;
import ro.sync.ecss.extensions.api.node.AuthorNode;
import ro.sync.exml.workspace.api.editor.transformation.TransformationFeedback;
import ro.sync.exml.workspace.api.editor.transformation.TransformationScenarioNotFoundException;

@API(type=APIType.INTERNAL, src=SourceType.PUBLIC)
@WebappCompatible(value=false)
public class ExecuteCustomizableTransformationScenarioOperation
implements AuthorOperation {
    private static final String XPATH_EXPRESSION_CURRENT_ELEMENT = ".";
    private static final String MARK_IN_PROGRESS_PSEUDO_CLASS = "-oxy-transformation-in-progress";
    private static final String MARK_OTHERS_IN_PROGRESS_PSEUDO_CLASS = "-oxy-transformation-in-progress-others";
    private static final Splitter SPLITTER_ON_END_LINE = Splitter.on((String)"\n").trimResults();
    private static final Splitter SPLITTER_ON_EQUALS = Splitter.on((String)"=").trimResults();
    private ArgumentDescriptor[] arguments = new ArgumentDescriptor[4];
    private static final String SCENARIO_NAME = "scenarioName";
    private static final String SCENARIO_PARAMETERS = "scenarioParameters";
    private static final String MARK_IN_PROGRESS_XPATH_LOCATION = "markInProgressXPathLocation";
    private static final String MARK_OTHERS_IN_PROGRESS_XPATH_LOCATION = "markOthersInProgressXPathLocation";

    public ExecuteCustomizableTransformationScenarioOperation() {
        ArgumentDescriptor argumentDescriptor;
        this.arguments[0] = argumentDescriptor = new ArgumentDescriptor(SCENARIO_NAME, 0, "The name of the transformation scenario which will be executed.");
        this.arguments[1] = argumentDescriptor = new ArgumentDescriptor(SCENARIO_PARAMETERS, 0, "Provided parameters for the transformation scenario.\nParameters are inserted as name=value pairs separated by line breaks.\nThe set parameters are taken into account for XSLT, DITA, Chemistry and ANT Transformation scenario types.");
        this.arguments[2] = argumentDescriptor = new ArgumentDescriptor(MARK_IN_PROGRESS_XPATH_LOCATION, 0, "XPath expression that identifies the element(s) on which a specific  '-oxy-transformation-in-progress' pseudo class is set before transformation is started.The pseudo class is reset when the transformation ends.If this XPath expression is not defined, the current node is used.");
        this.arguments[3] = argumentDescriptor = new ArgumentDescriptor(MARK_OTHERS_IN_PROGRESS_XPATH_LOCATION, 0, "XPath expression that indentifies other elements on which a specific '-oxy-transformation-in-progress-others' pseudo class is set before the transformation is started.The pseudo class is reset when the transformation ends.");
    }

    public String getDescription() {
        return "Run a named transformation scenario with specific parameters defined in the associated document type.";
    }

    public void doOperation(AuthorAccess authorAccess, ArgumentsMap args) throws AuthorOperationException {
        Object scenarioName = args.getArgumentValue(SCENARIO_NAME);
        Object paramsArgument = args.getArgumentValue(SCENARIO_PARAMETERS);
        if (scenarioName == null) {
            throw new AuthorOperationException("The scenario name was not specified as a parameter.");
        }
        Map scenarioArguments = null;
        if (paramsArgument instanceof String && !((String)paramsArgument).trim().isEmpty()) {
            try {
                scenarioArguments = SPLITTER_ON_END_LINE.withKeyValueSeparator(SPLITTER_ON_EQUALS).split((CharSequence)String.valueOf(paramsArgument));
            }
            catch (IllegalArgumentException e) {
                throw new AuthorOperationException("The arguments should be defined as key=value pairs.");
            }
        }
        String xpathOfCurrentProcessedNode = Optional.ofNullable(args.getArgumentValue(MARK_IN_PROGRESS_XPATH_LOCATION)).map(String.class::cast).map(String::trim).filter(t -> !t.isEmpty()).orElse(XPATH_EXPRESSION_CURRENT_ELEMENT);
        String xpathOfOtherNodesLikeMeThatWontBeProcessedNow = Optional.ofNullable(args.getArgumentValue(MARK_OTHERS_IN_PROGRESS_XPATH_LOCATION)).map(String.class::cast).orElse(null);
        final AuthorDocumentController ctrl = authorAccess.getDocumentController();
        final List<AuthorElement> current = ExecuteCustomizableTransformationScenarioOperation.findElementsByXPath(ctrl, xpathOfCurrentProcessedNode);
        final List<AuthorElement> others = ExecuteCustomizableTransformationScenarioOperation.findElementsByXPath(ctrl, xpathOfOtherNodesLikeMeThatWontBeProcessedNow);
        others.removeAll(current);
        ExecuteCustomizableTransformationScenarioOperation.setPseudoClassToElements(ctrl, current, MARK_IN_PROGRESS_PSEUDO_CLASS);
        ExecuteCustomizableTransformationScenarioOperation.setPseudoClassToElements(ctrl, others, MARK_OTHERS_IN_PROGRESS_PSEUDO_CLASS);
        TransformationFeedback transformationFeedback = new TransformationFeedback(){

            public void transformationStopped() {
                ExecuteCustomizableTransformationScenarioOperation.removePseudoClassToElements(ctrl, current, ExecuteCustomizableTransformationScenarioOperation.MARK_IN_PROGRESS_PSEUDO_CLASS);
                ExecuteCustomizableTransformationScenarioOperation.removePseudoClassToElements(ctrl, others, ExecuteCustomizableTransformationScenarioOperation.MARK_OTHERS_IN_PROGRESS_PSEUDO_CLASS);
            }

            public void transformationFinished(boolean success) {
                ExecuteCustomizableTransformationScenarioOperation.removePseudoClassToElements(ctrl, current, ExecuteCustomizableTransformationScenarioOperation.MARK_IN_PROGRESS_PSEUDO_CLASS);
                ExecuteCustomizableTransformationScenarioOperation.removePseudoClassToElements(ctrl, others, ExecuteCustomizableTransformationScenarioOperation.MARK_OTHERS_IN_PROGRESS_PSEUDO_CLASS);
            }
        };
        try {
            authorAccess.getEditorAccess().runTransformationScenario(String.valueOf(scenarioName), scenarioArguments, transformationFeedback);
        }
        catch (TransformationScenarioNotFoundException e) {
            throw new AuthorOperationException(e.getMessage(), (Throwable)e);
        }
    }

    public ArgumentDescriptor[] getArguments() {
        return this.arguments;
    }

    private static List<AuthorElement> findElementsByXPath(AuthorDocumentController ctrl, String xpath) throws AuthorOperationException {
        AuthorNode[] nodesFound;
        ArrayList<AuthorElement> elements = new ArrayList<AuthorElement>();
        if (xpath == null) {
            return elements;
        }
        for (AuthorNode authorNode : nodesFound = ctrl.findNodesByXPath(xpath, null, true, true, true, false, XPathVersion.XPATH_2_0, true)) {
            if (authorNode.getType() != 0) continue;
            elements.add((AuthorElement)authorNode);
        }
        return elements;
    }

    private static void setPseudoClassToElements(AuthorDocumentController ctrl, List<AuthorElement> elements, String pseudoClass) {
        if (pseudoClass != null) {
            CommonAccess.invokeLater(() -> elements.forEach(el -> ctrl.setPseudoClass(pseudoClass, el)));
        }
    }

    private static void removePseudoClassToElements(AuthorDocumentController ctrl, List<AuthorElement> elements, String pseudoClass) {
        if (pseudoClass != null) {
            CommonAccess.invokeLater(() -> elements.forEach(el -> ctrl.removePseudoClass(pseudoClass, el)));
        }
    }
}

